/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.Gauge;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.GarbageCollectorExports;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.MemoryPoolsExports;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.StandardExports;
import org.apache.pulsar.shade.io.prometheus.client.hotspot.ThreadExports;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.CachingStatsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.PrometheusServlet;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.PrometheusStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.PrometheusTextFormatUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.SimpleGauge;
import org.apache.pulsar.shade.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsProvider
implements StatsProvider {
    private ScheduledExecutorService executor;
    public static final String PROMETHEUS_STATS_HTTP_ENABLE = "prometheusStatsHttpEnable";
    public static final boolean DEFAULT_PROMETHEUS_STATS_HTTP_ENABLE = true;
    public static final String PROMETHEUS_STATS_HTTP_PORT = "prometheusStatsHttpPort";
    public static final int DEFAULT_PROMETHEUS_STATS_HTTP_PORT = 8000;
    public static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    public static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    final CollectorRegistry registry;
    Server server;
    private final CachingStatsProvider cachingStatsProvider;
    final ConcurrentMap<String, LongAdderCounter> counters = new ConcurrentSkipListMap<String, LongAdderCounter>();
    final ConcurrentMap<String, SimpleGauge<? extends Number>> gauges = new ConcurrentSkipListMap<String, SimpleGauge<? extends Number>>();
    final ConcurrentMap<String, DataSketchesOpStatsLogger> opStats = new ConcurrentSkipListMap<String, DataSketchesOpStatsLogger>();
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private static final AtomicLong directMemoryUsage;

    public PrometheusMetricsProvider() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsProvider(CollectorRegistry registry) {
        this.registry = registry;
        this.cachingStatsProvider = new CachingStatsProvider(new StatsProvider(){

            @Override
            public void start(Configuration conf) {
            }

            @Override
            public void stop() {
            }

            @Override
            public StatsLogger getStatsLogger(String scope) {
                return new PrometheusStatsLogger(PrometheusMetricsProvider.this, scope);
            }

            @Override
            public String getStatsName(String ... statsComponents) {
                if (statsComponents.length == 0) {
                    return "";
                }
                String completeName = statsComponents[0].isEmpty() ? StringUtils.join((Object[])statsComponents, '_', 1, statsComponents.length) : StringUtils.join((Object[])statsComponents, '_');
                return Collector.sanitizeMetricName(completeName);
            }
        });
    }

    @Override
    public void start(Configuration conf) {
        boolean httpEnabled = conf.getBoolean(PROMETHEUS_STATS_HTTP_ENABLE, true);
        boolean bkHttpServerEnabled = conf.getBoolean("httpServerEnabled", false);
        if (httpEnabled && !bkHttpServerEnabled) {
            int httpPort = conf.getInt(PROMETHEUS_STATS_HTTP_PORT, 8000);
            InetSocketAddress httpEndpoint = InetSocketAddress.createUnresolved("0.0.0.0", httpPort);
            this.server = new Server(httpEndpoint);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            this.server.setHandler(context);
            context.addServlet(new ServletHolder(new PrometheusServlet(this)), "/metrics");
            try {
                this.server.start();
                log.info("Started Prometheus stats endpoint at {}", (Object)httpEndpoint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.registerMetrics(new StandardExports());
        this.registerMetrics(new MemoryPoolsExports());
        this.registerMetrics(new GarbageCollectorExports());
        this.registerMetrics(new ThreadExports());
        this.registerMetrics((Collector)Gauge.build("jvm_memory_direct_bytes_used", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return directMemoryUsage != null ? (double)directMemoryUsage.longValue() : Double.NaN;
            }
        }, new String[0]));
        this.registerMetrics((Collector)Gauge.build("jvm_memory_direct_bytes_max", "-").create().setChild(new Gauge.Child(){

            @Override
            public double get() {
                return PlatformDependent.maxDirectMemory();
            }
        }, new String[0]));
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.warn("Failed to shutdown Jetty server", (Throwable)e);
            }
        }
    }

    @Override
    public StatsLogger getStatsLogger(String scope) {
        return this.cachingStatsProvider.getStatsLogger(scope);
    }

    @Override
    public void writeAllMetrics(Writer writer) throws IOException {
        PrometheusTextFormatUtil.writeMetricsCollectedByPrometheusClient(writer, this.registry);
        this.gauges.forEach((name, gauge) -> PrometheusTextFormatUtil.writeGauge(writer, name, gauge));
        this.counters.forEach((name, counter) -> PrometheusTextFormatUtil.writeCounter(writer, name, counter));
        this.opStats.forEach((name, opStatLogger) -> PrometheusTextFormatUtil.writeOpStat(writer, name, opStatLogger));
    }

    @Override
    public String getStatsName(String ... statsComponents) {
        return this.cachingStatsProvider.getStatsName(statsComponents);
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }

    private void registerMetrics(Collector collector) {
        block2: {
            try {
                collector.register(this.registry);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to register Prometheus collector exports", (Throwable)e);
            }
        }
    }

    static {
        AtomicLong tmpDirectMemoryUsage = null;
        try {
            Field field = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
            field.setAccessible(true);
            tmpDirectMemoryUsage = (AtomicLong)field.get(null);
        }
        catch (Throwable t) {
            log.warn("Failed to access netty DIRECT_MEMORY_COUNTER field {}", (Object)t.getMessage());
        }
        directMemoryUsage = tmpDirectMemoryUsage;
    }
}

