/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.dlog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.bk.LedgerMetadata;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.LogEmptyException;
import org.apache.distributedlog.exceptions.LogExistsException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.util.Utils;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.dlog.DLInputStream;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.dlog.DLOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLCheckpointStore
implements CheckpointStore {
    private static final Logger log = LoggerFactory.getLogger(DLCheckpointStore.class);
    private final Namespace namespace;

    public DLCheckpointStore(Namespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public List<String> listFiles(String filePath) throws IOException {
        return Lists.newArrayList(this.namespace.getLogs(filePath));
    }

    @Override
    public boolean fileExists(String filePath) throws IOException {
        return this.namespace.logExists(filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getFileLength(String filePath) throws IOException {
        try (DistributedLogManager dlm = this.namespace.openLog(filePath);){
            long l = dlm.getLastTxId();
            return l;
        }
        catch (LogNotFoundException e) {
            throw new FileNotFoundException(filePath);
        }
        catch (LogEmptyException e) {
            return 0L;
        }
    }

    @Override
    public InputStream openInputStream(String filePath) throws IOException {
        try {
            LogReader reader;
            DistributedLogManager dlm = this.namespace.openLog(filePath);
            try {
                reader = dlm.openLogReader(DLSN.InitialDLSN);
            }
            catch (LogEmptyException | LogNotFoundException e) {
                throw new FileNotFoundException(filePath);
            }
            return new BufferedInputStream(new DLInputStream(dlm, reader, 0L), 131072);
        }
        catch (LogNotFoundException e) {
            throw new FileNotFoundException(filePath);
        }
    }

    @Override
    public OutputStream openOutputStream(String filePath) throws IOException {
        try {
            DistributedLogManager dlm = this.namespace.openLog(filePath);
            LedgerMetadata metadata = new LedgerMetadata();
            metadata.setApplication("bk-stream-storage-service");
            metadata.setComponent("checkpoint-store");
            AsyncLogWriter writer = (AsyncLogWriter)Utils.ioResult((CompletableFuture)dlm.openAsyncLogWriter(metadata));
            return new BufferedOutputStream(new DLOutputStream(dlm, writer), 131072);
        }
        catch (LogNotFoundException le) {
            throw new FileNotFoundException(filePath);
        }
    }

    @Override
    public void rename(String srcLog, String dstLog) throws IOException {
        log.info("Renaming {} to {}", (Object)srcLog, (Object)dstLog);
        try {
            this.namespace.renameLog(srcLog, dstLog).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted at renaming " + srcLog + " to " + dstLog, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof LogExistsException) {
                throw new FileAlreadyExistsException("Dest file already exists : " + dstLog);
            }
            if (e.getCause() instanceof LogNotFoundException) {
                throw new NoSuchFileException("Src file or dest directory is not found");
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Failed to rename " + srcLog + " to " + dstLog, e.getCause());
        }
    }

    @Override
    public void deleteRecursively(String srcPath) throws IOException {
        Iterator logs = this.namespace.getLogs(srcPath);
        while (logs.hasNext()) {
            String child = (String)logs.next();
            this.deleteRecursively(srcPath + "/" + child);
        }
        this.namespace.deleteLog(srcPath);
    }

    @Override
    public void delete(String srcPath) throws IOException {
        this.namespace.deleteLog(srcPath);
    }

    @Override
    public void createDirectories(String srcPath) throws IOException {
        this.namespace.createLog(srcPath);
    }

    @Override
    public void close() {
        this.namespace.close();
    }
}

