/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCounted;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.util.AbstractCASReferenceCounted;

public final class EntryImpl
extends AbstractCASReferenceCounted
implements Entry,
Comparable<EntryImpl>,
ReferenceCounted {
    private static final Recycler<EntryImpl> RECYCLER = new Recycler<EntryImpl>(){

        @Override
        protected EntryImpl newObject(Recycler.Handle<EntryImpl> handle) {
            return new EntryImpl(handle);
        }
    };
    private final Recycler.Handle<EntryImpl> recyclerHandle;
    private long timestamp;
    private long ledgerId;
    private long entryId;
    ByteBuf data;

    public static EntryImpl create(LedgerEntry ledgerEntry) {
        EntryImpl entry = RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerEntry.getLedgerId();
        entry.entryId = ledgerEntry.getEntryId();
        entry.data = ledgerEntry.getEntryBuffer();
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(long ledgerId, long entryId, byte[] data) {
        EntryImpl entry = RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = Unpooled.wrappedBuffer(data);
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(long ledgerId, long entryId, ByteBuf data) {
        EntryImpl entry = RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = ledgerId;
        entry.entryId = entryId;
        entry.data = data;
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(PositionImpl position, ByteBuf data) {
        EntryImpl entry = RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = position.getLedgerId();
        entry.entryId = position.getEntryId();
        entry.data = data;
        entry.data.retain();
        entry.setRefCnt(1);
        return entry;
    }

    public static EntryImpl create(EntryImpl other) {
        EntryImpl entry = RECYCLER.get();
        entry.timestamp = System.nanoTime();
        entry.ledgerId = other.ledgerId;
        entry.entryId = other.entryId;
        entry.data = other.data.retainedDuplicate();
        entry.setRefCnt(1);
        return entry;
    }

    private EntryImpl(Recycler.Handle<EntryImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public ByteBuf getDataBuffer() {
        return this.data;
    }

    @Override
    public byte[] getData() {
        byte[] array = new byte[this.data.readableBytes()];
        this.data.getBytes(this.data.readerIndex(), array);
        return array;
    }

    @Override
    public byte[] getDataAndRelease() {
        byte[] array = this.getData();
        this.release();
        return array;
    }

    @Override
    public int getLength() {
        return this.data.readableBytes();
    }

    @Override
    public PositionImpl getPosition() {
        return new PositionImpl(this.ledgerId, this.entryId);
    }

    @Override
    public long getLedgerId() {
        return this.ledgerId;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public int compareTo(EntryImpl other) {
        return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).result();
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        return this;
    }

    @Override
    protected void deallocate() {
        this.data.release();
        this.data = null;
        this.timestamp = -1L;
        this.ledgerId = -1L;
        this.entryId = -1L;
        this.recyclerHandle.recycle(this);
    }
}

