/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import java.util.List;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class NameResolverProviderFactory
extends NameResolver.Factory {
    private final List<NameResolverProvider> providers;

    public NameResolverProviderFactory(List<NameResolverProvider> providers) {
        this.providers = providers;
    }

    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        this.checkForProviders();
        for (NameResolverProvider provider : this.providers) {
            NameResolver resolver = provider.newNameResolver(targetUri, params);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    public String getDefaultScheme() {
        this.checkForProviders();
        return this.providers.get(0).getDefaultScheme();
    }

    private void checkForProviders() {
        Preconditions.checkState(!this.providers.isEmpty(), "No NameResolverProviders found. Please check your configuration");
    }
}

