/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.util.concurrent.SettableFuture;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieThread;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.CheckpointSourceList;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Cookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.HandleFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.HandleFactoryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Journal;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDescriptor;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsMonitor;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerStorageFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LogMark;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.StateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.SyncThread;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.stats.BookieStats;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Watcher;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNS;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.SimpleBookieServiceInfoProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.IOUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.MathUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.shade.org.apache.commons.io.FileUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bookie
extends BookieCriticalThread {
    private static final Logger LOG = LoggerFactory.getLogger(Bookie.class);
    final List<File> journalDirectories;
    final ServerConfiguration conf;
    final SyncThread syncThread;
    final LedgerManagerFactory ledgerManagerFactory;
    final LedgerManager ledgerManager;
    final LedgerStorage ledgerStorage;
    final List<Journal> journals;
    final HandleFactory handles;
    final boolean entryLogPerLedgerEnabled;
    public static final long METAENTRY_ID_LEDGER_KEY = -4096L;
    public static final long METAENTRY_ID_FENCE_KEY = -8192L;
    public static final long METAENTRY_ID_FORCE_LEDGER = -16384L;
    static final long METAENTRY_ID_LEDGER_EXPLICITLAC = -32768L;
    private final LedgerDirsManager ledgerDirsManager;
    protected final Supplier<BookieServiceInfo> bookieServiceInfoProvider;
    private final LedgerDirsManager indexDirsManager;
    LedgerDirsMonitor dirsMonitor;
    protected final MetadataBookieDriver metadataDriver;
    private int exitCode = 0;
    private final ConcurrentLongHashMap<byte[]> masterKeyCache = new ConcurrentLongHashMap();
    protected StateManager stateManager;
    final StatsLogger statsLogger;
    private final BookieStats bookieStats;
    private final ByteBufAllocator allocator;
    AtomicBoolean shutdownTriggered = new AtomicBoolean(false);

    public static void checkDirectoryStructure(File dir) throws IOException {
        if (!dir.exists()) {
            File parent = dir.getParentFile();
            File preV3versionFile = new File(dir.getParent(), "VERSION");
            final AtomicBoolean oldDataExists = new AtomicBoolean(false);
            parent.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.endsWith(".txn") || name.endsWith(".idx") || name.endsWith(".log")) {
                        oldDataExists.set(true);
                    }
                    return true;
                }
            });
            if (preV3versionFile.exists() || oldDataExists.get()) {
                String err = "Directory layout version is less than 3, upgrade needed";
                LOG.error(err);
                throw new IOException(err);
            }
            if (!dir.mkdirs()) {
                String err = "Unable to create directory " + dir;
                LOG.error(err);
                throw new IOException(err);
            }
        }
    }

    private void checkEnvironment(MetadataBookieDriver metadataDriver) throws BookieException, IOException {
        ArrayList<File> allLedgerDirs = new ArrayList<File>(this.ledgerDirsManager.getAllLedgerDirs().size() + this.indexDirsManager.getAllLedgerDirs().size());
        allLedgerDirs.addAll(this.ledgerDirsManager.getAllLedgerDirs());
        if (this.indexDirsManager != this.ledgerDirsManager) {
            allLedgerDirs.addAll(this.indexDirsManager.getAllLedgerDirs());
        }
        if (metadataDriver == null) {
            for (File journalDirectory : this.journalDirectories) {
                Bookie.checkDirectoryStructure(journalDirectory);
            }
            for (File dir : allLedgerDirs) {
                Bookie.checkDirectoryStructure(dir);
            }
            return;
        }
        Bookie.checkEnvironmentWithStorageExpansion(this.conf, metadataDriver, this.journalDirectories, allLedgerDirs);
        this.checkIfDirsOnSameDiskPartition(allLedgerDirs);
        this.checkIfDirsOnSameDiskPartition(this.journalDirectories);
    }

    private void checkIfDirsOnSameDiskPartition(List<File> dirs) throws BookieException.DiskPartitionDuplicationException {
        boolean allowDiskPartitionDuplication = this.conf.isAllowMultipleDirsUnderSameDiskPartition();
        MutableBoolean isDuplicationFoundAndNotAllowed = new MutableBoolean(false);
        HashMap<FileStore, List> fileStoreDirsMap = new HashMap<FileStore, List>();
        for (File dir : dirs) {
            FileStore fileStore2;
            try {
                fileStore2 = Files.getFileStore(dir.toPath());
            }
            catch (IOException e) {
                LOG.error("Got IOException while trying to FileStore of {}", (Object)dir);
                throw new BookieException.DiskPartitionDuplicationException(e);
            }
            if (fileStoreDirsMap.containsKey(fileStore2)) {
                ((List)fileStoreDirsMap.get(fileStore2)).add(dir);
                continue;
            }
            ArrayList<File> dirsList2 = new ArrayList<File>();
            dirsList2.add(dir);
            fileStoreDirsMap.put(fileStore2, dirsList2);
        }
        fileStoreDirsMap.forEach((fileStore, dirsList) -> {
            if (dirsList.size() > 1) {
                if (allowDiskPartitionDuplication) {
                    LOG.warn("Dirs: {} are in same DiskPartition/FileSystem: {}", dirsList, fileStore);
                } else {
                    LOG.error("Dirs: {} are in same DiskPartition/FileSystem: {}", dirsList, fileStore);
                    isDuplicationFoundAndNotAllowed.setValue(true);
                }
            }
        });
        if (isDuplicationFoundAndNotAllowed.getValue().booleanValue()) {
            throw new BookieException.DiskPartitionDuplicationException();
        }
    }

    static List<BookieId> possibleBookieIds(ServerConfiguration conf) throws BookieException {
        ArrayList<BookieId> addresses = Lists.newArrayListWithExpectedSize(3);
        try {
            addresses.add(Bookie.getBookieAddress(new ServerConfiguration(conf).setUseHostNameAsBookieID(false).setAdvertisedAddress(null).setAllowLoopback(true)).toBookieId());
            addresses.add(Bookie.getBookieAddress(new ServerConfiguration(conf).setUseHostNameAsBookieID(true).setAdvertisedAddress(null).setAllowLoopback(true)).toBookieId());
            if (null != conf.getAdvertisedAddress()) {
                addresses.add(Bookie.getBookieAddress(conf).toBookieId());
            }
            if (null != conf.getBookieId()) {
                addresses.add(BookieId.parse(conf.getBookieId()));
            }
        }
        catch (UnknownHostException e) {
            throw new BookieException.UnknownBookieIdException(e);
        }
        return addresses;
    }

    static Versioned<Cookie> readAndVerifyCookieFromRegistrationManager(Cookie masterCookie, RegistrationManager rm, List<BookieId> addresses, boolean allowExpansion) throws BookieException {
        Versioned<Cookie> rmCookie = null;
        for (BookieId address : addresses) {
            try {
                rmCookie = Cookie.readFromRegistrationManager(rm, address);
                if (allowExpansion) {
                    masterCookie.verifyIsSuperSet(rmCookie.getValue());
                    continue;
                }
                masterCookie.verify(rmCookie.getValue());
            }
            catch (BookieException.CookieNotFoundException e) {}
        }
        return rmCookie;
    }

    private static Pair<List<File>, List<Cookie>> verifyAndGetMissingDirs(Cookie masterCookie, boolean allowExpansion, List<File> dirs) throws BookieException.InvalidCookieException, IOException {
        ArrayList<File> missingDirs = Lists.newArrayList();
        ArrayList<Cookie> existedCookies = Lists.newArrayList();
        for (File dir : dirs) {
            Bookie.checkDirectoryStructure(dir);
            try {
                Cookie c = Cookie.readFromDirectory(dir);
                if (allowExpansion) {
                    masterCookie.verifyIsSuperSet(c);
                } else {
                    masterCookie.verify(c);
                }
                existedCookies.add(c);
            }
            catch (FileNotFoundException fnf) {
                missingDirs.add(dir);
            }
        }
        return Pair.of(missingDirs, existedCookies);
    }

    private static void stampNewCookie(ServerConfiguration conf, Cookie masterCookie, RegistrationManager rm, Version version, List<File> journalDirectories, List<File> allLedgerDirs) throws BookieException, IOException {
        LOG.info("Stamping new cookies on all dirs {} {}", journalDirectories, allLedgerDirs);
        for (File journalDirectory : journalDirectories) {
            masterCookie.writeToDirectory(journalDirectory);
        }
        for (File dir : allLedgerDirs) {
            masterCookie.writeToDirectory(dir);
        }
        masterCookie.writeToRegistrationManager(rm, conf, version);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkEnvironmentWithStorageExpansion(ServerConfiguration conf, MetadataBookieDriver metadataDriver, List<File> journalDirectories, List<File> allLedgerDirs) throws BookieException {
        RegistrationManager rm = metadataDriver.getRegistrationManager();
        try {
            String instanceId = rm.getClusterInstanceId();
            Cookie.Builder builder = Cookie.generateCookie(conf);
            if (null != instanceId) {
                builder.setInstanceId(instanceId);
            }
            Cookie masterCookie = builder.build();
            boolean allowExpansion = conf.getAllowStorageExpansion();
            List<BookieId> possibleBookieIds = Bookie.possibleBookieIds(conf);
            Versioned<Cookie> rmCookie = Bookie.readAndVerifyCookieFromRegistrationManager(masterCookie, rm, possibleBookieIds, allowExpansion);
            ArrayList<File> missedCookieDirs = new ArrayList<File>();
            ArrayList<Cookie> existingCookies = Lists.newArrayList();
            if (null != rmCookie) {
                existingCookies.add(rmCookie.getValue());
            }
            Pair<List<File>, List<Cookie>> journalResult = Bookie.verifyAndGetMissingDirs(masterCookie, allowExpansion, journalDirectories);
            missedCookieDirs.addAll((Collection)journalResult.getLeft());
            existingCookies.addAll((Collection)journalResult.getRight());
            Pair<List<File>, List<Cookie>> ledgerResult = Bookie.verifyAndGetMissingDirs(masterCookie, allowExpansion, allLedgerDirs);
            missedCookieDirs.addAll((Collection)ledgerResult.getLeft());
            existingCookies.addAll((Collection)ledgerResult.getRight());
            if (missedCookieDirs.isEmpty()) {
                if (rmCookie != null) return;
                LOG.error("Cookie for this bookie is not stored in metadata store. Bookie failing to come up");
                throw new BookieException.InvalidCookieException();
            }
            if (rmCookie == null) {
                Bookie.verifyDirsForNewEnvironment(missedCookieDirs);
                Bookie.stampNewCookie(conf, masterCookie, rm, Version.NEW, journalDirectories, allLedgerDirs);
                return;
            }
            if (allowExpansion) {
                Set<File> knownDirs = Bookie.getKnownDirs(existingCookies);
                Bookie.verifyDirsForStorageExpansion(missedCookieDirs, knownDirs);
                Bookie.stampNewCookie(conf, masterCookie, rm, rmCookie.getVersion(), journalDirectories, allLedgerDirs);
                return;
            }
            LOG.error("There are directories without a cookie, and this is neither a new environment, nor is storage expansion enabled. Empty directories are {}", missedCookieDirs);
            throw new BookieException.InvalidCookieException();
        }
        catch (IOException ioe) {
            LOG.error("Error accessing cookie on disks", (Throwable)ioe);
            throw new BookieException.InvalidCookieException(ioe);
        }
    }

    private static void verifyDirsForNewEnvironment(List<File> missedCookieDirs) throws BookieException.InvalidCookieException {
        ArrayList<File> nonEmptyDirs = new ArrayList<File>();
        for (File dir : missedCookieDirs) {
            String[] content = dir.list();
            if (content == null || content.length == 0) continue;
            nonEmptyDirs.add(dir);
        }
        if (!nonEmptyDirs.isEmpty()) {
            LOG.error("Not all the new directories are empty. New directories that are not empty are: " + nonEmptyDirs);
            throw new BookieException.InvalidCookieException();
        }
    }

    private static Set<File> getKnownDirs(List<Cookie> cookies) {
        return cookies.stream().flatMap(c -> Arrays.stream(c.getLedgerDirPathsFromCookie())).map(s -> new File((String)s)).collect(Collectors.toSet());
    }

    private static void verifyDirsForStorageExpansion(List<File> missedCookieDirs, Set<File> existingLedgerDirs) throws BookieException.InvalidCookieException {
        ArrayList<File> dirsMissingData = new ArrayList<File>();
        ArrayList<File> nonEmptyDirs = new ArrayList<File>();
        for (File dir : missedCookieDirs) {
            if (existingLedgerDirs.contains(dir.getParentFile())) {
                dirsMissingData.add(dir);
                continue;
            }
            String[] content = dir.list();
            if (content == null || content.length == 0) continue;
            nonEmptyDirs.add(dir);
        }
        if (dirsMissingData.size() > 0 || nonEmptyDirs.size() > 0) {
            LOG.error("Either not all local directories have cookies or directories being added  newly are not empty. Directories missing cookie file are: " + dirsMissingData + " New directories that are not empty are: " + nonEmptyDirs);
            throw new BookieException.InvalidCookieException();
        }
    }

    public static BookieId getBookieId(ServerConfiguration conf) throws UnknownHostException {
        String customBookieId = conf.getBookieId();
        if (customBookieId != null) {
            return BookieId.parse(customBookieId);
        }
        return Bookie.getBookieAddress(conf).toBookieId();
    }

    public static BookieSocketAddress getBookieAddress(ServerConfiguration conf) throws UnknownHostException {
        BookieSocketAddress addr;
        String hostName;
        InetSocketAddress inetAddr;
        if (conf.getAdvertisedAddress() != null && conf.getAdvertisedAddress().trim().length() > 0) {
            String hostAddress = conf.getAdvertisedAddress().trim();
            return new BookieSocketAddress(hostAddress, conf.getBookiePort());
        }
        String iface = conf.getListeningInterface();
        if (iface == null) {
            iface = "default";
        }
        if ((inetAddr = new InetSocketAddress(hostName = DNS.getDefaultHost(iface), conf.getBookiePort())).isUnresolved()) {
            throw new UnknownHostException("Unable to resolve default hostname: " + hostName + " for interface: " + iface);
        }
        String hostAddress = null;
        InetAddress iAddress = inetAddr.getAddress();
        if (conf.getUseHostNameAsBookieID()) {
            hostAddress = iAddress.getCanonicalHostName();
            if (conf.getUseShortHostName()) {
                hostAddress = hostAddress.split("\\.", 2)[0];
            }
        } else {
            hostAddress = iAddress.getHostAddress();
        }
        if ((addr = new BookieSocketAddress(hostAddress, conf.getBookiePort())).getSocketAddress().getAddress().isLoopbackAddress() && !conf.getAllowLoopback()) {
            throw new UnknownHostException("Trying to listen on loopback address, " + addr + " but this is forbidden by default (see ServerConfiguration#getAllowLoopback()).\nIf this happen, you can consider specifying the network interface to listen on (e.g. listeningInterface=eth0) or specifying the advertised address (e.g. advertisedAddress=172.x.y.z)");
        }
        return addr;
    }

    public LedgerDirsManager getLedgerDirsManager() {
        return this.ledgerDirsManager;
    }

    LedgerDirsManager getIndexDirsManager() {
        return this.indexDirsManager;
    }

    public long getTotalDiskSpace() throws IOException {
        return this.getLedgerDirsManager().getTotalDiskSpace(this.ledgerDirsManager.getAllLedgerDirs());
    }

    public long getTotalFreeSpace() throws IOException {
        return this.getLedgerDirsManager().getTotalFreeSpace(this.ledgerDirsManager.getAllLedgerDirs());
    }

    public static File getCurrentDirectory(File dir) {
        return new File(dir, "current");
    }

    public static File[] getCurrentDirectories(File[] dirs) {
        File[] currentDirs = new File[dirs.length];
        for (int i = 0; i < dirs.length; ++i) {
            currentDirs[i] = Bookie.getCurrentDirectory(dirs[i]);
        }
        return currentDirs;
    }

    public Bookie(ServerConfiguration conf) throws IOException, InterruptedException, BookieException {
        this(conf, NullStatsLogger.INSTANCE, PooledByteBufAllocator.DEFAULT, new SimpleBookieServiceInfoProvider(conf));
    }

    private static LedgerStorage buildLedgerStorage(ServerConfiguration conf) throws IOException {
        String ledgerStorageClass = conf.getLedgerStorageClass();
        LOG.info("Using ledger storage: {}", (Object)ledgerStorageClass);
        return LedgerStorageFactory.createLedgerStorage(ledgerStorageClass);
    }

    public static LedgerStorage mountLedgerStorageOffline(ServerConfiguration conf, LedgerStorage ledgerStorage) throws IOException {
        NullStatsLogger statsLogger = NullStatsLogger.INSTANCE;
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = Bookie.createLedgerDirsManager(conf, diskChecker, statsLogger.scope("ledger"));
        LedgerDirsManager indexDirsManager = Bookie.createIndexDirsManager(conf, diskChecker, statsLogger.scope("index"), ledgerDirsManager);
        if (null == ledgerStorage) {
            ledgerStorage = Bookie.buildLedgerStorage(conf);
        }
        CheckpointSource checkpointSource = new CheckpointSource(){

            @Override
            public CheckpointSource.Checkpoint newCheckpoint() {
                return CheckpointSource.Checkpoint.MAX;
            }

            @Override
            public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
            }
        };
        Checkpointer checkpointer = Checkpointer.NULL;
        ledgerStorage.initialize(conf, null, ledgerDirsManager, indexDirsManager, null, checkpointSource, checkpointer, statsLogger, UnpooledByteBufAllocator.DEFAULT);
        return ledgerStorage;
    }

    public Bookie(final ServerConfiguration conf, StatsLogger statsLogger, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, InterruptedException, BookieException {
        super("Bookie-" + conf.getBookiePort());
        this.bookieServiceInfoProvider = bookieServiceInfoProvider;
        this.statsLogger = statsLogger;
        this.conf = conf;
        this.journalDirectories = Lists.newArrayList();
        for (File journalDirectory : conf.getJournalDirs()) {
            this.journalDirectories.add(Bookie.getCurrentDirectory(journalDirectory));
        }
        DiskChecker diskChecker = Bookie.createDiskChecker(conf);
        this.ledgerDirsManager = Bookie.createLedgerDirsManager(conf, diskChecker, statsLogger.scope("ledger"));
        this.indexDirsManager = Bookie.createIndexDirsManager(conf, diskChecker, statsLogger.scope("index"), this.ledgerDirsManager);
        this.allocator = allocator;
        this.metadataDriver = this.instantiateMetadataDriver(conf);
        this.checkEnvironment(this.metadataDriver);
        try {
            if (this.metadataDriver != null) {
                this.ledgerManagerFactory = this.metadataDriver.getLedgerManagerFactory();
                LOG.info("instantiate ledger manager {}", (Object)this.ledgerManagerFactory.getClass().getName());
                this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
            } else {
                this.ledgerManagerFactory = null;
                this.ledgerManager = null;
            }
        }
        catch (MetadataException e) {
            throw new BookieException.MetadataStoreException("Failed to initialize ledger manager", (Throwable)e);
        }
        this.stateManager = this.initializeStateManager();
        this.stateManager.setShutdownHandler(exitCode -> this.triggerBookieShutdown(exitCode));
        ArrayList<LedgerDirsManager> dirsManagers = new ArrayList<LedgerDirsManager>();
        dirsManagers.add(this.ledgerDirsManager);
        if (this.indexDirsManager != this.ledgerDirsManager) {
            dirsManagers.add(this.indexDirsManager);
        }
        this.dirsMonitor = new LedgerDirsMonitor(conf, diskChecker, dirsManagers);
        try {
            this.dirsMonitor.init();
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException nle) {
            if (!conf.isReadOnlyModeEnabled()) {
                throw nle;
            }
            this.stateManager.transitionToReadOnlyMode();
        }
        this.journals = Lists.newArrayList();
        for (int i = 0; i < this.journalDirectories.size(); ++i) {
            this.journals.add(new Journal(i, this.journalDirectories.get(i), conf, this.ledgerDirsManager, statsLogger.scope("journal"), allocator));
        }
        this.entryLogPerLedgerEnabled = conf.isEntryLogPerLedgerEnabled();
        CheckpointSourceList checkpointSource = new CheckpointSourceList(this.journals);
        this.ledgerStorage = Bookie.buildLedgerStorage(conf);
        boolean isDbLedgerStorage = this.ledgerStorage instanceof DbLedgerStorage;
        this.syncThread = this.entryLogPerLedgerEnabled || isDbLedgerStorage ? new SyncThread(conf, this.getLedgerDirsListener(), this.ledgerStorage, checkpointSource){

            @Override
            public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
            }

            @Override
            public void start() {
                this.executor.scheduleAtFixedRate(() -> this.doCheckpoint(this.checkpointSource.newCheckpoint()), conf.getFlushInterval(), conf.getFlushInterval(), TimeUnit.MILLISECONDS);
            }
        } : new SyncThread(conf, this.getLedgerDirsListener(), this.ledgerStorage, checkpointSource);
        this.ledgerStorage.initialize(conf, this.ledgerManager, this.ledgerDirsManager, this.indexDirsManager, this.stateManager, checkpointSource, this.syncThread, statsLogger, allocator);
        this.handles = new HandleFactoryImpl(this.ledgerStorage);
        this.bookieStats = new BookieStats(statsLogger);
    }

    StateManager initializeStateManager() throws IOException {
        return new BookieStateManager(this.conf, this.statsLogger, this.metadataDriver, this.ledgerDirsManager, this.bookieServiceInfoProvider);
    }

    void readJournal() throws IOException, BookieException {
        long startTs = System.currentTimeMillis();
        Journal.JournalScanner scanner = new Journal.JournalScanner(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void process(int journalVersion, long offset, ByteBuffer recBuff) throws IOException {
                long ledgerId = recBuff.getLong();
                long entryId = recBuff.getLong();
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Replay journal - ledger id : {}, entry id : {}.", (Object)ledgerId, (Object)entryId);
                    }
                    if (entryId == -4096L) {
                        if (journalVersion < 3) throw new IOException("Invalid journal. Contains journalKey  but layout version (" + journalVersion + ") is too old to hold this");
                        int masterKeyLen = recBuff.getInt();
                        byte[] masterKey = new byte[masterKeyLen];
                        recBuff.get(masterKey);
                        Bookie.this.masterKeyCache.put(ledgerId, masterKey);
                        Bookie.this.handles.getHandle(ledgerId, masterKey);
                        return;
                    } else if (entryId == -8192L) {
                        if (journalVersion < 4) throw new IOException("Invalid journal. Contains fenceKey  but layout version (" + journalVersion + ") is too old to hold this");
                        byte[] key = (byte[])Bookie.this.masterKeyCache.get(ledgerId);
                        if (key == null) {
                            key = Bookie.this.ledgerStorage.readMasterKey(ledgerId);
                        }
                        LedgerDescriptor handle = Bookie.this.handles.getHandle(ledgerId, key);
                        handle.setFenced();
                        return;
                    } else if (entryId == -32768L) {
                        if (journalVersion < 6) throw new IOException("Invalid journal. Contains explicitLAC  but layout version (" + journalVersion + ") is too old to hold this");
                        int explicitLacBufLength = recBuff.getInt();
                        ByteBuf explicitLacBuf = Unpooled.buffer(explicitLacBufLength);
                        byte[] explicitLacBufArray = new byte[explicitLacBufLength];
                        recBuff.get(explicitLacBufArray);
                        explicitLacBuf.writeBytes(explicitLacBufArray);
                        byte[] key = (byte[])Bookie.this.masterKeyCache.get(ledgerId);
                        if (key == null) {
                            key = Bookie.this.ledgerStorage.readMasterKey(ledgerId);
                        }
                        LedgerDescriptor handle = Bookie.this.handles.getHandle(ledgerId, key);
                        handle.setExplicitLac(explicitLacBuf);
                        return;
                    } else if (entryId < 0L) {
                        LOG.warn("Read unrecognizable entryId: {} for ledger: {} while replaying Journal. Skipping it", (Object)entryId, (Object)ledgerId);
                        return;
                    } else {
                        byte[] key = (byte[])Bookie.this.masterKeyCache.get(ledgerId);
                        if (key == null) {
                            key = Bookie.this.ledgerStorage.readMasterKey(ledgerId);
                        }
                        LedgerDescriptor handle = Bookie.this.handles.getHandle(ledgerId, key);
                        recBuff.rewind();
                        handle.addEntry(Unpooled.wrappedBuffer(recBuff));
                    }
                    return;
                }
                catch (NoLedgerException nsle) {
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug("Skip replaying entries of ledger {} since it was deleted.", (Object)ledgerId);
                    return;
                }
                catch (BookieException be) {
                    throw new IOException(be);
                }
            }
        };
        for (Journal journal : this.journals) {
            this.replay(journal, scanner);
        }
        long elapsedTs = System.currentTimeMillis() - startTs;
        LOG.info("Finished replaying journal in {} ms.", (Object)elapsedTs);
    }

    private void replay(Journal journal, Journal.JournalScanner scanner) throws IOException {
        LogMark markedLog = journal.getLastLogMark().getCurMark();
        List<Long> logs = Journal.listJournalIds(journal.getJournalDirectory(), journalId -> journalId >= markedLog.getLogFileId());
        if (markedLog.getLogFileId() > 0L && (logs.size() == 0 || logs.get(0).longValue() != markedLog.getLogFileId())) {
            throw new IOException("Recovery log " + markedLog.getLogFileId() + " is missing");
        }
        for (Long id : logs) {
            long logPosition = 0L;
            if (id.longValue() == markedLog.getLogFileId()) {
                logPosition = markedLog.getLogFileOffset();
            }
            LOG.info("Replaying journal {} from position {}", (Object)id, (Object)logPosition);
            long scanOffset = journal.scanJournal(id, logPosition, scanner);
            journal.setLastLogMark(id, scanOffset);
        }
    }

    @Override
    public synchronized void start() {
        this.setDaemon(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("I'm starting a bookie with journal directories {}", (Object)this.journalDirectories.stream().map(File::getName).collect(Collectors.joining(", ")));
        }
        this.dirsMonitor.start();
        try {
            this.readJournal();
        }
        catch (IOException | BookieException ioe) {
            LOG.error("Exception while replaying journals, shutting down", (Throwable)ioe);
            this.shutdown(5);
            return;
        }
        try {
            this.syncThread.requestFlush().get();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupting the fully flush after replaying journals : ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Error on executing a fully flush after replaying journals.");
            this.shutdown(5);
            return;
        }
        if (this.conf.isLocalConsistencyCheckOnStartup()) {
            LOG.info("Running local consistency check on startup prior to accepting IO.");
            List<LedgerStorage.DetectedInconsistency> errors = null;
            try {
                errors = this.ledgerStorage.localConsistencyCheck(Optional.empty());
            }
            catch (IOException e) {
                LOG.error("Got a fatal exception while checking store", (Throwable)e);
                this.shutdown(5);
                return;
            }
            if (errors != null && errors.size() > 0) {
                LOG.error("Bookie failed local consistency check:");
                for (LedgerStorage.DetectedInconsistency error : errors) {
                    LOG.error("Ledger {}, entry {}: ", new Object[]{error.getLedgerId(), error.getEntryId(), error.getException()});
                }
                this.shutdown(5);
                return;
            }
        }
        LOG.info("Finished reading journal, starting bookie");
        this.syncThread.start();
        super.start();
        this.ledgerDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        if (this.indexDirsManager != this.ledgerDirsManager) {
            this.indexDirsManager.addLedgerDirsListener(this.getLedgerDirsListener());
        }
        this.ledgerStorage.start();
        this.stateManager.initState();
        try {
            this.stateManager.registerBookie(true).get();
        }
        catch (Exception e) {
            LOG.error("Couldn't register bookie with zookeeper, shutting down : ", (Throwable)e);
            this.shutdown(4);
        }
    }

    private LedgerDirsManager.LedgerDirsListener getLedgerDirsListener() {
        return new LedgerDirsManager.LedgerDirsListener(){

            @Override
            public void diskFailed(File disk) {
                Bookie.this.triggerBookieShutdown(5);
            }

            @Override
            public void allDisksFull(boolean highPriorityWritesAllowed) {
                Bookie.this.stateManager.setHighPriorityWritesAvailability(highPriorityWritesAllowed);
                Bookie.this.stateManager.transitionToReadOnlyMode();
            }

            @Override
            public void fatalError() {
                LOG.error("Fatal error reported by ledgerDirsManager");
                Bookie.this.triggerBookieShutdown(5);
            }

            @Override
            public void diskWritable(File disk) {
                Bookie.this.stateManager.setHighPriorityWritesAvailability(true);
                Bookie.this.stateManager.transitionToWritableMode();
            }

            @Override
            public void diskJustWritable(File disk) {
                Bookie.this.stateManager.setHighPriorityWritesAvailability(true);
                Bookie.this.stateManager.transitionToWritableMode();
            }
        };
    }

    private MetadataBookieDriver instantiateMetadataDriver(ServerConfiguration conf) throws BookieException {
        try {
            String metadataServiceUriStr = conf.getMetadataServiceUri();
            if (null == metadataServiceUriStr) {
                return null;
            }
            MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(metadataServiceUriStr));
            driver.initialize(conf, () -> {
                this.stateManager.forceToUnregistered();
                this.stateManager.registerBookie(false);
            }, this.statsLogger);
            return driver;
        }
        catch (MetadataException me) {
            throw new BookieException.MetadataStoreException("Failed to initialize metadata bookie driver", (Throwable)me);
        }
        catch (ConfigurationException e) {
            throw new BookieException.BookieIllegalOpException(e);
        }
    }

    public boolean isReadOnly() {
        return this.stateManager.isReadOnly();
    }

    public boolean isAvailableForHighPriorityWrites() {
        return this.stateManager.isAvailableForHighPriorityWrites();
    }

    public boolean isRunning() {
        return this.stateManager.isRunning();
    }

    @Override
    public void run() {
        try {
            for (Journal journal : this.journals) {
                journal.start();
            }
            for (Journal journal : this.journals) {
                journal.joinThread();
            }
            LOG.info("Journal thread(s) quit.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted on running journal thread : ", (Throwable)ie);
        }
        if (!this.stateManager.isShuttingDown()) {
            LOG.error("Journal manager quits unexpectedly.");
            this.triggerBookieShutdown(5);
        }
    }

    void triggerBookieShutdown(final int exitCode) {
        if (!this.shutdownTriggered.compareAndSet(false, true)) {
            return;
        }
        LOG.info("Triggering shutdown of Bookie-{} with exitCode {}", (Object)this.conf.getBookiePort(), (Object)exitCode);
        BookieThread th = new BookieThread("BookieShutdownTrigger"){

            @Override
            public void run() {
                Bookie.this.shutdown(exitCode);
            }
        };
        th.start();
    }

    public int shutdown() {
        return this.shutdown(0);
    }

    synchronized int shutdown(int exitCode) {
        try {
            if (this.isRunning()) {
                LOG.info("Shutting down Bookie-{} with exitCode {}", (Object)this.conf.getBookiePort(), (Object)exitCode);
                if (this.exitCode == 0) {
                    this.exitCode = exitCode;
                }
                this.stateManager.forceToShuttingDown();
                LOG.info("Turning bookie to read only during shut down");
                this.stateManager.forceToReadOnly();
                this.syncThread.shutdown();
                for (Journal journal : this.journals) {
                    journal.shutdown();
                }
                this.join();
                this.ledgerStorage.shutdown();
                try {
                    if (null != this.ledgerManager) {
                        this.ledgerManager.close();
                    }
                    if (null != this.ledgerManagerFactory) {
                        this.ledgerManagerFactory.close();
                    }
                }
                catch (IOException ie) {
                    LOG.error("Failed to close active ledger manager : ", (Throwable)ie);
                }
                this.dirsMonitor.shutdown();
            }
            if (this.metadataDriver != null) {
                this.metadataDriver.close();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted during shutting down bookie : ", (Throwable)ie);
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to shutdown Bookie", (Throwable)e);
            throw e;
        }
        finally {
            this.stateManager.close();
        }
        return this.exitCode;
    }

    @VisibleForTesting
    LedgerDescriptor getLedgerForEntry(ByteBuf entry, byte[] masterKey) throws IOException, BookieException {
        long ledgerId = entry.getLong(entry.readerIndex());
        return this.handles.getHandle(ledgerId, masterKey);
    }

    private Journal getJournal(long ledgerId) {
        return this.journals.get(MathUtils.signSafeMod(ledgerId, this.journals.size()));
    }

    private void addEntryInternal(LedgerDescriptor handle, ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException, InterruptedException {
        byte[] oldValue;
        long ledgerId = handle.getLedgerId();
        long entryId = handle.addEntry(entry);
        this.bookieStats.getWriteBytes().add(entry.readableBytes());
        if (this.masterKeyCache.get(ledgerId) == null && (oldValue = this.masterKeyCache.putIfAbsent(ledgerId, masterKey)) == null) {
            ByteBuffer bb = ByteBuffer.allocate(20 + masterKey.length);
            bb.putLong(ledgerId);
            bb.putLong(-4096L);
            bb.putInt(masterKey.length);
            bb.put(masterKey);
            bb.flip();
            this.getJournal(ledgerId).logAddEntry(bb, false, (BookkeeperInternalCallbacks.WriteCallback)new NopWriteCallback(), null);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding {}@{}", (Object)entryId, (Object)ledgerId);
        }
        this.getJournal(ledgerId).logAddEntry(entry, ackBeforeSync, cb, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveryAddEntry(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException, InterruptedException {
        long requestNanos = MathUtils.nowInNano();
        boolean success = false;
        int entrySize = 0;
        try {
            LedgerDescriptor handle;
            LedgerDescriptor ledgerDescriptor = handle = this.getLedgerForEntry(entry, masterKey);
            synchronized (ledgerDescriptor) {
                entrySize = entry.readableBytes();
                this.addEntryInternal(handle, entry, false, cb, ctx, masterKey);
            }
            success = true;
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            this.stateManager.transitionToReadOnlyMode();
            throw new IOException(e);
        }
        finally {
            long elapsedNanos = MathUtils.elapsedNanos(requestNanos);
            if (success) {
                this.bookieStats.getRecoveryAddEntryStats().registerSuccessfulEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getAddBytesStats().registerSuccessfulValue(entrySize);
            } else {
                this.bookieStats.getRecoveryAddEntryStats().registerFailedEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getAddBytesStats().registerFailedValue(entrySize);
            }
            entry.release();
        }
    }

    private ByteBuf createExplicitLACEntry(long ledgerId, ByteBuf explicitLac) {
        ByteBuf bb = this.allocator.directBuffer(20 + explicitLac.capacity());
        bb.writeLong(ledgerId);
        bb.writeLong(-32768L);
        bb.writeInt(explicitLac.capacity());
        bb.writeBytes(explicitLac);
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitLac(ByteBuf entry, BookkeeperInternalCallbacks.WriteCallback writeCallback, Object ctx, byte[] masterKey) throws IOException, InterruptedException, BookieException {
        try {
            LedgerDescriptor handle;
            long ledgerId = entry.getLong(entry.readerIndex());
            LedgerDescriptor ledgerDescriptor = handle = this.handles.getHandle(ledgerId, masterKey);
            synchronized (ledgerDescriptor) {
                entry.markReaderIndex();
                handle.setExplicitLac(entry);
                entry.resetReaderIndex();
                ByteBuf explicitLACEntry = this.createExplicitLACEntry(ledgerId, entry);
                this.getJournal(ledgerId).logAddEntry(explicitLACEntry, false, writeCallback, ctx);
            }
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            this.stateManager.transitionToReadOnlyMode();
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getExplicitLac(long ledgerId) throws IOException, NoLedgerException {
        ByteBuf lac;
        LedgerDescriptor handle;
        LedgerDescriptor ledgerDescriptor = handle = this.handles.getReadOnlyHandle(ledgerId);
        synchronized (ledgerDescriptor) {
            lac = handle.getExplicitLac();
        }
        return lac;
    }

    public void forceLedger(long ledgerId, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Forcing ledger {}", (Object)ledgerId);
        }
        Journal journal = this.getJournal(ledgerId);
        journal.forceLedger(ledgerId, cb, ctx);
        this.bookieStats.getForceLedgerOps().inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, byte[] masterKey) throws IOException, BookieException, InterruptedException {
        long requestNanos = MathUtils.nowInNano();
        boolean success = false;
        int entrySize = 0;
        try {
            LedgerDescriptor handle;
            LedgerDescriptor ledgerDescriptor = handle = this.getLedgerForEntry(entry, masterKey);
            synchronized (ledgerDescriptor) {
                if (handle.isFenced()) {
                    throw BookieException.create(-101);
                }
                entrySize = entry.readableBytes();
                this.addEntryInternal(handle, entry, ackBeforeSync, cb, ctx, masterKey);
            }
            success = true;
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            this.stateManager.transitionToReadOnlyMode();
            throw new IOException(e);
        }
        finally {
            long elapsedNanos = MathUtils.elapsedNanos(requestNanos);
            if (success) {
                this.bookieStats.getAddEntryStats().registerSuccessfulEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getAddBytesStats().registerSuccessfulValue(entrySize);
            } else {
                this.bookieStats.getAddEntryStats().registerFailedEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getAddBytesStats().registerFailedValue(entrySize);
            }
            entry.release();
        }
    }

    public SettableFuture<Boolean> fenceLedger(long ledgerId, byte[] masterKey) throws IOException, BookieException {
        LedgerDescriptor handle = this.handles.getHandle(ledgerId, masterKey);
        return handle.fenceAndLogInJournal(this.getJournal(ledgerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readEntry(long ledgerId, long entryId) throws IOException, NoLedgerException {
        long requestNanos = MathUtils.nowInNano();
        boolean success = false;
        int entrySize = 0;
        try {
            LedgerDescriptor handle = this.handles.getReadOnlyHandle(ledgerId);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reading {}@{}", (Object)entryId, (Object)ledgerId);
            }
            ByteBuf entry = handle.readEntry(entryId);
            this.bookieStats.getReadBytes().add(entry.readableBytes());
            success = true;
            ByteBuf byteBuf = entry;
            return byteBuf;
        }
        finally {
            long elapsedNanos = MathUtils.elapsedNanos(requestNanos);
            if (success) {
                this.bookieStats.getReadEntryStats().registerSuccessfulEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getReadBytesStats().registerSuccessfulValue(entrySize);
            } else {
                this.bookieStats.getReadEntryStats().registerFailedEvent(elapsedNanos, TimeUnit.NANOSECONDS);
                this.bookieStats.getReadEntryStats().registerFailedValue(entrySize);
            }
        }
    }

    public long readLastAddConfirmed(long ledgerId) throws IOException {
        LedgerDescriptor handle = this.handles.getReadOnlyHandle(ledgerId);
        return handle.getLastAddConfirmed();
    }

    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        LedgerDescriptor handle = this.handles.getReadOnlyHandle(ledgerId);
        return handle.waitForLastAddConfirmedUpdate(previousLAC, watcher);
    }

    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        LedgerDescriptor handle = this.handles.getReadOnlyHandle(ledgerId);
        handle.cancelWaitForLastAddConfirmedUpdate(watcher);
    }

    @VisibleForTesting
    public LedgerStorage getLedgerStorage() {
        return this.ledgerStorage;
    }

    @VisibleForTesting
    public BookieStateManager getStateManager() {
        return (BookieStateManager)this.stateManager;
    }

    @VisibleForTesting
    public LedgerManagerFactory getLedgerManagerFactory() {
        return this.ledgerManagerFactory;
    }

    public ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    public static boolean format(ServerConfiguration conf, boolean isInteractive, boolean force) {
        File[] ledgerDirs;
        for (File journalDir : conf.getJournalDirs()) {
            String[] journalDirFiles;
            String[] stringArray = journalDirFiles = journalDir.exists() && journalDir.isDirectory() ? journalDir.list() : null;
            if (journalDirFiles != null && journalDirFiles.length != 0) {
                try {
                    boolean confirm = false;
                    confirm = !isInteractive ? force : IOUtils.confirmPrompt("Are you sure to format Bookie data..?");
                    if (!confirm) {
                        LOG.error("Bookie format aborted!!");
                        return false;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error during bookie format", (Throwable)e);
                    return false;
                }
            }
            if (Bookie.cleanDir(journalDir)) continue;
            LOG.error("Formatting journal directory failed");
            return false;
        }
        for (File dir : ledgerDirs = conf.getLedgerDirs()) {
            if (Bookie.cleanDir(dir)) continue;
            LOG.error("Formatting ledger directory " + dir + " failed");
            return false;
        }
        File[] indexDirs = conf.getIndexDirs();
        if (null != indexDirs) {
            for (File dir : indexDirs) {
                if (Bookie.cleanDir(dir)) continue;
                LOG.error("Formatting ledger directory " + dir + " failed");
                return false;
            }
        }
        LOG.info("Bookie format completed successfully");
        return true;
    }

    private static boolean cleanDir(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File child : files) {
                    boolean delete = FileUtils.deleteQuietly(child);
                    if (delete) continue;
                    LOG.error("Not able to delete " + child);
                    return false;
                }
            }
        } else if (!dir.mkdirs()) {
            LOG.error("Not able to create the directory " + dir);
            return false;
        }
        return true;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    static DiskChecker createDiskChecker(ServerConfiguration conf) {
        return new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
    }

    static LedgerDirsManager createLedgerDirsManager(ServerConfiguration conf, DiskChecker diskChecker, StatsLogger statsLogger) {
        return new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker, statsLogger);
    }

    static LedgerDirsManager createIndexDirsManager(ServerConfiguration conf, DiskChecker diskChecker, StatsLogger statsLogger, LedgerDirsManager fallback) {
        File[] idxDirs = conf.getIndexDirs();
        if (null == idxDirs) {
            return fallback;
        }
        return new LedgerDirsManager(conf, idxDirs, diskChecker, statsLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException, NoLedgerException {
        long requestNanos = MathUtils.nowInNano();
        boolean success = false;
        try {
            LedgerDescriptor handle = this.handles.getReadOnlyHandle(ledgerId);
            if (LOG.isTraceEnabled()) {
                LOG.trace("GetEntriesOfLedger {}", (Object)ledgerId);
            }
            PrimitiveIterator.OfLong entriesOfLedger = handle.getListOfEntriesOfLedger(ledgerId);
            success = true;
            PrimitiveIterator.OfLong ofLong = entriesOfLedger;
            return ofLong;
        }
        finally {
            long elapsedNanos = MathUtils.elapsedNanos(requestNanos);
            if (success) {
                this.bookieStats.getReadEntryStats().registerSuccessfulEvent(elapsedNanos, TimeUnit.NANOSECONDS);
            } else {
                this.bookieStats.getReadEntryStats().registerFailedEvent(elapsedNanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    static class CounterCallback
    implements BookkeeperInternalCallbacks.WriteCallback {
        int count;

        CounterCallback() {
        }

        @Override
        public synchronized void writeComplete(int rc, long l, long e, BookieId addr, Object ctx) {
            --this.count;
            if (this.count == 0) {
                this.notifyAll();
            }
        }

        public synchronized void incCount() {
            ++this.count;
        }

        public synchronized void waitZero() throws InterruptedException {
            while (this.count > 0) {
                this.wait();
            }
        }
    }

    static class NopWriteCallback
    implements BookkeeperInternalCallbacks.WriteCallback {
        NopWriteCallback() {
        }

        @Override
        public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished writing entry {} @ ledger {} for {} : {}", new Object[]{entryId, ledgerId, addr, rc});
            }
        }
    }

    public static class NoEntryException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long ledgerId;
        private final long entryId;

        public NoEntryException(long ledgerId, long entryId) {
            this("Entry " + entryId + " not found in " + ledgerId, ledgerId, entryId);
        }

        public NoEntryException(String msg, long ledgerId, long entryId) {
            super(msg);
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public long getLedger() {
            return this.ledgerId;
        }

        public long getEntry() {
            return this.entryId;
        }
    }

    public static class NoLedgerException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final long ledgerId;

        public NoLedgerException(long ledgerId) {
            super("Ledger " + ledgerId + " not found");
            this.ledgerId = ledgerId;
        }

        public long getLedgerId() {
            return this.ledgerId;
        }
    }
}

