/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.github.benmanes.caffeine.cache.stats;

import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CacheStats {
    private static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadFailureCount;
    private final long totalLoadTime;
    private final long evictionCount;
    private final long evictionWeight;

    @Deprecated
    public CacheStats(@Nonnegative long hitCount, @Nonnegative long missCount, @Nonnegative long loadSuccessCount, @Nonnegative long loadFailureCount, @Nonnegative long totalLoadTime, @Nonnegative long evictionCount) {
        this(hitCount, missCount, loadSuccessCount, loadFailureCount, totalLoadTime, evictionCount, 0L);
    }

    public CacheStats(@Nonnegative long hitCount, @Nonnegative long missCount, @Nonnegative long loadSuccessCount, @Nonnegative long loadFailureCount, @Nonnegative long totalLoadTime, @Nonnegative long evictionCount, @Nonnegative long evictionWeight) {
        if (hitCount < 0L || missCount < 0L || loadSuccessCount < 0L || loadFailureCount < 0L || totalLoadTime < 0L || evictionCount < 0L || evictionWeight < 0L) {
            throw new IllegalArgumentException();
        }
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.loadSuccessCount = loadSuccessCount;
        this.loadFailureCount = loadFailureCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
        this.evictionWeight = evictionWeight;
    }

    @Nonnull
    public static CacheStats empty() {
        return EMPTY_STATS;
    }

    @Nonnegative
    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    @Nonnegative
    public long hitCount() {
        return this.hitCount;
    }

    @Nonnegative
    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    @Nonnegative
    public long missCount() {
        return this.missCount;
    }

    @Nonnegative
    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    @Nonnegative
    public long loadCount() {
        return this.loadSuccessCount + this.loadFailureCount;
    }

    @Nonnegative
    public long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    @Nonnegative
    public long loadFailureCount() {
        return this.loadFailureCount;
    }

    @Nonnegative
    public double loadFailureRate() {
        long totalLoadCount = this.loadSuccessCount + this.loadFailureCount;
        return totalLoadCount == 0L ? 0.0 : (double)this.loadFailureCount / (double)totalLoadCount;
    }

    @Nonnegative
    public long totalLoadTime() {
        return this.totalLoadTime;
    }

    @Nonnegative
    public double averageLoadPenalty() {
        long totalLoadCount = this.loadSuccessCount + this.loadFailureCount;
        return totalLoadCount == 0L ? 0.0 : (double)this.totalLoadTime / (double)totalLoadCount;
    }

    @Nonnegative
    public long evictionCount() {
        return this.evictionCount;
    }

    @Nonnegative
    public long evictionWeight() {
        return this.evictionWeight;
    }

    @Nonnull
    public CacheStats minus(@Nonnull CacheStats other) {
        return new CacheStats(Math.max(0L, this.hitCount - other.hitCount), Math.max(0L, this.missCount - other.missCount), Math.max(0L, this.loadSuccessCount - other.loadSuccessCount), Math.max(0L, this.loadFailureCount - other.loadFailureCount), Math.max(0L, this.totalLoadTime - other.totalLoadTime), Math.max(0L, this.evictionCount - other.evictionCount), Math.max(0L, this.evictionWeight - other.evictionWeight));
    }

    @Nonnull
    public CacheStats plus(@Nonnull CacheStats other) {
        return new CacheStats(this.hitCount + other.hitCount, this.missCount + other.missCount, this.loadSuccessCount + other.loadSuccessCount, this.loadFailureCount + other.loadFailureCount, this.totalLoadTime + other.totalLoadTime, this.evictionCount + other.evictionCount, this.evictionWeight + other.evictionWeight);
    }

    public int hashCode() {
        return Objects.hash(this.hitCount, this.missCount, this.loadSuccessCount, this.loadFailureCount, this.totalLoadTime, this.evictionCount, this.evictionWeight);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheStats)) {
            return false;
        }
        CacheStats other = (CacheStats)o;
        return this.hitCount == other.hitCount && this.missCount == other.missCount && this.loadSuccessCount == other.loadSuccessCount && this.loadFailureCount == other.loadFailureCount && this.totalLoadTime == other.totalLoadTime && this.evictionCount == other.evictionCount && this.evictionWeight == other.evictionWeight;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", loadSuccessCount=" + this.loadSuccessCount + ", loadFailureCount=" + this.loadFailureCount + ", totalLoadTime=" + this.totalLoadTime + ", evictionCount=" + this.evictionCount + ", evictionWeight=" + this.evictionWeight + '}';
    }
}

