/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.worker.ClusterServiceCoordinator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionAssignmentTailer;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.LeaderService;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.MetricsGenerator;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerStatsManager;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerService {
    private static final Logger log = LoggerFactory.getLogger(WorkerService.class);
    private final WorkerConfig workerConfig;
    private PulsarClient client;
    private FunctionRuntimeManager functionRuntimeManager;
    private FunctionMetaDataManager functionMetaDataManager;
    private ClusterServiceCoordinator clusterServiceCoordinator;
    private Namespace dlogNamespace;
    private StorageAdminClient stateStoreAdminClient;
    private MembershipManager membershipManager;
    private SchedulerManager schedulerManager;
    private volatile boolean isInitialized = false;
    private final ScheduledExecutorService statsUpdater;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private ConnectorsManager connectorsManager;
    private FunctionsManager functionsManager;
    private PulsarAdmin brokerAdmin;
    private PulsarAdmin functionAdmin;
    private final MetricsGenerator metricsGenerator;
    @VisibleForTesting
    private URI dlogUri;
    private LeaderService leaderService;
    private FunctionAssignmentTailer functionAssignmentTailer;
    private final WorkerStatsManager workerStatsManager;

    public WorkerService(WorkerConfig workerConfig, boolean runAsStandalone) {
        this.workerConfig = workerConfig;
        this.statsUpdater = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("worker-stats-updater"));
        this.metricsGenerator = new MetricsGenerator(this.statsUpdater, workerConfig);
        this.workerStatsManager = new WorkerStatsManager(workerConfig, runAsStandalone);
    }

    public WorkerService(WorkerConfig workerConfig) {
        this(workerConfig, false);
    }

    public void start(URI dlogUri, AuthenticationService authenticationService, AuthorizationService authorizationService, ErrorNotifier errorNotifier) throws InterruptedException {
        this.workerStatsManager.startupTimeStart();
        log.info("/** Starting worker id={} **/", (Object)this.workerConfig.getWorkerId());
        try {
            log.info("Worker Configs: {}", (Object)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.workerConfig));
        }
        catch (JsonProcessingException e) {
            log.warn("Failed to print worker configs with error {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            String functionWebServiceUrl;
            DistributedLogConfiguration dlogConf = WorkerUtils.getDlogConf(this.workerConfig);
            try {
                this.dlogNamespace = NamespaceBuilder.newBuilder().conf(dlogConf).clientId("function-worker-" + this.workerConfig.getWorkerId()).uri(dlogUri).build();
            }
            catch (Exception e) {
                log.error("Failed to initialize dlog namespace {} for storing function packages", (Object)dlogUri, (Object)e);
                throw new RuntimeException(e);
            }
            if (this.workerConfig.getStateStorageServiceUrl() != null) {
                StorageClientSettings clientSettings = StorageClientSettings.newBuilder().serviceUri(this.workerConfig.getStateStorageServiceUrl()).build();
                this.stateStoreAdminClient = StorageClientBuilder.newBuilder().withSettings(clientSettings).buildAdmin();
            }
            String string = StringUtils.isNotBlank(this.workerConfig.getFunctionWebServiceUrl()) ? this.workerConfig.getFunctionWebServiceUrl() : (functionWebServiceUrl = this.workerConfig.getTlsEnabled() ? this.workerConfig.getWorkerWebAddressTls() : this.workerConfig.getWorkerWebAddress());
            if (this.workerConfig.isBrokerClientAuthenticationEnabled()) {
                String pulsarClientTlsTrustCertsFilePath = StringUtils.isNotBlank(this.workerConfig.getBrokerClientTrustCertsFilePath()) ? this.workerConfig.getBrokerClientTrustCertsFilePath() : this.workerConfig.getTlsTrustCertsFilePath();
                this.brokerAdmin = WorkerUtils.getPulsarAdminClient(this.workerConfig.getPulsarWebServiceUrl(), this.workerConfig.getBrokerClientAuthenticationPlugin(), this.workerConfig.getBrokerClientAuthenticationParameters(), pulsarClientTlsTrustCertsFilePath, this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsEnableHostnameVerification());
                this.functionAdmin = WorkerUtils.getPulsarAdminClient(functionWebServiceUrl, this.workerConfig.getBrokerClientAuthenticationPlugin(), this.workerConfig.getBrokerClientAuthenticationParameters(), this.workerConfig.getTlsTrustCertsFilePath(), this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsEnableHostnameVerification());
                this.client = WorkerUtils.getPulsarClient(this.workerConfig.getPulsarServiceUrl(), this.workerConfig.getBrokerClientAuthenticationPlugin(), this.workerConfig.getBrokerClientAuthenticationParameters(), this.workerConfig.isUseTls(), pulsarClientTlsTrustCertsFilePath, this.workerConfig.isTlsAllowInsecureConnection(), this.workerConfig.isTlsEnableHostnameVerification());
            } else {
                this.brokerAdmin = WorkerUtils.getPulsarAdminClient(this.workerConfig.getPulsarWebServiceUrl());
                this.functionAdmin = WorkerUtils.getPulsarAdminClient(functionWebServiceUrl);
                this.client = WorkerUtils.getPulsarClient(this.workerConfig.getPulsarServiceUrl());
            }
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getFunctionAssignmentTopic());
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getClusterCoordinationTopic());
            this.brokerAdmin.topics().createNonPartitionedTopic(this.workerConfig.getFunctionMetadataTopic());
            this.schedulerManager = new SchedulerManager(this.workerConfig, this.client, this.brokerAdmin, this.workerStatsManager, errorNotifier);
            this.functionMetaDataManager = new FunctionMetaDataManager(this.workerConfig, this.schedulerManager, this.client, errorNotifier);
            this.connectorsManager = new ConnectorsManager(this.workerConfig);
            this.functionsManager = new FunctionsManager(this.workerConfig);
            String coordinationTopic = this.workerConfig.getClusterCoordinationTopic();
            if (!this.brokerAdmin.topics().getSubscriptions(coordinationTopic).contains("participants")) {
                this.brokerAdmin.topics().createSubscription(coordinationTopic, "participants", MessageId.earliest);
            }
            this.membershipManager = new MembershipManager(this, this.client, this.brokerAdmin);
            this.functionRuntimeManager = new FunctionRuntimeManager(this.workerConfig, this, this.dlogNamespace, this.membershipManager, this.connectorsManager, this.functionsManager, this.functionMetaDataManager, this.workerStatsManager, errorNotifier);
            this.functionAssignmentTailer = new FunctionAssignmentTailer(this.functionRuntimeManager, this.client.newReader(), this.workerConfig, errorNotifier);
            this.leaderService = new LeaderService(this, this.client, this.functionAssignmentTailer, this.schedulerManager, this.functionRuntimeManager, this.functionMetaDataManager, errorNotifier);
            log.info("/** Start Leader Service **/");
            this.leaderService.start();
            log.info("/** Initializing Metdata Manager **/");
            this.functionMetaDataManager.initialize();
            log.info("/** Initializing Runtime Manager **/");
            MessageId lastAssignmentMessageId = this.functionRuntimeManager.initialize();
            Supplier<Boolean> checkIsStillLeader = () -> this.membershipManager.getLeader().getWorkerId().equals(this.workerConfig.getWorkerId());
            this.schedulerManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.schedulerManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.schedulerManager.setMembershipManager(this.membershipManager);
            this.schedulerManager.setLeaderService(this.leaderService);
            this.authenticationService = authenticationService;
            this.authorizationService = authorizationService;
            log.info("/** Starting Function Assignment Tailer **/");
            this.functionAssignmentTailer.startFromMessage(lastAssignmentMessageId);
            log.info("/** Starting Metdata Manager **/");
            this.functionMetaDataManager.start();
            this.clusterServiceCoordinator = new ClusterServiceCoordinator(this.workerConfig.getWorkerId(), this.leaderService, checkIsStillLeader);
            this.clusterServiceCoordinator.addTask("membership-monitor", this.workerConfig.getFailureCheckFreqMs(), () -> {
                try {
                    this.schedulerManager.getSchedulerLock().lock();
                    this.membershipManager.checkFailures(this.functionMetaDataManager, this.functionRuntimeManager, this.schedulerManager);
                }
                finally {
                    this.schedulerManager.getSchedulerLock().unlock();
                }
            });
            if (this.workerConfig.getRebalanceCheckFreqSec() > 0L) {
                this.clusterServiceCoordinator.addTask("rebalance-periodic-check", this.workerConfig.getRebalanceCheckFreqSec() * 1000L, () -> {
                    try {
                        this.schedulerManager.rebalanceIfNotInprogress().get();
                    }
                    catch (SchedulerManager.RebalanceInProgressException e) {
                        log.info("Scheduled for rebalance but rebalance is already in progress. Ignoring.");
                    }
                    catch (Exception e) {
                        log.warn("Encountered error when running scheduled rebalance", (Throwable)e);
                    }
                });
            }
            log.info("/** Starting Cluster Service Coordinator **/");
            this.clusterServiceCoordinator.start();
            this.isInitialized = true;
            log.info("/** Started worker id={} **/", (Object)this.workerConfig.getWorkerId());
            this.workerStatsManager.setFunctionRuntimeManager(this.functionRuntimeManager);
            this.workerStatsManager.setFunctionMetaDataManager(this.functionMetaDataManager);
            this.workerStatsManager.setLeaderService(this.leaderService);
            this.workerStatsManager.setIsLeader(checkIsStillLeader);
            this.workerStatsManager.startupTimeEnd();
        }
        catch (Throwable t) {
            log.error("Error Starting up in worker", t);
            throw new RuntimeException(t);
        }
    }

    public void stop() {
        if (null != this.functionMetaDataManager) {
            try {
                this.functionMetaDataManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function metadata manager", (Throwable)e);
            }
        }
        if (null != this.functionAssignmentTailer) {
            try {
                this.functionAssignmentTailer.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function assignment tailer", (Throwable)e);
            }
        }
        if (null != this.functionRuntimeManager) {
            try {
                this.functionRuntimeManager.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function runtime manager", (Throwable)e);
            }
        }
        if (null != this.clusterServiceCoordinator) {
            this.clusterServiceCoordinator.close();
        }
        if (null != this.membershipManager) {
            this.membershipManager.close();
        }
        if (null != this.schedulerManager) {
            this.schedulerManager.close();
        }
        if (null != this.leaderService) {
            try {
                this.leaderService.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close leader service", (Throwable)e);
            }
        }
        if (null != this.client) {
            try {
                this.client.close();
            }
            catch (PulsarClientException e) {
                log.warn("Failed to close pulsar client", (Throwable)e);
            }
        }
        if (null != this.brokerAdmin) {
            this.brokerAdmin.close();
        }
        if (null != this.functionAdmin) {
            this.functionAdmin.close();
        }
        if (null != this.stateStoreAdminClient) {
            this.stateStoreAdminClient.close();
        }
        if (null != this.dlogNamespace) {
            this.dlogNamespace.close();
        }
        if (this.statsUpdater != null) {
            this.statsUpdater.shutdownNow();
        }
    }

    public WorkerConfig getWorkerConfig() {
        return this.workerConfig;
    }

    public PulsarClient getClient() {
        return this.client;
    }

    public FunctionRuntimeManager getFunctionRuntimeManager() {
        return this.functionRuntimeManager;
    }

    public FunctionMetaDataManager getFunctionMetaDataManager() {
        return this.functionMetaDataManager;
    }

    public ClusterServiceCoordinator getClusterServiceCoordinator() {
        return this.clusterServiceCoordinator;
    }

    public Namespace getDlogNamespace() {
        return this.dlogNamespace;
    }

    public StorageAdminClient getStateStoreAdminClient() {
        return this.stateStoreAdminClient;
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public SchedulerManager getSchedulerManager() {
        return this.schedulerManager;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public ScheduledExecutorService getStatsUpdater() {
        return this.statsUpdater;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ConnectorsManager getConnectorsManager() {
        return this.connectorsManager;
    }

    public FunctionsManager getFunctionsManager() {
        return this.functionsManager;
    }

    public PulsarAdmin getBrokerAdmin() {
        return this.brokerAdmin;
    }

    public PulsarAdmin getFunctionAdmin() {
        return this.functionAdmin;
    }

    public MetricsGenerator getMetricsGenerator() {
        return this.metricsGenerator;
    }

    public URI getDlogUri() {
        return this.dlogUri;
    }

    public LeaderService getLeaderService() {
        return this.leaderService;
    }

    public FunctionAssignmentTailer getFunctionAssignmentTailer() {
        return this.functionAssignmentTailer;
    }

    public WorkerStatsManager getWorkerStatsManager() {
        return this.workerStatsManager;
    }
}

