/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetaDataTopicTailer
implements Runnable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionMetaDataTopicTailer.class);
    private final FunctionMetaDataManager functionMetaDataManager;
    private final Reader<byte[]> reader;
    private final Thread tailerThread;
    private volatile boolean isRunning;
    private ErrorNotifier errorNotifier;
    private volatile boolean exitOnEndOfTopic;
    private CompletableFuture<Void> exitFuture = new CompletableFuture();

    public FunctionMetaDataTopicTailer(FunctionMetaDataManager functionMetaDataManager, ReaderBuilder readerBuilder, WorkerConfig workerConfig, MessageId lastMessageSeen, ErrorNotifier errorNotifier) throws PulsarClientException {
        this.functionMetaDataManager = functionMetaDataManager;
        this.reader = FunctionMetaDataTopicTailer.createReader(workerConfig, readerBuilder, lastMessageSeen);
        this.tailerThread = new Thread(this);
        this.tailerThread.setName("function-metadata-tailer-thread");
        this.errorNotifier = errorNotifier;
        this.exitOnEndOfTopic = false;
    }

    public void start() {
        this.isRunning = true;
        this.tailerThread.start();
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                Message<byte[]> msg = this.reader.readNext(1, TimeUnit.SECONDS);
                if (msg == null) {
                    if (!this.exitOnEndOfTopic || this.reader.hasMessageAvailable()) continue;
                    break;
                }
                this.functionMetaDataManager.processMetaDataTopicMessage(msg);
            }
            catch (Throwable th) {
                if (this.isRunning) {
                    log.error("Encountered error in metadata tailer", th);
                    this.isRunning = false;
                    this.errorNotifier.triggerError(th);
                    continue;
                }
                if (th instanceof InterruptedException || th.getCause() instanceof InterruptedException) continue;
                log.warn("Encountered error when metadata tailer is not running", th);
            }
        }
        log.info("metadata tailer thread exiting");
        this.exitFuture.complete(null);
    }

    public CompletableFuture<Void> stopWhenNoMoreMessages() {
        this.exitOnEndOfTopic = true;
        return this.exitFuture;
    }

    @Override
    public void close() {
        log.info("Stopping function metadata tailer");
        try {
            this.isRunning = false;
            while (true) {
                this.tailerThread.interrupt();
                try {
                    this.tailerThread.join(5000L, 0);
                }
                catch (InterruptedException e) {
                    log.warn("Waiting for metadata tailer thread to stop is interrupted", (Throwable)e);
                }
                if (!this.tailerThread.isAlive()) break;
                log.warn("metadata tailer thread is still alive.  Will attempt to interrupt again.");
            }
            this.reader.close();
        }
        catch (IOException e) {
            log.error("Failed to stop function metadata tailer", (Throwable)e);
        }
        log.info("Stopped function metadata tailer");
    }

    public static Reader createReader(WorkerConfig workerConfig, ReaderBuilder readerBuilder, MessageId startMessageId) throws PulsarClientException {
        ReaderBuilder builder = readerBuilder.topic(workerConfig.getFunctionMetadataTopic()).startMessageId(startMessageId).readerName(workerConfig.getWorkerId() + "-function-metadata-tailer").subscriptionRolePrefix(workerConfig.getWorkerId() + "-function-metadata-tailer");
        if (workerConfig.getUseCompactedMetadataTopic().booleanValue()) {
            builder = builder.readCompacted(true);
        }
        return builder.create();
    }

    public Reader<byte[]> getReader() {
        return this.reader;
    }
}

