/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.apache.pulsar.functions.utils.io.Connectors;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConnectorDefinition;

public class ConnectorsManager {
    private Connectors connectors;

    public ConnectorsManager(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors(workerConfig.getConnectorsDirectory(), workerConfig.getNarExtractionDirectory());
    }

    public List<ConnectorDefinition> getConnectors() {
        return this.connectors.getConnectors();
    }

    public Path getSourceArchive(String sourceType) {
        return this.connectors.getSources().get(sourceType);
    }

    public List<ConfigFieldDefinition> getSourceConfigDefinition(String sourceType) {
        return this.connectors.getSourceConfigDefinitions().get(sourceType);
    }

    public List<ConfigFieldDefinition> getSinkConfigDefinition(String sinkType) {
        return this.connectors.getSinkConfigDefinitions().get(sinkType);
    }

    public Path getSinkArchive(String sinkType) {
        return this.connectors.getSinks().get(sinkType);
    }

    public void reloadConnectors(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors(workerConfig.getConnectorsDirectory(), workerConfig.getNarExtractionDirectory());
    }
}

