/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.ProtobufSchema;
import org.apache.pulsar.functions.api.SerDe;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.source.SerDeSchema;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicSchema {
    private static final Logger log = LoggerFactory.getLogger(TopicSchema.class);
    public static final String JSR_310_CONVERSION_ENABLED = "jsr310ConversionEnabled";
    public static final String ALWAYS_ALLOW_NULL = "alwaysAllowNull";
    private final Map<String, Schema<?>> cachedSchemas = new HashMap();
    private final PulsarClient client;
    private static final SchemaType DEFAULT_SCHEMA_TYPE = SchemaType.JSON;
    public static final String DEFAULT_SERDE = "org.apache.pulsar.functions.api.utils.DefaultSerDe";

    public TopicSchema(PulsarClient client) {
        this.client = client;
    }

    public Schema<?> getSchema(String topic, Object object, String schemaTypeOrClassName, boolean input) {
        return this.getSchema(topic, object.getClass(), schemaTypeOrClassName, input);
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, String schemaTypeOrClassName, boolean input) {
        return this.cachedSchemas.computeIfAbsent(topic, t -> this.newSchemaInstance(topic, clazz, schemaTypeOrClassName, input));
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, ConsumerConfig conf, boolean input) {
        return this.cachedSchemas.computeIfAbsent(topic, t -> this.newSchemaInstance(topic, clazz, conf, input));
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, Optional<SchemaType> schemaType) {
        return this.cachedSchemas.computeIfAbsent(topic, key -> {
            SchemaType type = schemaType.orElse(this.getSchemaTypeOrDefault(topic, clazz));
            return TopicSchema.newSchemaInstance(clazz, type);
        });
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, SchemaType schemaType) {
        return this.cachedSchemas.computeIfAbsent(topic, t -> TopicSchema.newSchemaInstance(clazz, schemaType));
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, String schemaTypeOrClassName, boolean input, ClassLoader classLoader) {
        return this.cachedSchemas.computeIfAbsent(topic, t -> this.newSchemaInstance(topic, clazz, schemaTypeOrClassName, input, classLoader));
    }

    public Schema<?> getSchema(String topic, Class<?> clazz, ConsumerConfig conf, boolean input, ClassLoader classLoader) {
        return this.cachedSchemas.computeIfAbsent(topic, t -> this.newSchemaInstance(topic, clazz, conf, input, classLoader));
    }

    private SchemaType getSchemaTypeOrDefault(String topic, Class<?> clazz) {
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return SchemaType.AUTO_CONSUME;
        }
        if (byte[].class.equals(clazz) || ByteBuf.class.equals(clazz) || ByteBuffer.class.equals(clazz)) {
            return SchemaType.NONE;
        }
        Optional<SchemaInfo> schema = ((PulsarClientImpl)this.client).getSchema(topic).join();
        if (schema.isPresent()) {
            if (schema.get().getType() == SchemaType.NONE) {
                return TopicSchema.getDefaultSchemaType(clazz);
            }
            return schema.get().getType();
        }
        return TopicSchema.getDefaultSchemaType(clazz);
    }

    private static SchemaType getDefaultSchemaType(Class<?> clazz) {
        if (byte[].class.equals(clazz) || ByteBuf.class.equals(clazz) || ByteBuffer.class.equals(clazz)) {
            return SchemaType.NONE;
        }
        if (GenericRecord.class.isAssignableFrom(clazz)) {
            return SchemaType.AUTO_CONSUME;
        }
        if (String.class.equals(clazz)) {
            return SchemaType.STRING;
        }
        if (TopicSchema.isProtobufClass(clazz)) {
            return SchemaType.PROTOBUF;
        }
        if (KeyValue.class.equals(clazz)) {
            return SchemaType.KEY_VALUE;
        }
        return DEFAULT_SCHEMA_TYPE;
    }

    private static <T> Schema<T> newSchemaInstance(Class<T> clazz, SchemaType type) {
        return TopicSchema.newSchemaInstance(clazz, type, new ConsumerConfig());
    }

    private static <T> Schema<T> newSchemaInstance(Class<T> clazz, SchemaType type, ConsumerConfig conf) {
        switch (type) {
            case NONE: {
                return Schema.BYTES;
            }
            case AUTO_CONSUME: 
            case AUTO: {
                return Schema.AUTO_CONSUME();
            }
            case STRING: {
                return Schema.STRING;
            }
            case AVRO: {
                return AvroSchema.of(SchemaDefinition.builder().withProperties(new HashMap<String, String>(conf.getSchemaProperties())).withPojo(clazz).build());
            }
            case JSON: {
                return JSONSchema.of(SchemaDefinition.builder().withPojo(clazz).build());
            }
            case KEY_VALUE: {
                return Schema.KV_BYTES();
            }
            case PROTOBUF: {
                return ProtobufSchema.ofGenericClass(clazz, new HashMap<String, String>());
            }
        }
        throw new RuntimeException("Unsupported schema type" + (Object)((Object)type));
    }

    private static boolean isProtobufClass(Class<?> pojoClazz) {
        try {
            Class<?> protobufBaseClass = Class.forName("org.apache.pulsar.shade.com.google.protobuf.GeneratedMessageV3");
            return protobufBaseClass.isAssignableFrom(pojoClazz);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private <T> Schema<T> newSchemaInstance(String topic, Class<T> clazz, String schemaTypeOrClassName, boolean input, ClassLoader classLoader) {
        return this.newSchemaInstance(topic, clazz, new ConsumerConfig(schemaTypeOrClassName), input, classLoader);
    }

    private <T> Schema<T> newSchemaInstance(String topic, Class<T> clazz, ConsumerConfig conf, boolean input, ClassLoader classLoader) {
        String schemaTypeOrClassName = conf.getSchemaType();
        if (StringUtils.isEmpty(schemaTypeOrClassName) || DEFAULT_SERDE.equals(schemaTypeOrClassName)) {
            return TopicSchema.newSchemaInstance(clazz, this.getSchemaTypeOrDefault(topic, clazz));
        }
        SchemaType schemaType = null;
        try {
            schemaType = SchemaType.valueOf(schemaTypeOrClassName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (schemaType != null) {
            return TopicSchema.newSchemaInstance(clazz, schemaType, conf);
        }
        try {
            return InstanceUtils.initializeCustomSchema(schemaTypeOrClassName, classLoader, clazz, input);
        }
        catch (Throwable t) {
            SerDe<?> serDe = InstanceUtils.initializeSerDe(schemaTypeOrClassName, classLoader, clazz, input);
            return new SerDeSchema(serDe);
        }
    }

    private <T> Schema<T> newSchemaInstance(String topic, Class<T> clazz, String schemaTypeOrClassName, boolean input) {
        return this.newSchemaInstance(topic, clazz, new ConsumerConfig(schemaTypeOrClassName), input, Thread.currentThread().getContextClassLoader());
    }

    private <T> Schema<T> newSchemaInstance(String topic, Class<T> clazz, ConsumerConfig conf, boolean input) {
        return this.newSchemaInstance(topic, clazz, conf, input, Thread.currentThread().getContextClassLoader());
    }
}

