/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;

public class LogAppender
implements Appender {
    private PulsarClient pulsarClient;
    private String logTopic;
    private String fqn;
    private LifeCycle.State state;
    private ErrorHandler errorHandler;
    private Producer<byte[]> producer;

    public LogAppender(PulsarClient pulsarClient, String logTopic, String fqn) {
        this.pulsarClient = pulsarClient;
        this.logTopic = logTopic;
        this.fqn = fqn;
    }

    public void append(LogEvent logEvent) {
        this.producer.newMessage().value(logEvent.getMessage().getFormattedMessage().getBytes()).property("loglevel", logEvent.getLevel().name()).sendAsync();
    }

    public String getName() {
        return this.fqn;
    }

    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    public boolean ignoreExceptions() {
        return false;
    }

    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    public void setHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public LifeCycle.State getState() {
        return this.state;
    }

    public void initialize() {
        this.state = LifeCycle.State.INITIALIZED;
    }

    public void start() {
        this.state = LifeCycle.State.STARTING;
        try {
            this.producer = this.pulsarClient.newProducer().topic(this.logTopic).blockIfQueueFull(false).enableBatching(true).compressionType(CompressionType.LZ4).batchingMaxPublishDelay(100L, TimeUnit.MILLISECONDS).property("function", this.fqn).create();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting LogTopic Producer", e);
        }
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        this.state = LifeCycle.State.STOPPING;
        this.producer.closeAsync();
        this.producer = null;
        this.state = LifeCycle.State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

