/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.auth;

import java.util.Optional;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.AuthenticationConfig;

public class ClearTextFunctionTokenAuthProvider
implements FunctionAuthProvider {
    @Override
    public void configureAuthenticationConfig(AuthenticationConfig authConfig, Optional<FunctionAuthData> functionAuthData) {
        if (!functionAuthData.isPresent()) {
            authConfig.setClientAuthenticationPlugin(null);
            authConfig.setClientAuthenticationParameters(null);
        } else {
            authConfig.setClientAuthenticationPlugin(AuthenticationToken.class.getName());
            authConfig.setClientAuthenticationParameters("token:" + new String(functionAuthData.get().getData()));
        }
    }

    @Override
    public Optional<FunctionAuthData> cacheAuthData(Function.FunctionDetails funcDetails, AuthenticationDataSource authenticationDataSource) throws Exception {
        String token = null;
        try {
            token = AuthenticationProviderToken.getToken(authenticationDataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (token != null) {
            return Optional.of(FunctionAuthData.builder().data(token.getBytes()).build());
        }
        return Optional.empty();
    }

    @Override
    public Optional<FunctionAuthData> updateAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> existingFunctionAuthData, AuthenticationDataSource authenticationDataSource) throws Exception {
        return this.cacheAuthData(funcDetails, authenticationDataSource);
    }

    @Override
    public void cleanUpAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> functionAuthData) throws Exception {
    }
}

