/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.protobuf.DescriptorProtos;
import org.apache.pulsar.shade.com.google.protobuf.Descriptors;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.ProtobufNativeSchemaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufNativeSchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufNativeSchemaUtils.class);

    public static byte[] serialize(Descriptors.Descriptor descriptor) {
        byte[] schemaDataBytes;
        try {
            HashMap<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoCache = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
            ProtobufNativeSchemaUtils.serializeFileDescriptor(descriptor.getFile(), fileDescriptorProtoCache);
            String rootMessageTypeName = descriptor.getFullName();
            String rootFileDescriptorName = descriptor.getFile().getFullName();
            byte[] fileDescriptorSet = DescriptorProtos.FileDescriptorSet.newBuilder().addAllFile(fileDescriptorProtoCache.values()).build().toByteArray();
            ProtobufNativeSchemaData schemaData = ProtobufNativeSchemaData.builder().fileDescriptorSet(fileDescriptorSet).rootFileDescriptorName(rootFileDescriptorName).rootMessageTypeName(rootMessageTypeName).build();
            schemaDataBytes = new ObjectMapper().writeValueAsBytes(schemaData);
            logger.debug("descriptor '{}' serialized to '{}'.", (Object)descriptor.getFullName(), (Object)schemaDataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaSerializationException(e);
        }
        return schemaDataBytes;
    }

    private static void serializeFileDescriptor(Descriptors.FileDescriptor fileDescriptor, Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorCache) {
        fileDescriptor.getDependencies().forEach(dependency -> {
            if (!fileDescriptorCache.containsKey(dependency.getFullName())) {
                ProtobufNativeSchemaUtils.serializeFileDescriptor(dependency, fileDescriptorCache);
            }
        });
        String[] unResolvedFileDescriptNames = (String[])fileDescriptor.getDependencies().stream().filter(item -> !fileDescriptorCache.containsKey(item.getFullName())).map(Descriptors.FileDescriptor::getFullName).toArray(String[]::new);
        if (unResolvedFileDescriptNames.length != 0) {
            throw new SchemaSerializationException(fileDescriptor.getFullName() + " can't resolve dependency '" + unResolvedFileDescriptNames + "'.");
        }
        fileDescriptorCache.put(fileDescriptor.getFullName(), fileDescriptor.toProto());
    }

    public static Descriptors.Descriptor deserialize(byte[] schemaDataBytes) {
        Descriptors.Descriptor descriptor;
        try {
            ProtobufNativeSchemaData schemaData = new ObjectMapper().readValue(schemaDataBytes, ProtobufNativeSchemaData.class);
            HashMap<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoCache = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
            HashMap<String, Descriptors.FileDescriptor> fileDescriptorCache = new HashMap<String, Descriptors.FileDescriptor>();
            DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(schemaData.getFileDescriptorSet());
            fileDescriptorSet.getFileList().forEach(fileDescriptorProto -> fileDescriptorProtoCache.put(fileDescriptorProto.getName(), (DescriptorProtos.FileDescriptorProto)fileDescriptorProto));
            DescriptorProtos.FileDescriptorProto rootFileDescriptorProto = (DescriptorProtos.FileDescriptorProto)fileDescriptorProtoCache.get(schemaData.getRootFileDescriptorName());
            ProtobufNativeSchemaUtils.deserializeFileDescriptor(rootFileDescriptorProto, fileDescriptorCache, fileDescriptorProtoCache);
            Descriptors.FileDescriptor fileDescriptor = (Descriptors.FileDescriptor)fileDescriptorCache.get(schemaData.getRootFileDescriptorName());
            String[] paths = StringUtils.removeFirst(schemaData.getRootMessageTypeName(), fileDescriptor.getPackage()).replaceFirst(".", "").split("\\.");
            descriptor = fileDescriptor.findMessageTypeByName(paths[0]);
            for (int i = 1; i < paths.length; ++i) {
                descriptor = descriptor.findNestedTypeByName(paths[i]);
            }
            logger.debug("deserialize '{}' to descriptor: '{}'.", (Object)schemaDataBytes, (Object)descriptor.getFullName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaSerializationException(e);
        }
        return descriptor;
    }

    private static void deserializeFileDescriptor(DescriptorProtos.FileDescriptorProto fileDescriptorProto, Map<String, Descriptors.FileDescriptor> fileDescriptorCache, Map<String, DescriptorProtos.FileDescriptorProto> fileDescriptorProtoCache) {
        fileDescriptorProto.getDependencyList().forEach(dependencyFileDescriptorName -> {
            if (!fileDescriptorCache.containsKey(dependencyFileDescriptorName)) {
                DescriptorProtos.FileDescriptorProto dependencyFileDescriptor = (DescriptorProtos.FileDescriptorProto)fileDescriptorProtoCache.get(dependencyFileDescriptorName);
                ProtobufNativeSchemaUtils.deserializeFileDescriptor(dependencyFileDescriptor, fileDescriptorCache, fileDescriptorProtoCache);
            }
        });
        Descriptors.FileDescriptor[] dependencyFileDescriptors = (Descriptors.FileDescriptor[])fileDescriptorProto.getDependencyList().stream().map(dependency -> {
            if (fileDescriptorCache.containsKey(dependency)) {
                return (Descriptors.FileDescriptor)fileDescriptorCache.get(dependency);
            }
            throw new SchemaSerializationException("'" + fileDescriptorProto.getName() + "' can't resolve  dependency '" + dependency + "'.");
        }).toArray(Descriptors.FileDescriptor[]::new);
        try {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, dependencyFileDescriptors);
            fileDescriptorCache.put(fileDescriptor.getFullName(), fileDescriptor);
        }
        catch (Descriptors.DescriptorValidationException e) {
            e.printStackTrace();
            throw new SchemaSerializationException(e);
        }
    }
}

