/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.time.LocalTime;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class LocalTimeSchema
extends AbstractSchema<LocalTime> {
    private static final LocalTimeSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static LocalTimeSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(LocalTime message) {
        if (null == message) {
            return null;
        }
        Long nanoOfDay = message.toNanoOfDay();
        return LongSchema.of().encode(nanoOfDay);
    }

    @Override
    public LocalTime decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return LocalTime.ofNanoOfDay(decode);
    }

    @Override
    public LocalTime decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return LocalTime.ofNanoOfDay(decode);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfo().setName("LocalTime").setType(SchemaType.LOCAL_TIME).setSchema(new byte[0]);
        INSTANCE = new LocalTimeSchema();
    }
}

