/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Date;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class DateSchema
extends AbstractSchema<Date> {
    private static final DateSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static DateSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(Date message) {
        if (null == message) {
            return null;
        }
        Long date = message.getTime();
        return LongSchema.of().encode(date);
    }

    @Override
    public Date decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return new Date(decode);
    }

    @Override
    public Date decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        Long decode = LongSchema.of().decode(byteBuf);
        return new Date(decode);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfo().setName("Date").setType(SchemaType.DATE).setSchema(new byte[0]);
        INSTANCE = new DateSchema();
    }
}

