/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TransactionCoordinatorClient
extends Closeable {
    public static final long DEFAULT_TXN_TTL_MS = 60000L;

    public void start() throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> startAsync();

    public CompletableFuture<Void> closeAsync();

    public TxnID newTransaction() throws TransactionCoordinatorClientException;

    public CompletableFuture<TxnID> newTransactionAsync();

    public TxnID newTransaction(long var1, TimeUnit var3) throws TransactionCoordinatorClientException;

    public CompletableFuture<TxnID> newTransactionAsync(long var1, TimeUnit var3);

    public void addPublishPartitionToTxn(TxnID var1, List<String> var2) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> addPublishPartitionToTxnAsync(TxnID var1, List<String> var2);

    public void addSubscriptionToTxn(TxnID var1, String var2, String var3) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> addSubscriptionToTxnAsync(TxnID var1, String var2, String var3);

    public void commit(TxnID var1, List<MessageId> var2) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> commitAsync(TxnID var1, List<MessageId> var2);

    public void abort(TxnID var1, List<MessageId> var2) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> abortAsync(TxnID var1, List<MessageId> var2);

    public State getState();

    public static enum State {
        NONE,
        STARTING,
        READY,
        CLOSING,
        CLOSED;

    }
}

