/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface AuthenticationDataProvider
extends Serializable {
    default public boolean hasDataForTls() {
        return false;
    }

    default public Certificate[] getTlsCertificates() {
        return null;
    }

    default public PrivateKey getTlsPrivateKey() {
        return null;
    }

    default public InputStream getTlsTrustStoreStream() {
        return null;
    }

    default public KeyStoreParams getTlsKeyStoreParams() {
        return null;
    }

    default public boolean hasDataForHttp() {
        return false;
    }

    default public String getHttpAuthType() {
        return null;
    }

    default public Set<Map.Entry<String, String>> getHttpHeaders() throws Exception {
        return null;
    }

    default public boolean hasDataFromCommand() {
        return false;
    }

    default public String getCommandData() {
        return null;
    }

    default public AuthData authenticate(AuthData data) throws AuthenticationException {
        byte[] bytes = (this.hasDataFromCommand() ? this.getCommandData() : "").getBytes(StandardCharsets.UTF_8);
        return AuthData.of(bytes);
    }
}

