/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.shade.com.google.common.base.Joiner;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.base.Splitter;
import org.apache.pulsar.shade.com.google.common.collect.BoundType;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.core.Context;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.javax.ws.rs.core.UriBuilder;
import org.apache.pulsar.shade.javax.ws.rs.core.UriInfo;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(PulsarWebResource.class);
    static final String ORIGINAL_PRINCIPAL_HEADER = "X-Original-Principal";
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;
    @Context
    protected UriInfo uri;
    private PulsarService pulsar;
    protected static final int NOT_IMPLEMENTED = 501;

    protected PulsarService pulsar() {
        if (this.pulsar == null) {
            this.pulsar = (PulsarService)this.servletContext.getAttribute("pulsar");
        }
        return this.pulsar;
    }

    protected ServiceConfiguration config() {
        return this.pulsar().getConfiguration();
    }

    public static String path(String ... parts) {
        StringBuilder sb = new StringBuilder();
        sb.append("/admin/");
        Joiner.on('/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        Joiner.on('/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public static String splitPath(String source, int slice) {
        Iterable<String> parts = Splitter.on('/').limit(slice).split(source);
        Iterator<String> s = parts.iterator();
        String result = "";
        for (int i = 0; i < slice; ++i) {
            result = s.next();
        }
        return result;
    }

    public String clientAppId() {
        return (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName);
    }

    public String originalPrincipal() {
        return this.httpRequest.getHeader(ORIGINAL_PRINCIPAL_HEADER);
    }

    public AuthenticationDataHttps clientAuthData() {
        return (AuthenticationDataHttps)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedDataAttributeName);
    }

    public boolean isRequestHttps() {
        return "https".equalsIgnoreCase(this.httpRequest.getScheme());
    }

    public static boolean isClientAuthenticated(String appId) {
        return appId != null;
    }

    private static void validateOriginalPrincipal(Set<String> proxyRoles, String authenticatedPrincipal, String originalPrincipal) {
        if (proxyRoles.contains(authenticatedPrincipal)) {
            if (StringUtils.isBlank(originalPrincipal)) {
                log.warn("Original principal empty in request authenticated as {}", (Object)authenticatedPrincipal);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be empty if the request is via proxy.");
            }
            if (proxyRoles.contains(originalPrincipal)) {
                log.warn("Original principal {} cannot be a proxy role ({})", (Object)originalPrincipal, proxyRoles);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be a proxy role");
            }
        }
    }

    protected boolean hasSuperUserAccess() {
        try {
            this.validateSuperUserAccess();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected void validateSuperUserAccess() {
        if (this.config().isAuthenticationEnabled()) {
            String appId = this.clientAppId();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Check super user access: Authenticated: {} -- Role: {}", new Object[]{this.uri.getRequestUri(), PulsarWebResource.isClientAuthenticated(appId), appId});
            }
            String originalPrincipal = this.originalPrincipal();
            PulsarWebResource.validateOriginalPrincipal(this.pulsar.getConfiguration().getProxyRoles(), appId, originalPrincipal);
            if (this.pulsar.getConfiguration().getProxyRoles().contains(appId)) {
                try {
                    CompletableFuture<Boolean> proxyAuthorizedFuture = this.pulsar.getBrokerService().getAuthorizationService().isSuperUser(appId, this.clientAuthData());
                    CompletableFuture<Boolean> originalPrincipalAuthorizedFuture = this.pulsar.getBrokerService().getAuthorizationService().isSuperUser(originalPrincipal, this.clientAuthData());
                    if (!proxyAuthorizedFuture.get().booleanValue() || !originalPrincipalAuthorizedFuture.get().booleanValue()) {
                        throw new RestException(Response.Status.UNAUTHORIZED, String.format("Proxy not authorized for super-user operation (proxy:%s,original:%s)", appId, originalPrincipal));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Error validating super-user access : " + e.getMessage(), (Throwable)e);
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
                log.debug("Successfully authorized {} (proxied by {}) as super-user", (Object)originalPrincipal, (Object)appId);
            } else {
                if (this.config().isAuthorizationEnabled() && !this.pulsar.getBrokerService().getAuthorizationService().isSuperUser(appId, this.clientAuthData()).join().booleanValue()) {
                    throw new RestException(Response.Status.UNAUTHORIZED, "This operation requires super-user access");
                }
                log.debug("Successfully authorized {} as super-user", (Object)appId);
            }
        }
    }

    protected void validateAdminAccessForTenant(String tenant) {
        try {
            PulsarWebResource.validateAdminAccessForTenant(this.pulsar(), this.clientAppId(), this.originalPrincipal(), tenant, this.clientAuthData());
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to get tenant admin data for tenant {}", (Object)tenant);
            throw new RestException(e);
        }
    }

    protected static void validateAdminAccessForTenant(PulsarService pulsar, String clientAppId, String originalPrincipal, String tenant, AuthenticationDataSource authenticationData) throws RestException, Exception {
        TenantInfo tenantInfo;
        if (log.isDebugEnabled()) {
            log.debug("check admin access on tenant: {} - Authenticated: {} -- role: {}", new Object[]{tenant, PulsarWebResource.isClientAuthenticated(clientAppId), clientAppId});
        }
        try {
            tenantInfo = pulsar.getConfigurationCache().propertiesCache().get(PulsarWebResource.path("policies", tenant)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Tenant does not exist"));
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("Failed to get tenant info data for non existing tenant {}", (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
        }
        if (pulsar.getConfiguration().isAuthenticationEnabled() && pulsar.getConfiguration().isAuthorizationEnabled()) {
            if (!PulsarWebResource.isClientAuthenticated(clientAppId)) {
                throw new RestException(Response.Status.FORBIDDEN, "Need to authenticate to perform the request");
            }
            PulsarWebResource.validateOriginalPrincipal(pulsar.getConfiguration().getProxyRoles(), clientAppId, originalPrincipal);
            if (pulsar.getConfiguration().getProxyRoles().contains(clientAppId)) {
                try {
                    boolean originalPrincipalAuthorized;
                    AuthorizationService authorizationService = pulsar.getBrokerService().getAuthorizationService();
                    CompletableFuture<Boolean> isProxySuperUserFuture = authorizationService.isSuperUser(clientAppId, authenticationData);
                    CompletableFuture<Boolean> isOriginalPrincipalSuperUserFuture = authorizationService.isSuperUser(originalPrincipal, authenticationData);
                    boolean proxyAuthorized = isProxySuperUserFuture.get() != false || authorizationService.isTenantAdmin(tenant, clientAppId, tenantInfo, authenticationData).get() != false;
                    boolean bl = originalPrincipalAuthorized = isOriginalPrincipalSuperUserFuture.get() != false || authorizationService.isTenantAdmin(tenant, originalPrincipal, tenantInfo, authenticationData).get() != false;
                    if (!proxyAuthorized || !originalPrincipalAuthorized) {
                        throw new RestException(Response.Status.UNAUTHORIZED, String.format("Proxy not authorized to access resource (proxy:%s,original:%s)", clientAppId, originalPrincipal));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
                log.debug("Successfully authorized {} (proxied by {}) on tenant {}", new Object[]{originalPrincipal, clientAppId, tenant});
            } else {
                if (!pulsar.getBrokerService().getAuthorizationService().isSuperUser(clientAppId, authenticationData).join().booleanValue() && !pulsar.getBrokerService().getAuthorizationService().isTenantAdmin(tenant, clientAppId, tenantInfo, authenticationData).get().booleanValue()) {
                    throw new RestException(Response.Status.UNAUTHORIZED, "Don't have permission to administrate resources on this tenant");
                }
                log.debug("Successfully authorized {} on tenant {}", (Object)clientAppId, (Object)tenant);
            }
        }
    }

    protected void validateClusterForTenant(String tenant, String cluster) {
        TenantInfo tenantInfo;
        try {
            tenantInfo = this.pulsar().getConfigurationCache().propertiesCache().get(PulsarWebResource.path("policies", tenant)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Tenant does not exist"));
        }
        catch (RestException e) {
            log.warn("Failed to get tenant admin data for tenant {}", (Object)tenant);
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to get tenant admin data for tenant {}", (Object)tenant, (Object)e);
            throw new RestException(e);
        }
        if (!tenantInfo.getAllowedClusters().contains(cluster)) {
            String msg = String.format("Cluster [%s] is not in the list of allowed clusters list for tenant [%s]", cluster, tenant);
            log.info(msg);
            throw new RestException(Response.Status.FORBIDDEN, msg);
        }
        log.info("Successfully validated clusters on tenant [{}]", (Object)tenant);
    }

    protected void validateClusterOwnership(String cluster) throws WebApplicationException {
        try {
            ClusterData differentClusterData = PulsarWebResource.getClusterDataIfDifferentCluster(this.pulsar(), cluster, this.clientAppId()).get();
            if (differentClusterData != null) {
                URI redirect = this.getRedirectionUrl(differentClusterData);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, cluster});
                }
                throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate Cluster configuration : cluster=%s  emsg=%s", cluster, e.getMessage()));
        }
    }

    private URI getRedirectionUrl(ClusterData differentClusterData) throws MalformedURLException {
        try {
            PulsarServiceNameResolver serviceNameResolver = new PulsarServiceNameResolver();
            if (this.isRequestHttps() && this.pulsar.getConfiguration().getWebServicePortTls().isPresent() && StringUtils.isNotBlank(differentClusterData.getServiceUrlTls())) {
                serviceNameResolver.updateServiceUrl(differentClusterData.getServiceUrlTls());
            } else {
                serviceNameResolver.updateServiceUrl(differentClusterData.getServiceUrl());
            }
            URL webUrl = new URL(serviceNameResolver.resolveHostUri().toString());
            return UriBuilder.fromUri(this.uri.getRequestUri()).host(webUrl.getHost()).port(webUrl.getPort()).build(new Object[0]);
        }
        catch (PulsarClientException.InvalidServiceURL exception) {
            throw new MalformedURLException(exception.getMessage());
        }
    }

    protected static CompletableFuture<ClusterData> getClusterDataIfDifferentCluster(PulsarService pulsar, String cluster, String clientAppId) {
        CompletableFuture<ClusterData> clusterDataFuture;
        block5: {
            clusterDataFuture = new CompletableFuture<ClusterData>();
            if (!PulsarWebResource.isValidCluster(pulsar, cluster)) {
                try {
                    if (!pulsar.getConfiguration().getClusterName().equals(cluster)) {
                        ((CompletableFuture)pulsar.getConfigurationCache().clustersCache().getAsync(PulsarWebResource.path("clusters", cluster)).thenAccept(clusterDataResult -> {
                            if (clusterDataResult.isPresent()) {
                                clusterDataFuture.complete((ClusterData)clusterDataResult.get());
                            } else {
                                log.warn("[{}] Cluster does not exist: requested={}", (Object)clientAppId, (Object)cluster);
                                clusterDataFuture.completeExceptionally(new RestException(Response.Status.NOT_FOUND, "Cluster does not exist: cluster=" + cluster));
                            }
                        })).exceptionally(ex -> {
                            clusterDataFuture.completeExceptionally((Throwable)ex);
                            return null;
                        });
                        break block5;
                    }
                    clusterDataFuture.complete(null);
                }
                catch (Exception e) {
                    clusterDataFuture.completeExceptionally(e);
                }
            } else {
                clusterDataFuture.complete(null);
            }
        }
        return clusterDataFuture;
    }

    static boolean isValidCluster(PulsarService pulsarService, String cluster) {
        if (cluster == null || "global".equals(cluster)) {
            return true;
        }
        return !pulsarService.getConfiguration().isAuthorizationEnabled();
    }

    protected void validateNamespaceOwnershipWithBundles(String tenant, String cluster, String namespace, boolean authoritative, boolean readOnly, BundlesData bundleData) {
        NamespaceName fqnn = NamespaceName.get(tenant, cluster, namespace);
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(fqnn, bundleData);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                this.validateBundleOwnership(bundle, authoritative, readOnly);
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug("Failed to find owner for namespace {}", (Object)fqnn, (Object)oe);
            throw new RestException(oe);
        }
    }

    protected void validateBundleOwnership(String tenant, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        NamespaceName fqnn = NamespaceName.get(tenant, cluster, namespace);
        try {
            this.validateBundleOwnership(bundle, authoritative, readOnly);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug("Failed to find owner for namespace {}", (Object)fqnn, (Object)oe);
            throw new RestException(oe);
        }
    }

    protected NamespaceBundle validateNamespaceBundleRange(NamespaceName fqnn, BundlesData bundles, String bundleRange) {
        try {
            Preconditions.checkArgument(bundleRange.contains("_"), "Invalid bundle range: " + bundleRange);
            String[] boundaries = bundleRange.split("_");
            Long lowerEndpoint = Long.decode(boundaries[0]);
            Long upperEndpoint = Long.decode(boundaries[1]);
            Range<Long> hashRange = Range.range(lowerEndpoint, BoundType.CLOSED, upperEndpoint, upperEndpoint.equals(NamespaceBundles.FULL_UPPER_BOUND) ? BoundType.CLOSED : BoundType.OPEN);
            NamespaceBundle nsBundle = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(fqnn, hashRange);
            NamespaceBundles nsBundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(fqnn, bundles);
            nsBundles.validateBundle(nsBundle);
            return nsBundle;
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] Invalid bundle range {}/{}, {}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e.getMessage()});
            throw new RestException(Response.Status.PRECONDITION_FAILED, e.getMessage());
        }
        catch (Exception e) {
            log.error("[{}] Failed to validate namespace bundle {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Boolean> isBundleOwnedByAnyBroker(NamespaceName fqnn, BundlesData bundles, String bundleRange) {
        NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, bundles, bundleRange);
        NamespaceService nsService = this.pulsar().getNamespaceService();
        LookupOptions options = LookupOptions.builder().authoritative(false).requestHttps(this.isRequestHttps()).readOnly(true).loadTopicsInBundle(false).build();
        try {
            return nsService.getWebServiceUrlAsync(nsBundle, options).thenApply(optionUrl -> optionUrl.isPresent());
        }
        catch (Exception e) {
            log.error("[{}] Failed to check whether namespace bundle is owned {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected NamespaceBundle validateNamespaceBundleOwnership(NamespaceName fqnn, BundlesData bundles, String bundleRange, boolean authoritative, boolean readOnly) {
        try {
            NamespaceBundle nsBundle = this.validateNamespaceBundleRange(fqnn, bundles, bundleRange);
            this.validateBundleOwnership(nsBundle, authoritative, readOnly);
            return nsBundle;
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to validate namespace bundle {}/{}", new Object[]{this.clientAppId(), fqnn.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    public void validateBundleOwnership(NamespaceBundle bundle, boolean authoritative, boolean readOnly) throws Exception {
        NamespaceService nsService = this.pulsar().getNamespaceService();
        try {
            LookupOptions options = LookupOptions.builder().authoritative(authoritative).requestHttps(this.isRequestHttps()).readOnly(readOnly).loadTopicsInBundle(false).build();
            Optional<URL> webUrl = nsService.getWebServiceUrl(bundle, options);
            if (webUrl == null || !webUrl.isPresent()) {
                log.warn("Unable to get web service url");
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for ServiceUnit:" + bundle.toString());
            }
            if (!nsService.isServiceUnitOwned(bundle)) {
                boolean newAuthoritative = this.isLeaderBroker();
                URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(webUrl.get().getHost()).port(webUrl.get().getPort()).replaceQueryParam("authoritative", newAuthoritative).build(new Object[0]);
                log.debug("{} is not a service unit owned", (Object)bundle);
                log.debug("Redirecting the rest call to {}", (Object)redirect);
                throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
            }
        }
        catch (TimeoutException te) {
            String msg = String.format("Finding owner for ServiceUnit %s timed out", bundle);
            log.error(msg, (Throwable)te);
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
        catch (IllegalArgumentException iae) {
            log.debug("Failed to find owner for ServiceUnit {}", (Object)bundle, (Object)iae);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "ServiceUnit format is not expected. ServiceUnit " + bundle);
        }
        catch (IllegalStateException ise) {
            log.debug("Failed to find owner for ServiceUnit {}", (Object)bundle, (Object)ise);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "ServiceUnit bundle is actived. ServiceUnit " + bundle);
        }
        catch (NullPointerException e) {
            log.warn("Unable to get web service url");
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for ServiceUnit:" + bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
    }

    protected void validateTopicOwnership(TopicName topicName, boolean authoritative) {
        NamespaceService nsService = this.pulsar().getNamespaceService();
        try {
            LookupOptions options = LookupOptions.builder().authoritative(authoritative).requestHttps(this.isRequestHttps()).readOnly(false).loadTopicsInBundle(false).build();
            Optional<URL> webUrl = nsService.getWebServiceUrl(topicName, options);
            if (webUrl == null || !webUrl.isPresent()) {
                log.info("Unable to get web service url");
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Failed to find ownership for topic:" + topicName);
            }
            if (!nsService.isServiceUnitOwned(topicName)) {
                boolean newAuthoritative = PulsarWebResource.isLeaderBroker(this.pulsar());
                URI redirect = UriBuilder.fromUri(this.uri.getRequestUri()).host(webUrl.get().getHost()).port(webUrl.get().getPort()).replaceQueryParam("authoritative", newAuthoritative).build(new Object[0]);
                log.debug("Redirecting the rest call to {}", (Object)redirect);
                throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
            }
        }
        catch (TimeoutException te) {
            String msg = String.format("Finding owner for topic %s timed out", topicName);
            log.error(msg, (Throwable)te);
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
        catch (IllegalArgumentException iae) {
            log.debug("Failed to find owner for topic: {}", (Object)topicName, (Object)iae);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't find owner for topic " + topicName);
        }
        catch (IllegalStateException ise) {
            log.debug("Failed to find owner for topic: {}", (Object)topicName, (Object)ise);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't find owner for topic " + topicName);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception oe) {
            log.debug("Failed to find owner for topic: {}", (Object)topicName, (Object)oe);
            throw new RestException(oe);
        }
    }

    protected void validateGlobalNamespaceOwnership(NamespaceName namespace) {
        int timeout = this.pulsar().getConfiguration().getZooKeeperOperationTimeoutSeconds();
        try {
            ClusterData peerClusterData = PulsarWebResource.checkLocalOrGetPeerReplicationCluster(this.pulsar(), namespace).get(timeout, TimeUnit.SECONDS);
            if (peerClusterData != null) {
                URI redirect = this.getRedirectionUrl(peerClusterData);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, peerClusterData});
                }
                throw new WebApplicationException(Response.temporaryRedirect(redirect).build());
            }
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while validating policy on {} ", (Object)timeout, (Object)namespace);
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate global cluster configuration : ns=%s  emsg=%s", namespace, e.getMessage()));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, String.format("Failed to validate global cluster configuration : ns=%s  emsg=%s", namespace, e.getMessage()));
        }
    }

    public static CompletableFuture<ClusterData> checkLocalOrGetPeerReplicationCluster(PulsarService pulsarService, NamespaceName namespace) {
        if (!namespace.isGlobal()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ClusterData> validationFuture = new CompletableFuture<ClusterData>();
        String localCluster = pulsarService.getConfiguration().getClusterName();
        String path = AdminResource.path("policies", namespace.toString());
        ((CompletableFuture)pulsarService.getConfigurationCache().policiesCache().getAsync(path).thenAccept(policiesResult -> {
            if (policiesResult.isPresent()) {
                Policies policies = (Policies)policiesResult.get();
                if (policies.replication_clusters.isEmpty()) {
                    String msg = String.format("Namespace does not have any clusters configured : local_cluster=%s ns=%s", localCluster, namespace.toString());
                    log.warn(msg);
                    validationFuture.completeExceptionally(new RestException(Response.Status.PRECONDITION_FAILED, msg));
                } else if (!policies.replication_clusters.contains(localCluster)) {
                    ClusterData ownerPeerCluster = PulsarWebResource.getOwnerFromPeerClusterList(pulsarService, policies.replication_clusters);
                    if (ownerPeerCluster != null) {
                        validationFuture.complete(ownerPeerCluster);
                        return;
                    }
                    String msg = String.format("Namespace missing local cluster name in clusters list: local_cluster=%s ns=%s clusters=%s", localCluster, namespace.toString(), policies.replication_clusters);
                    log.warn(msg);
                    validationFuture.completeExceptionally(new RestException(Response.Status.PRECONDITION_FAILED, msg));
                } else {
                    validationFuture.complete(null);
                }
            } else {
                String msg = String.format("Policies not found for %s namespace", namespace.toString());
                log.warn(msg);
                validationFuture.completeExceptionally(new RestException(Response.Status.NOT_FOUND, msg));
            }
        })).exceptionally(ex -> {
            String msg = String.format("Failed to validate global cluster configuration : cluster=%s ns=%s  emsg=%s", localCluster, namespace, ex.getMessage());
            log.error(msg);
            validationFuture.completeExceptionally(new RestException((Throwable)ex));
            return null;
        });
        return validationFuture;
    }

    private static ClusterData getOwnerFromPeerClusterList(PulsarService pulsar, Set<String> replicationClusters) {
        String currentCluster = pulsar.getConfiguration().getClusterName();
        if (replicationClusters == null || replicationClusters.isEmpty() || StringUtils.isBlank(currentCluster)) {
            return null;
        }
        try {
            Optional<ClusterData> cluster = pulsar.getConfigurationCache().clustersCache().get(PulsarWebResource.path("clusters", currentCluster));
            if (!cluster.isPresent() || cluster.get().getPeerClusterNames() == null) {
                return null;
            }
            for (String peerCluster : cluster.get().getPeerClusterNames()) {
                if (!replicationClusters.contains(peerCluster)) continue;
                return pulsar.getConfigurationCache().clustersCache().get(PulsarWebResource.path("clusters", peerCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Peer cluster " + peerCluster + " data not found"));
            }
        }
        catch (Exception e) {
            log.error("Failed to get peer-cluster {}-{}", (Object)currentCluster, (Object)e.getMessage());
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException(e);
        }
        return null;
    }

    protected void checkConnect(TopicName topicName) throws RestException, Exception {
        PulsarWebResource.checkAuthorization(this.pulsar(), topicName, this.clientAppId(), this.clientAuthData());
    }

    protected static void checkAuthorization(PulsarService pulsarService, TopicName topicName, String role, AuthenticationDataSource authenticationData) throws RestException, Exception {
        if (!pulsarService.getConfiguration().isAuthorizationEnabled()) {
            return;
        }
        if (!pulsarService.getBrokerService().getAuthorizationService().canLookup(topicName, role, authenticationData)) {
            log.warn("[{}] Role {} is not allowed to lookup topic", (Object)topicName, (Object)role);
            throw new RestException(Response.Status.UNAUTHORIZED, "Don't have permission to connect to this namespace");
        }
    }

    public void setPulsar(PulsarService pulsar) {
        this.pulsar = pulsar;
    }

    protected boolean isLeaderBroker() {
        return PulsarWebResource.isLeaderBroker(this.pulsar());
    }

    protected static boolean isLeaderBroker(PulsarService pulsar) {
        String leaderAddress = pulsar.getLeaderElectionService().getCurrentLeader().getServiceUrl();
        String myAddress = pulsar.getSafeWebServiceAddress();
        return myAddress.equals(leaderAddress);
    }

    public void validateTenantOperation(String tenant, TenantOperation operation) {
        if (this.pulsar().getConfiguration().isAuthenticationEnabled() && this.pulsar().getBrokerService().isAuthorizationEnabled()) {
            if (!PulsarWebResource.isClientAuthenticated(this.clientAppId())) {
                throw new RestException(Response.Status.UNAUTHORIZED, "Need to authenticate to perform the request");
            }
            boolean isAuthorized = this.pulsar().getBrokerService().getAuthorizationService().allowTenantOperation(tenant, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData());
            if (!isAuthorized) {
                throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateTenantOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on tenant [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), tenant));
            }
        }
    }

    public void validateNamespaceOperation(NamespaceName namespaceName, NamespaceOperation operation) {
        if (this.pulsar().getConfiguration().isAuthenticationEnabled() && this.pulsar().getBrokerService().isAuthorizationEnabled()) {
            if (!PulsarWebResource.isClientAuthenticated(this.clientAppId())) {
                throw new RestException(Response.Status.FORBIDDEN, "Need to authenticate to perform the request");
            }
            boolean isAuthorized = this.pulsar().getBrokerService().getAuthorizationService().allowNamespaceOperation(namespaceName, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData());
            if (!isAuthorized) {
                throw new RestException(Response.Status.FORBIDDEN, String.format("Unauthorized to validateNamespaceOperation for operation [%s] on namespace [%s]", operation.toString(), namespaceName));
            }
        }
    }

    public void validateNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation) {
        if (this.pulsar().getConfiguration().isAuthenticationEnabled() && this.pulsar().getBrokerService().isAuthorizationEnabled()) {
            if (!PulsarWebResource.isClientAuthenticated(this.clientAppId())) {
                throw new RestException(Response.Status.FORBIDDEN, "Need to authenticate to perform the request");
            }
            boolean isAuthorized = this.pulsar().getBrokerService().getAuthorizationService().allowNamespacePolicyOperation(namespaceName, policy, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData());
            if (!isAuthorized) {
                throw new RestException(Response.Status.FORBIDDEN, String.format("Unauthorized to validateNamespacePolicyOperation for operation [%s] on namespace [%s] on policy [%s]", operation.toString(), namespaceName, policy.toString()));
            }
        }
    }
}

