/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.tools;

import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.impl.GenericBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.LinuxBrokerHostUsageImpl;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.Cli;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

public class LoadReportCommand
extends CliCommand<CliFlags, Flags> {
    private static final String NAME = "load-report";
    private static final String DESC = "Collect the load report of a specific broker";

    public LoadReportCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new Flags()).build());
    }

    @Override
    public Boolean apply(CliFlags globalFlags, String[] args) {
        CliSpec<Flags> newSpec = CliSpec.newBuilder(this.spec).withRunFunc(cmdFlags -> this.apply((Flags)cmdFlags)).build();
        return 0 == Cli.runCli(newSpec, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apply(Flags flags) {
        boolean isLinux = SystemUtils.IS_OS_LINUX;
        this.spec.console().println("OS ARCH: " + SystemUtils.OS_ARCH);
        this.spec.console().println("OS NAME: " + SystemUtils.OS_NAME);
        this.spec.console().println("OS VERSION: " + SystemUtils.OS_VERSION);
        this.spec.console().println("Linux: " + isLinux);
        this.spec.console().println("--------------------------------------");
        this.spec.console().println();
        this.spec.console().println("Load Report Interval : " + flags.intervalMilliseconds + " ms");
        this.spec.console().println();
        this.spec.console().println("--------------------------------------");
        this.spec.console().println();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        try {
            BrokerHostUsage hostUsage = isLinux ? new LinuxBrokerHostUsageImpl(Integer.MAX_VALUE, Optional.empty(), scheduler) : new GenericBrokerHostUsageImpl(Integer.MAX_VALUE, scheduler);
            hostUsage.calculateBrokerHostUsage();
            try {
                TimeUnit.MILLISECONDS.sleep(flags.intervalMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            hostUsage.calculateBrokerHostUsage();
            SystemResourceUsage usage = hostUsage.getBrokerHostUsage();
            this.printResourceUsage("CPU", usage.cpu);
            this.printResourceUsage("Memory", usage.memory);
            this.printResourceUsage("Direct Memory", usage.directMemory);
            this.printResourceUsage("Bandwidth In", usage.bandwidthIn);
            this.printResourceUsage("Bandwidth Out", usage.bandwidthOut);
            boolean bl = true;
            return bl;
        }
        finally {
            scheduler.shutdown();
        }
    }

    private void printResourceUsage(String name, ResourceUsage usage) {
        this.spec.console().println(name + " : usage = " + usage.usage + ", limit = " + usage.limit);
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-i", "--interval-ms"}, description="Interval to collect load report, in milliseconds")
        public int intervalMilliseconds = 100;
    }
}

