/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import org.apache.pulsar.broker.stats.prometheus.metrics.DataSketchesOpStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusMetricsProvider;
import org.apache.pulsar.broker.stats.prometheus.metrics.SimpleGauge;
import org.apache.pulsar.shade.com.google.common.base.Joiner;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.LongAdderCounter;

public class PrometheusStatsLogger
implements StatsLogger {
    private final PrometheusMetricsProvider provider;
    private final String scope;

    PrometheusStatsLogger(PrometheusMetricsProvider provider, String scope) {
        this.provider = provider;
        this.scope = scope;
    }

    @Override
    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.completeName(name), x -> new DataSketchesOpStatsLogger());
    }

    @Override
    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.completeName(name), x -> new LongAdderCounter());
    }

    @Override
    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.gauges.computeIfAbsent(this.completeName(name), x -> new SimpleGauge(gauge));
    }

    @Override
    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    @Override
    public void removeScope(String name, StatsLogger statsLogger) {
    }

    @Override
    public StatsLogger scope(String name) {
        return new PrometheusStatsLogger(this.provider, this.completeName(name));
    }

    private String completeName(String name) {
        String completeName = this.scope.isEmpty() ? name : Joiner.on('_').join(this.scope, name, new Object[0]);
        return Collector.sanitizeMetricName(completeName);
    }
}

