/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUnion;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUnionBuilder;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class DataSketchesSummaryLogger {
    private volatile ThreadLocalAccessor current;
    private volatile ThreadLocalAccessor replacement;
    private volatile DoublesSketch values;
    private final LongAdder countAdder = new LongAdder();
    private final LongAdder sumAdder = new LongAdder();

    DataSketchesSummaryLogger() {
        this.current = new ThreadLocalAccessor();
        this.replacement = new ThreadLocalAccessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.countAdder.increment();
        this.sumAdder.add((long)valueMillis);
        LocalData localData = (LocalData)this.current.localData.get();
        long stamp = localData.lock.readLock();
        try {
            localData.successSketch.update(valueMillis);
        }
        finally {
            localData.lock.unlockRead(stamp);
        }
    }

    public void rotateLatencyCollection() {
        ThreadLocalAccessor local = this.current;
        this.current = this.replacement;
        this.replacement = local;
        DoublesUnion aggregateValues = new DoublesUnionBuilder().build();
        local.map.forEach((localData, b) -> {
            long stamp = ((LocalData)localData).lock.writeLock();
            try {
                aggregateValues.update(((LocalData)localData).successSketch);
                ((LocalData)localData).successSketch.reset();
            }
            finally {
                ((LocalData)localData).lock.unlockWrite(stamp);
            }
        });
        this.values = aggregateValues.getResultAndReset();
    }

    public long getCount() {
        return this.countAdder.sum();
    }

    public long getSum() {
        return this.sumAdder.sum();
    }

    public double getQuantileValue(double quantile) {
        DoublesSketch s = this.values;
        return s != null ? s.getQuantile(quantile) : Double.NaN;
    }

    private static class ThreadLocalAccessor {
        private final Map<LocalData, Boolean> map = new ConcurrentHashMap<LocalData, Boolean>();
        private final FastThreadLocal<LocalData> localData = new FastThreadLocal<LocalData>(){

            @Override
            protected LocalData initialValue() throws Exception {
                LocalData localData = new LocalData();
                map.put(localData, Boolean.TRUE);
                return localData;
            }

            @Override
            protected void onRemoval(LocalData value) throws Exception {
                map.remove(value);
            }
        };

        private ThreadLocalAccessor() {
        }
    }

    private static class LocalData {
        private final DoublesSketch successSketch = new DoublesSketchBuilder().build();
        private final StampedLock lock = new StampedLock();

        private LocalData() {
        }
    }
}

