/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.stats.DimensionStats;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class BrokerOperabilityMetrics {
    private final List<Metrics> metricsList = new ArrayList<Metrics>();
    private final String localCluster;
    private final DimensionStats topicLoadStats;
    private final DimensionStats zkWriteLatencyStats;
    private final DimensionStats zkReadLatencyStats;
    private final String brokerName;

    public BrokerOperabilityMetrics(String localCluster, String brokerName) {
        this.localCluster = localCluster;
        this.topicLoadStats = new DimensionStats("topic_load_times", 60L);
        this.zkWriteLatencyStats = new DimensionStats("zk_write_latency", 60L);
        this.zkReadLatencyStats = new DimensionStats("zk_read_latency", 60L);
        this.brokerName = brokerName;
    }

    public List<Metrics> getMetrics() {
        this.generate();
        return this.metricsList;
    }

    private void generate() {
        this.metricsList.add(this.getTopicLoadMetrics());
        this.metricsList.add(this.getZkWriteLatencyMetrics());
        this.metricsList.add(this.getZkReadLatencyMetrics());
    }

    Metrics getTopicLoadMetrics() {
        return this.getDimensionMetrics("topic_load_times", "topic_load", this.topicLoadStats);
    }

    Metrics getZkWriteLatencyMetrics() {
        return this.getDimensionMetrics("zk_write_latency", "zk_write", this.zkWriteLatencyStats);
    }

    Metrics getZkReadLatencyMetrics() {
        return this.getDimensionMetrics("zk_read_latency", "zk_read", this.zkReadLatencyStats);
    }

    Metrics getDimensionMetrics(String metricsName, String dimensionName, DimensionStats stats) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("broker", this.brokerName);
        dimensionMap.put("cluster", this.localCluster);
        dimensionMap.put("metric", metricsName);
        Metrics dMetrics = Metrics.create(dimensionMap);
        dMetrics.put("brk_" + dimensionName + "_time_mean_ms", stats.getMeanDimension());
        dMetrics.put("brk_" + dimensionName + "_time_median_ms", stats.getMedianDimension());
        dMetrics.put("brk_" + dimensionName + "_time_75percentile_ms", stats.getDimension75());
        dMetrics.put("brk_" + dimensionName + "_time_95percentile_ms", stats.getDimension95());
        dMetrics.put("brk_" + dimensionName + "_time_99_percentile_ms", stats.getDimension99());
        dMetrics.put("brk_" + dimensionName + "_time_99_9_percentile_ms", stats.getDimension999());
        dMetrics.put("brk_" + dimensionName + "_time_99_99_percentile_ms", stats.getDimension9999());
        dMetrics.put("brk_" + dimensionName + "_rate_s", stats.getDimensionCount());
        return dMetrics;
    }

    public void reset() {
        this.metricsList.clear();
        this.topicLoadStats.reset();
        this.zkWriteLatencyStats.reset();
        this.zkReadLatencyStats.reset();
    }

    public void recordTopicLoadTimeValue(long topicLoadLatencyMs) {
        this.topicLoadStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordZkWriteLatencyTimeValue(long topicLoadLatencyMs) {
        this.zkWriteLatencyStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordZkReadLatencyTimeValue(long topicLoadLatencyMs) {
        this.zkReadLatencyStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }
}

