/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStickyKeyDispatcherMultipleConsumers
extends PersistentDispatcherMultipleConsumers {
    private final boolean allowOutOfOrderDelivery;
    private final StickyKeyConsumerSelector selector;
    private boolean isDispatcherStuckOnReplays = false;
    private final LinkedHashMap<Consumer, PositionImpl> recentlyJoinedConsumers;
    private final Set<Consumer> stuckConsumers;
    private final Set<Consumer> nextStuckConsumers;
    private static final FastThreadLocal<Map<Consumer, List<Entry>>> localGroupedEntries = new FastThreadLocal<Map<Consumer, List<Entry>>>(){

        @Override
        protected Map<Consumer, List<Entry>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Entry>>();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PersistentStickyKeyDispatcherMultipleConsumers.class);

    PersistentStickyKeyDispatcherMultipleConsumers(PersistentTopic topic, ManagedCursor cursor, Subscription subscription, ServiceConfiguration conf, PulsarApi.KeySharedMeta ksm) {
        super(topic, cursor, subscription);
        this.allowOutOfOrderDelivery = ksm.getAllowOutOfOrderDelivery();
        this.recentlyJoinedConsumers = this.allowOutOfOrderDelivery ? null : new LinkedHashMap();
        this.stuckConsumers = new HashSet<Consumer>();
        this.nextStuckConsumers = new HashSet<Consumer>();
        switch (ksm.getKeySharedMode()) {
            case AUTO_SPLIT: {
                if (conf.isSubscriptionKeySharedUseConsistentHashing()) {
                    this.selector = new ConsistentHashingStickyKeyConsumerSelector(conf.getSubscriptionKeySharedConsistentHashingReplicaPoints());
                    break;
                }
                this.selector = new HashRangeAutoSplitStickyKeyConsumerSelector();
                break;
            }
            case STICKY: {
                this.selector = new HashRangeExclusiveStickyKeyConsumerSelector();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key-shared mode: " + (Object)((Object)ksm.getKeySharedMode()));
            }
        }
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws BrokerServiceException {
        super.addConsumer(consumer);
        try {
            this.selector.addConsumer(consumer);
        }
        catch (BrokerServiceException e) {
            this.consumerSet.removeAll(consumer);
            this.consumerList.remove(consumer);
            throw e;
        }
        PositionImpl readPositionWhenJoining = (PositionImpl)this.cursor.getReadPosition();
        consumer.setReadPositionWhenJoining(readPositionWhenJoining);
        if (!this.allowOutOfOrderDelivery && this.recentlyJoinedConsumers != null && this.consumerList.size() > 1 && this.cursor.getNumberOfEntriesSinceFirstNotAckedMessage() > 1L) {
            this.recentlyJoinedConsumers.put(consumer, readPositionWhenJoining);
        }
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        super.removeConsumer(consumer);
        this.selector.removeConsumer(consumer);
        if (this.recentlyJoinedConsumers != null) {
            this.recentlyJoinedConsumers.remove(consumer);
            if (this.consumerList.size() == 1) {
                this.recentlyJoinedConsumers.clear();
            }
            if (this.removeConsumersFromRecentJoinedConsumers() || this.messagesToRedeliver.size() > 0L) {
                this.readMoreEntries();
            }
        }
    }

    @Override
    protected void sendMessagesToConsumers(PersistentDispatcherMultipleConsumers.ReadType readType, List<Entry> entries) {
        long totalMessagesSent = 0L;
        long totalBytesSent = 0L;
        int entriesCount = entries.size();
        if (entriesCount == 0) {
            this.readMoreEntries();
            return;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            this.cursor.rewind();
            return;
        }
        this.nextStuckConsumers.clear();
        Map<Consumer, List<Entry>> groupedEntries = localGroupedEntries.get();
        groupedEntries.clear();
        for (Entry entry : entries) {
            Consumer c = this.selector.select(this.peekStickyKey(entry.getDataBuffer()));
            groupedEntries.computeIfAbsent(c, k -> new ArrayList()).add(entry);
        }
        AtomicInteger keyNumbers = new AtomicInteger(groupedEntries.size());
        int currentThreadKeyNumber = groupedEntries.size();
        if (currentThreadKeyNumber == 0) {
            currentThreadKeyNumber = -1;
        }
        for (Map.Entry<Consumer, List<Entry>> current : groupedEntries.entrySet()) {
            Entry entry;
            int i;
            Consumer consumer = current.getKey();
            List<Entry> entriesWithSameKey = current.getValue();
            int entriesWithSameKeyCount = entriesWithSameKey.size();
            int availablePermits = consumer == null ? 0 : Math.max(consumer.getAvailablePermits(), 0);
            int maxMessagesForC = Math.min(entriesWithSameKeyCount, availablePermits);
            int messagesForC = this.getRestrictedMaxEntriesForConsumer(consumer, entriesWithSameKey, maxMessagesForC, readType);
            if (log.isDebugEnabled()) {
                log.debug("[{}] select consumer {} with messages num {}, read type is {}", new Object[]{this.name, consumer.consumerName(), messagesForC, readType});
            }
            if (messagesForC < entriesWithSameKeyCount) {
                for (i = messagesForC; i < entriesWithSameKeyCount; ++i) {
                    entry = entriesWithSameKey.get(i);
                    this.messagesToRedeliver.add(entry.getLedgerId(), entry.getEntryId());
                    entry.release();
                    entriesWithSameKey.set(i, null);
                }
            }
            if (messagesForC > 0) {
                if (readType == PersistentDispatcherMultipleConsumers.ReadType.Replay) {
                    for (i = 0; i < messagesForC; ++i) {
                        entry = entriesWithSameKey.get(i);
                        this.messagesToRedeliver.remove(entry.getLedgerId(), entry.getEntryId());
                    }
                }
                SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
                EntryBatchSizes batchSizes = EntryBatchSizes.get(messagesForC);
                EntryBatchIndexesAcks batchIndexesAcks = EntryBatchIndexesAcks.get(messagesForC);
                this.filterEntriesForConsumer(entriesWithSameKey, batchSizes, sendMessageInfo, batchIndexesAcks, this.cursor, readType == PersistentDispatcherMultipleConsumers.ReadType.Replay);
                consumer.sendMessages(entriesWithSameKey, batchSizes, batchIndexesAcks, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker()).addListener(future -> {
                    if (future.isDone() && keyNumbers.decrementAndGet() == 0) {
                        this.readMoreEntries();
                    }
                });
                TOTAL_AVAILABLE_PERMITS_UPDATER.getAndAdd(this, -(sendMessageInfo.getTotalMessages() - batchIndexesAcks.getTotalAckedIndexCount()));
                totalMessagesSent += (long)sendMessageInfo.getTotalMessages();
                totalBytesSent += sendMessageInfo.getTotalBytes();
                continue;
            }
            currentThreadKeyNumber = keyNumbers.decrementAndGet();
        }
        if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) {
            if (this.topic.getDispatchRateLimiter().isPresent()) {
                this.topic.getDispatchRateLimiter().get().tryDispatchPermit(totalMessagesSent, totalBytesSent);
            }
            if (this.dispatchRateLimiter.isPresent()) {
                ((DispatchRateLimiter)this.dispatchRateLimiter.get()).tryDispatchPermit(totalMessagesSent, totalBytesSent);
            }
        }
        this.stuckConsumers.clear();
        if (totalMessagesSent == 0L && (this.recentlyJoinedConsumers == null || this.recentlyJoinedConsumers.isEmpty())) {
            if (!this.nextStuckConsumers.isEmpty()) {
                this.isDispatcherStuckOnReplays = true;
                this.stuckConsumers.addAll(this.nextStuckConsumers);
            }
            this.readMoreEntries();
        } else if (currentThreadKeyNumber == 0) {
            this.topic.getBrokerService().executor().schedule(() -> {
                PersistentStickyKeyDispatcherMultipleConsumers persistentStickyKeyDispatcherMultipleConsumers = this;
                synchronized (persistentStickyKeyDispatcherMultipleConsumers) {
                    this.readMoreEntries();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private int getRestrictedMaxEntriesForConsumer(Consumer consumer, List<Entry> entries, int maxMessages, PersistentDispatcherMultipleConsumers.ReadType readType) {
        PositionImpl minReadPositionForRecentJoinedConsumer;
        if (maxMessages == 0) {
            this.nextStuckConsumers.add(consumer);
            return 0;
        }
        if (this.recentlyJoinedConsumers == null) {
            return maxMessages;
        }
        this.removeConsumersFromRecentJoinedConsumers();
        PositionImpl maxReadPosition = this.recentlyJoinedConsumers.get(consumer);
        if (maxReadPosition == null) {
            if (this.stuckConsumers.contains(consumer)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] stop to dispatch by stuckConsumers, consumer: {}", (Object)this.name, (Object)consumer);
                }
                return 0;
            }
            return maxMessages;
        }
        if (readType == PersistentDispatcherMultipleConsumers.ReadType.Replay && (minReadPositionForRecentJoinedConsumer = this.recentlyJoinedConsumers.values().iterator().next()) != null && minReadPositionForRecentJoinedConsumer.compareTo(maxReadPosition) < 0) {
            maxReadPosition = minReadPositionForRecentJoinedConsumer;
        }
        for (int i = 0; i < maxMessages; ++i) {
            if (((PositionImpl)entries.get(i).getPosition()).compareTo(maxReadPosition) < 0) continue;
            return i;
        }
        return maxMessages;
    }

    @Override
    public synchronized void markDeletePositionMoveForward() {
        if (this.recentlyJoinedConsumers != null && !this.recentlyJoinedConsumers.isEmpty() && this.removeConsumersFromRecentJoinedConsumers()) {
            this.readMoreEntries();
        }
    }

    private boolean removeConsumersFromRecentJoinedConsumers() {
        Iterator<Map.Entry<Consumer, PositionImpl>> itr = this.recentlyJoinedConsumers.entrySet().iterator();
        boolean hasConsumerRemovedFromTheRecentJoinedConsumers = false;
        PositionImpl mdp = (PositionImpl)this.cursor.getMarkDeletedPosition();
        if (mdp != null) {
            Map.Entry<Consumer, PositionImpl> entry;
            PositionImpl nextPositionOfTheMarkDeletePosition = ((ManagedLedgerImpl)this.cursor.getManagedLedger()).getNextValidPosition(mdp);
            while (itr.hasNext() && (entry = itr.next()).getValue().compareTo(nextPositionOfTheMarkDeletePosition) <= 0) {
                itr.remove();
                hasConsumerRemovedFromTheRecentJoinedConsumers = true;
            }
        }
        return hasConsumerRemovedFromTheRecentJoinedConsumers;
    }

    @Override
    protected synchronized Set<PositionImpl> getMessagesToReplayNow(int maxMessagesToRead) {
        if (this.isDispatcherStuckOnReplays) {
            this.isDispatcherStuckOnReplays = false;
            return Collections.emptySet();
        }
        return super.getMessagesToReplayNow(maxMessagesToRead);
    }

    @Override
    public PulsarApi.CommandSubscribe.SubType getType() {
        return PulsarApi.CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    protected Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions) {
        return this.cursor.asyncReplayEntries(positions, this, (Object)PersistentDispatcherMultipleConsumers.ReadType.Replay, true);
    }

    public LinkedHashMap<Consumer, PositionImpl> getRecentlyJoinedConsumers() {
        return this.recentlyJoinedConsumers;
    }

    public Map<String, List<String>> getConsumerKeyHashRanges() {
        return this.selector.getConsumerKeyHashRanges();
    }
}

