/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.BoundType;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUnitZkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceService.class);
    public static final String UTF8 = "UTF8";
    private static final ObjectMapper jsonMapper = ObjectMapperFactory.create();
    public static final String OWNER_INFO_ROOT = "/namespace";

    public static String path(NamespaceBundle suname) {
        return "/namespace/" + suname.toString();
    }

    public static NamespaceBundle suBundleFromPath(String path, NamespaceBundleFactory factory) {
        String[] parts = path.split("/");
        Preconditions.checkArgument(parts.length > 2);
        Preconditions.checkArgument(parts[1].equals("namespace"));
        Preconditions.checkArgument(parts.length > 4);
        if (parts.length > 5) {
            Range<Long> range = ServiceUnitZkUtils.getHashRange(parts[5]);
            return factory.getBundle(NamespaceName.get(parts[2], parts[3], parts[4]), range);
        }
        Range<Long> range = ServiceUnitZkUtils.getHashRange(parts[4]);
        return factory.getBundle(NamespaceName.get(parts[2], parts[3]), range);
    }

    private static Range<Long> getHashRange(String rangePathPart) {
        String[] endPoints = rangePathPart.split("_");
        Preconditions.checkArgument(endPoints.length == 2, "Malformed bundle hash range path part:" + rangePathPart);
        Long startLong = Long.decode(endPoints[0]);
        Long endLong = Long.decode(endPoints[1]);
        BoundType endType = endPoints[1].equals("0xffffffff") ? BoundType.CLOSED : BoundType.OPEN;
        return Range.range(startLong, BoundType.CLOSED, endLong, endType);
    }

    public static void initZK(ZooKeeper zkc, String selfBrokerUrl) {
        try {
            LocalZooKeeperConnectionService.checkAndCreatePersistNode(zkc, OWNER_INFO_ROOT);
            ServiceUnitZkUtils.cleanupNamespaceNodes(zkc, OWNER_INFO_ROOT, selfBrokerUrl);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void cleanupNamespaceNodes(ZooKeeper zkc, String root, String selfBrokerUrl) throws Exception {
        try {
            for (String node : zkc.getChildren(root, false)) {
                String currentPath = root + "/" + node;
                List<String> children = zkc.getChildren(currentPath, false);
                if (children.size() == 0) {
                    ServiceUnitZkUtils.cleanupSingleNamespaceNode(zkc, currentPath, selfBrokerUrl);
                    continue;
                }
                ServiceUnitZkUtils.cleanupNamespaceNodes(zkc, currentPath, selfBrokerUrl);
            }
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.info("No children for [{}]", (Object)nne.getPath());
        }
    }

    private static void cleanupSingleNamespaceNode(ZooKeeper zkc, String path, String selfBrokerUrl) throws Exception {
        String brokerUrl = null;
        try {
            byte[] data = zkc.getData(path, false, null);
            if (data == null || data.length == 0) {
                return;
            }
            NamespaceEphemeralData zdata = jsonMapper.readValue(data, NamespaceEphemeralData.class);
            brokerUrl = zdata.getNativeUrl();
            if (selfBrokerUrl.equals(brokerUrl)) {
                zkc.delete(path, -1);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static NamespaceEphemeralData acquireNameSpace(ZooKeeper zkc, String path, NamespaceEphemeralData value) throws KeeperException, InterruptedException, JsonGenerationException, JsonMappingException, IOException {
        String data = jsonMapper.writeValueAsString(value);
        ServiceUnitZkUtils.createZnodeOptimistic(zkc, path, data, CreateMode.EPHEMERAL);
        return value;
    }

    public static BundlesData createBundlesIfAbsent(ZooKeeper zkc, String path, BundlesData initialBundles) throws JsonGenerationException, JsonMappingException, IOException, KeeperException, InterruptedException {
        String data = jsonMapper.writeValueAsString(initialBundles);
        ServiceUnitZkUtils.createZnodeOptimistic(zkc, path, data, CreateMode.PERSISTENT);
        return initialBundles;
    }

    private static void createZnodeOptimistic(ZooKeeper zkc, String path, String data, CreateMode mode) throws KeeperException, InterruptedException {
        try {
            Preconditions.checkNotNull(LocalZooKeeperConnectionService.createIfAbsent(zkc, path, data, mode));
        }
        catch (KeeperException.NoNodeException e) {
            String[] parts = path.split("/");
            if (parts.length > 3) {
                String int_path = path.substring(0, path.lastIndexOf("/"));
                if (zkc.exists(int_path, false) == null) {
                    try {
                        ZkUtils.createFullPathOptimistic(zkc, int_path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException nee) {
                        LOG.debug("Other broker preempted the full intermediate path [{}] already. Continue for acquiring the leaf ephemeral node.", (Object)int_path);
                    }
                }
                Preconditions.checkNotNull(LocalZooKeeperConnectionService.createIfAbsent(zkc, path, data, mode));
            }
            throw e;
        }
    }
}

