/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.v2;

import org.apache.pulsar.broker.lookup.TopicLookupBase;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.DefaultValue;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;

@Path(value="/v2/topic")
public class TopicLookup
extends TopicLookupBase {
    @GET
    @Path(value="{topic-domain}/{tenant}/{namespace}/{topic}")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic")})
    public void lookupTopicAsync(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse asyncResponse) {
        TopicName topicName = this.getTopicName(topicDomain, tenant, namespace, encodedTopic);
        this.internalLookupTopicAsync(topicName, authoritative, asyncResponse);
    }

    @GET
    @Path(value="{topic-domain}/{tenant}/{namespace}/{topic}/bundle")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Invalid topic domain type")})
    public String getNamespaceBundle(@PathParam(value="topic-domain") String topicDomain, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        TopicName topicName = this.getTopicName(topicDomain, tenant, namespace, encodedTopic);
        return this.internalGetNamespaceBundle(topicName);
    }
}

