/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.OpAddEntry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogImpl;
import org.apache.pulsar.transaction.coordinator.proto.TransactionMetadataEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLTransactionSequenceIdGenerator
implements ManagedLedgerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MLTransactionSequenceIdGenerator.class);
    private static final long TC_ID_NOT_USED = -1L;
    public static final String MAX_LOCAL_TXN_ID = "max_local_txn_id";
    private final AtomicLong sequenceId = new AtomicLong(-1L);

    @Override
    public OpAddEntry beforeAddEntry(OpAddEntry op, int numberOfMessages) {
        return op;
    }

    @Override
    public void onManagedLedgerPropertiesInitialize(Map<String, String> propertiesMap) {
        if (propertiesMap == null || propertiesMap.size() == 0) {
            return;
        }
        if (propertiesMap.containsKey(MAX_LOCAL_TXN_ID)) {
            this.sequenceId.set(Long.parseLong(propertiesMap.get(MAX_LOCAL_TXN_ID)));
        }
    }

    @Override
    public CompletableFuture<Void> onManagedLedgerLastLedgerInitialize(String name, LedgerHandle lh) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        if (lh.getLastAddConfirmed() >= 0L) {
            lh.readAsync(lh.getLastAddConfirmed(), lh.getLastAddConfirmed()).whenComplete((entries, ex) -> {
                if (ex != null) {
                    log.error("[{}] Read last entry error.", (Object)name, ex);
                    promise.completeExceptionally((Throwable)ex);
                } else if (entries != null) {
                    try {
                        List<TransactionMetadataEntry> transactionLogs;
                        LedgerEntry ledgerEntry = entries.getEntry(lh.getLastAddConfirmed());
                        if (ledgerEntry != null && !CollectionUtils.isEmpty(transactionLogs = MLTransactionLogImpl.deserializeEntry(ledgerEntry.getEntryBuffer()))) {
                            TransactionMetadataEntry lastConfirmEntry = transactionLogs.get(transactionLogs.size() - 1);
                            this.sequenceId.set(lastConfirmEntry.getMaxLocalTxnId());
                        }
                        entries.close();
                        promise.complete(null);
                    }
                    catch (Exception e) {
                        entries.close();
                        log.error("[{}] Failed to recover the tc sequenceId from the last add confirmed entry.", (Object)name, (Object)e);
                        promise.completeExceptionally(e);
                    }
                } else {
                    promise.complete(null);
                }
            });
        } else {
            promise.complete(null);
        }
        return promise;
    }

    @Override
    public void onUpdateManagedLedgerInfo(Map<String, String> propertiesMap) {
        propertiesMap.put(MAX_LOCAL_TXN_ID, "" + this.sequenceId.get());
    }

    long generateSequenceId() {
        return this.sequenceId.incrementAndGet();
    }

    long getCurrentSequenceId() {
        return this.sequenceId.get();
    }
}

