/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.MappedResource;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.MatchedPath;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.MatchedResource;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.PathSpec;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.apache.pulsar.shade.org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ArrayTernaryTrie;
import org.apache.pulsar.shade.org.eclipse.jetty.util.Trie;
import org.apache.pulsar.shade.org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.apache.pulsar.shade.org.eclipse.jetty.util.annotation.ManagedObject;
import org.apache.pulsar.shade.org.eclipse.jetty.util.component.Dumpable;
import org.apache.pulsar.shade.org.eclipse.jetty.util.log.Log;
import org.apache.pulsar.shade.org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private final Set<MappedResource<E>> _mappings = new TreeSet<MappedResource>(Comparator.comparing(MappedResource::getPathSpec));
    private boolean _optimizedExact = true;
    private Trie<MappedResource<E>> _exactMap = new ArrayTernaryTrie<MappedResource<E>>(false);
    private boolean _optimizedPrefix = true;
    private Trie<MappedResource<E>> _prefixMap = new ArrayTernaryTrie<MappedResource<E>>(false);
    private boolean _optimizedSuffix = true;
    private Trie<MappedResource<E>> _suffixMap = new ArrayTernaryTrie<MappedResource<E>>(false);

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this.toString(), this._mappings);
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return new ArrayList<MappedResource<E>>(this._mappings);
    }

    public int size() {
        return this._mappings.size();
    }

    public void reset() {
        this._mappings.clear();
        this._prefixMap.clear();
        this._suffixMap.clear();
    }

    public void removeIf(Predicate<MappedResource<E>> predicate) {
        this._mappings.removeIf(predicate);
    }

    public List<MatchedResource<E>> getMatchedList(String path) {
        ArrayList<MatchedResource<MatchedResource<E>>> ret = new ArrayList<MatchedResource<MatchedResource<E>>>();
        for (MappedResource<E> mr : this._mappings) {
            MatchedPath matchedPath = mr.getPathSpec().matched(path);
            if (matchedPath == null) continue;
            ret.add(new MatchedResource<E>(mr.getResource(), mr.getPathSpec(), matchedPath));
        }
        return ret;
    }

    public List<MappedResource<E>> getMatches(String path) {
        boolean isRootPath = "/".equals(path);
        ArrayList<MappedResource<MappedResource<E>>> ret = new ArrayList<MappedResource<MappedResource<E>>>();
        block4: for (MappedResource<E> mr : this._mappings) {
            switch (mr.getPathSpec().getGroup()) {
                case ROOT: {
                    if (!isRootPath) continue block4;
                    ret.add(mr);
                    continue block4;
                }
                case DEFAULT: {
                    if (!isRootPath && mr.getPathSpec().matched(path) == null) continue block4;
                    ret.add(mr);
                    continue block4;
                }
            }
            if (mr.getPathSpec().matched(path) == null) continue;
            ret.add(mr);
        }
        return ret;
    }

    public MatchedResource<E> getMatched(String path) {
        PathSpecGroup lastGroup = null;
        boolean skipRestOfGroup = false;
        for (MappedResource<E> mr : this._mappings) {
            MatchedPath matchedPath;
            PathSpecGroup group = mr.getPathSpec().getGroup();
            if (group == lastGroup && skipRestOfGroup) continue;
            if (group != lastGroup) {
                skipRestOfGroup = false;
                switch (group) {
                    case EXACT: {
                        MappedResource<E> candidate;
                        if (!this._optimizedExact) break;
                        int i = path.length();
                        while (i >= 0) {
                            if ((candidate = this._exactMap.getBest(path, 0, i--)) == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource<E>(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        skipRestOfGroup = true;
                        break;
                    }
                    case PREFIX_GLOB: {
                        MappedResource<E> candidate;
                        if (!this._optimizedPrefix) break;
                        int i = path.length();
                        while (i >= 0) {
                            if ((candidate = this._prefixMap.getBest(path, 0, i--)) == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource<E>(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        skipRestOfGroup = true;
                        break;
                    }
                    case SUFFIX_GLOB: {
                        MappedResource<E> candidate;
                        if (!this._optimizedSuffix) break;
                        int i = 0;
                        while ((i = path.indexOf(46, i + 1)) > 0) {
                            candidate = this._suffixMap.get(path, i + 1, path.length() - i - 1);
                            if (candidate == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource<E>(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        skipRestOfGroup = true;
                        break;
                    }
                }
            }
            if ((matchedPath = mr.getPathSpec().matched(path)) != null) {
                return new MatchedResource<E>(mr.getResource(), mr.getPathSpec(), matchedPath);
            }
            lastGroup = group;
        }
        return null;
    }

    @Deprecated
    public MappedResource<E> getMatch(String path) {
        throw new UnsupportedOperationException("Use .getMatched(String) instead");
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this._mappings.iterator();
    }

    @Deprecated
    public static PathSpec asPathSpec(String pathSpecString) {
        return PathSpec.from(pathSpecString);
    }

    public E get(PathSpec spec) {
        return this._mappings.stream().filter(mappedResource -> mappedResource.getPathSpec().equals(spec)).map(MappedResource::getResource).findFirst().orElse(null);
    }

    public boolean put(String pathSpecString, E resource) {
        return this.put(PathSpec.from(pathSpecString), resource);
    }

    public boolean put(PathSpec pathSpec, E resource) {
        MappedResource<E> entry = new MappedResource<E>(pathSpec, resource);
        boolean added = this._mappings.add(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", added ? "Added" : "Ignored", entry, this);
        }
        if (added) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String exact = pathSpec.getDeclaration();
                        while (exact != null && !this._exactMap.put(exact, entry)) {
                            this._exactMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._exactMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedExact = false;
                    break;
                }
                case PREFIX_GLOB: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String prefix = pathSpec.getPrefix();
                        while (prefix != null && !this._prefixMap.put(prefix, entry)) {
                            this._prefixMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedPrefix = false;
                    break;
                }
                case SUFFIX_GLOB: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String suffix = pathSpec.getSuffix();
                        while (suffix != null && !this._suffixMap.put(suffix, entry)) {
                            this._suffixMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedSuffix = false;
                    break;
                }
            }
        }
        return added;
    }

    public boolean remove(PathSpec pathSpec) {
        Iterator<MappedResource<E>> iter = this._mappings.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!iter.next().getPathSpec().equals(pathSpec)) continue;
            removed = true;
            iter.remove();
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", removed ? "Removed" : "Ignored", pathSpec, this);
        }
        if (removed) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    String exact = pathSpec.getDeclaration();
                    if (exact == null) break;
                    this._exactMap.remove(exact);
                    this._optimizedExact = this.canBeOptimized(PathSpecGroup.EXACT);
                    break;
                }
                case PREFIX_GLOB: {
                    String prefix = pathSpec.getPrefix();
                    if (prefix == null) break;
                    this._prefixMap.remove(prefix);
                    this._optimizedPrefix = this.canBeOptimized(PathSpecGroup.PREFIX_GLOB);
                    break;
                }
                case SUFFIX_GLOB: {
                    String suffix = pathSpec.getSuffix();
                    if (suffix == null) break;
                    this._suffixMap.remove(suffix);
                    this._optimizedSuffix = this.canBeOptimized(PathSpecGroup.SUFFIX_GLOB);
                }
            }
        }
        return removed;
    }

    private boolean canBeOptimized(PathSpecGroup suffixGlob) {
        return this._mappings.stream().filter(mapping -> mapping.getPathSpec().getGroup() == suffixGlob).allMatch(mapping -> mapping.getPathSpec() instanceof ServletPathSpec);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this._mappings.size());
    }
}

