/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import javax.security.sasl.SaslException;
import org.apache.pulsar.shade.org.apache.jute.BinaryInputArchive;
import org.apache.pulsar.shade.org.apache.jute.BinaryOutputArchive;
import org.apache.pulsar.shade.org.apache.jute.Record;
import org.apache.pulsar.shade.org.apache.zookeeper.Environment;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.Quotas;
import org.apache.pulsar.shade.org.apache.zookeeper.StatsTrack;
import org.apache.pulsar.shade.org.apache.zookeeper.Version;
import org.apache.pulsar.shade.org.apache.zookeeper.ZookeeperBanner;
import org.apache.pulsar.shade.org.apache.zookeeper.common.PathUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.common.StringUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.common.Time;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Id;
import org.apache.pulsar.shade.org.apache.zookeeper.data.StatPersisted;
import org.apache.pulsar.shade.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.pulsar.shade.org.apache.zookeeper.metrics.MetricsContext;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.AuthPacket;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.ConnectRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.ConnectResponse;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.CreateRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.DeleteRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.ReplyHeader;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.RequestHeader;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.SetACLRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.SetDataRequest;
import org.apache.pulsar.shade.org.apache.zookeeper.proto.SetSASLResponse;
import org.apache.pulsar.shade.org.apache.zookeeper.server.AuthenticationHelper;
import org.apache.pulsar.shade.org.apache.zookeeper.server.BlueThrottle;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ClientCnxnLimitException;
import org.apache.pulsar.shade.org.apache.zookeeper.server.DataNode;
import org.apache.pulsar.shade.org.apache.zookeeper.server.DataTree;
import org.apache.pulsar.shade.org.apache.zookeeper.server.DataTreeBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ExitCode;
import org.apache.pulsar.shade.org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.RateLogger;
import org.apache.pulsar.shade.org.apache.zookeeper.server.Request;
import org.apache.pulsar.shade.org.apache.zookeeper.server.RequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.RequestThrottler;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ResponseCache;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerCnxn;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerStats;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SessionTracker;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.UnimplementedRequestProcessor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZKDatabase;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperSaslServer;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerConf;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerListenerImpl;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerShutdownHandler;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooTrace;
import org.apache.pulsar.shade.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.pulsar.shade.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import org.apache.pulsar.shade.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.pulsar.shade.org.apache.zookeeper.server.util.JvmPauseMonitor;
import org.apache.pulsar.shade.org.apache.zookeeper.server.util.OSMXBean;
import org.apache.pulsar.shade.org.apache.zookeeper.server.util.QuotaMetricsUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import org.apache.pulsar.shade.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.pulsar.shade.org.apache.zookeeper.txn.TxnDigest;
import org.apache.pulsar.shade.org.apache.zookeeper.txn.TxnHeader;
import org.apache.pulsar.shade.org.apache.zookeeper.util.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServer
implements SessionTracker.SessionExpirer,
ServerStats.Provider {
    protected static final Logger LOG;
    private static final RateLogger RATE_LOGGER;
    public static final String GLOBAL_OUTSTANDING_LIMIT = "zookeeper.globalOutstandingLimit";
    public static final String ENABLE_EAGER_ACL_CHECK = "zookeeper.enableEagerACLCheck";
    public static final String SKIP_ACL = "zookeeper.skipACL";
    public static final String ENFORCE_QUOTA = "zookeeper.enforceQuota";
    static boolean enableEagerACLCheck;
    static final boolean skipACL;
    public static final boolean enforceQuota;
    public static final String SASL_SUPER_USER = "zookeeper.superUser";
    public static final String ALLOW_SASL_FAILED_CLIENTS = "zookeeper.allowSaslFailedClients";
    public static final String ZOOKEEPER_DIGEST_ENABLED = "zookeeper.digest.enabled";
    private static boolean digestEnabled;
    public static final String CLOSE_SESSION_TXN_ENABLED = "zookeeper.closeSessionTxn.enabled";
    private static boolean closeSessionTxnEnabled;
    protected ZooKeeperServerBean jmxServerBean;
    protected DataTreeBean jmxDataTreeBean;
    public static final int DEFAULT_TICK_TIME = 3000;
    protected int tickTime = 3000;
    public static final int DEFAULT_THROTTLED_OP_WAIT_TIME = 0;
    protected static volatile int throttledOpWaitTime;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int listenBacklog = -1;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ZKDatabase zkDb;
    private ResponseCache readResponseCache;
    private ResponseCache getChildrenResponseCache;
    private final AtomicLong hzxid = new AtomicLong(0L);
    public static final Exception ok;
    protected RequestProcessor firstProcessor;
    protected JvmPauseMonitor jvmPauseMonitor;
    protected volatile State state = State.INITIAL;
    private boolean isResponseCachingEnabled = true;
    protected String initialConfig;
    protected boolean reconfigEnabled;
    private final RequestPathMetricsCollector requestPathMetricsCollector;
    private static final int DEFAULT_SNAP_COUNT = 100000;
    private static final int DEFAULT_GLOBAL_OUTSTANDING_LIMIT = 1000;
    private boolean localSessionEnabled = false;
    private static final long superSecret = 3007405056L;
    private final AtomicInteger requestsInProcess = new AtomicInteger(0);
    final Deque<ChangeRecord> outstandingChanges = new ArrayDeque<ChangeRecord>();
    final Map<String, ChangeRecord> outstandingChangesForPath = new HashMap<String, ChangeRecord>();
    protected ServerCnxnFactory serverCnxnFactory;
    protected ServerCnxnFactory secureServerCnxnFactory;
    private final ServerStats serverStats;
    private final ZooKeeperServerListener listener;
    private ZooKeeperServerShutdownHandler zkShutdownHandler;
    private volatile int createSessionTrackerServerId = 1;
    private static final String FLUSH_DELAY = "zookeeper.flushDelay";
    private static volatile long flushDelay;
    private static final String MAX_WRITE_QUEUE_POLL_SIZE = "zookeeper.maxWriteQueuePollTime";
    private static volatile long maxWriteQueuePollTime;
    private static final String MAX_BATCH_SIZE = "zookeeper.maxBatchSize";
    private static volatile int maxBatchSize;
    public static final String INT_BUFFER_STARTING_SIZE_BYTES = "zookeeper.intBufferStartingSizeBytes";
    public static final int DEFAULT_STARTING_BUFFER_SIZE = 1024;
    public static final int intBufferStartingSizeBytes;
    public static final String GET_DATA_RESPONSE_CACHE_SIZE = "zookeeper.maxResponseCacheSize";
    public static final String GET_CHILDREN_RESPONSE_CACHE_SIZE = "zookeeper.maxGetChildrenResponseCacheSize";
    private BlueThrottle connThrottle = new BlueThrottle();
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Internally the throttler has a BlockingQueue so once the throttler is created and started, it is thread-safe")
    private RequestThrottler requestThrottler;
    public static final String SNAP_COUNT = "zookeeper.snapCount";
    private volatile int largeRequestMaxBytes = 0x6400000;
    private volatile int largeRequestThreshold = -1;
    private final AtomicInteger currentLargeRequestBytes = new AtomicInteger(0);
    private AuthenticationHelper authHelper;

    public static boolean isEnableEagerACLCheck() {
        return enableEagerACLCheck;
    }

    public static void setEnableEagerACLCheck(boolean enabled) {
        enableEagerACLCheck = enabled;
        LOG.info("Update {} to {}", (Object)ENABLE_EAGER_ACL_CHECK, (Object)enabled);
    }

    public static boolean isCloseSessionTxnEnabled() {
        return closeSessionTxnEnabled;
    }

    public static void setCloseSessionTxnEnabled(boolean enabled) {
        closeSessionTxnEnabled = enabled;
        LOG.info("Update {} to {}", (Object)CLOSE_SESSION_TXN_ENABLED, (Object)closeSessionTxnEnabled);
    }

    void removeCnxn(ServerCnxn cnxn) {
        this.zkDb.removeCnxn(cnxn);
    }

    public ZooKeeperServer() {
        this.listener = new ZooKeeperServerListenerImpl(this);
        this.serverStats = new ServerStats(this);
        this.requestPathMetricsCollector = new RequestPathMetricsCollector();
        this.authHelper = new AuthenticationHelper();
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, int clientPortListenBacklog, ZKDatabase zkDb, String initialConfig) {
        this(txnLogFactory, tickTime, minSessionTimeout, maxSessionTimeout, clientPortListenBacklog, zkDb, initialConfig, QuorumPeerConfig.isReconfigEnabled());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, int clientPortListenBacklog, ZKDatabase zkDb, String initialConfig, boolean reconfigEnabled) {
        this.serverStats = new ServerStats(this);
        this.txnLogFactory = txnLogFactory;
        this.txnLogFactory.setServerStats(this.serverStats);
        this.zkDb = zkDb;
        this.tickTime = tickTime;
        this.setMinSessionTimeout(minSessionTimeout);
        this.setMaxSessionTimeout(maxSessionTimeout);
        this.listenBacklog = clientPortListenBacklog;
        this.reconfigEnabled = reconfigEnabled;
        this.listener = new ZooKeeperServerListenerImpl(this);
        this.readResponseCache = new ResponseCache(Integer.getInteger(GET_DATA_RESPONSE_CACHE_SIZE, 400), "getData");
        this.getChildrenResponseCache = new ResponseCache(Integer.getInteger(GET_CHILDREN_RESPONSE_CACHE_SIZE, 400), "getChildren");
        this.initialConfig = initialConfig;
        this.requestPathMetricsCollector = new RequestPathMetricsCollector();
        this.initLargeRequestThrottlingSettings();
        this.authHelper = new AuthenticationHelper();
        LOG.info("Created server with tickTime {} ms minSessionTimeout {} ms maxSessionTimeout {} ms clientPortListenBacklog {} datadir {} snapdir {}", new Object[]{tickTime, this.getMinSessionTimeout(), this.getMaxSessionTimeout(), this.getClientPortListenBacklog(), txnLogFactory.getDataDir(), txnLogFactory.getSnapDir()});
    }

    public String getInitialConfig() {
        return this.initialConfig;
    }

    public ZooKeeperServer(JvmPauseMonitor jvmPauseMonitor, FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, int clientPortListenBacklog, ZKDatabase zkDb, String initialConfig) {
        this(txnLogFactory, tickTime, minSessionTimeout, maxSessionTimeout, clientPortListenBacklog, zkDb, initialConfig, QuorumPeerConfig.isReconfigEnabled());
        this.jvmPauseMonitor = jvmPauseMonitor;
        if (jvmPauseMonitor != null) {
            LOG.info("Added JvmPauseMonitor to server");
        }
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, String initialConfig) {
        this(txnLogFactory, tickTime, -1, -1, -1, new ZKDatabase(txnLogFactory), initialConfig, QuorumPeerConfig.isReconfigEnabled());
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public RequestPathMetricsCollector getRequestPathMetricsCollector() {
        return this.requestPathMetricsCollector;
    }

    public BlueThrottle connThrottle() {
        return this.connThrottle;
    }

    public void dumpConf(PrintWriter pwriter) {
        pwriter.print("clientPort=");
        pwriter.println(this.getClientPort());
        pwriter.print("secureClientPort=");
        pwriter.println(this.getSecureClientPort());
        pwriter.print("dataDir=");
        pwriter.println(this.zkDb.snapLog.getSnapDir().getAbsolutePath());
        pwriter.print("dataDirSize=");
        pwriter.println(this.getDataDirSize());
        pwriter.print("dataLogDir=");
        pwriter.println(this.zkDb.snapLog.getDataDir().getAbsolutePath());
        pwriter.print("dataLogSize=");
        pwriter.println(this.getLogDirSize());
        pwriter.print("tickTime=");
        pwriter.println(this.getTickTime());
        pwriter.print("maxClientCnxns=");
        pwriter.println(this.getMaxClientCnxnsPerHost());
        pwriter.print("minSessionTimeout=");
        pwriter.println(this.getMinSessionTimeout());
        pwriter.print("maxSessionTimeout=");
        pwriter.println(this.getMaxSessionTimeout());
        pwriter.print("clientPortListenBacklog=");
        pwriter.println(this.getClientPortListenBacklog());
        pwriter.print("serverId=");
        pwriter.println(this.getServerId());
    }

    public ZooKeeperServerConf getConf() {
        return new ZooKeeperServerConf(this.getClientPort(), this.zkDb.snapLog.getSnapDir().getAbsolutePath(), this.zkDb.snapLog.getDataDir().getAbsolutePath(), this.getTickTime(), this.getMaxClientCnxnsPerHost(), this.getMinSessionTimeout(), this.getMaxSessionTimeout(), this.getServerId(), this.getClientPortListenBacklog());
    }

    public ZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
        this(new FileTxnSnapLog(snapDir, logDir), tickTime, "");
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory) throws IOException {
        this(txnLogFactory, 3000, -1, -1, -1, new ZKDatabase(txnLogFactory), "", QuorumPeerConfig.isReconfigEnabled());
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkDb = zkDb;
    }

    public void loadData() throws IOException, InterruptedException {
        if (this.zkDb.isInitialized()) {
            this.setZxid(this.zkDb.getDataTreeLastProcessedZxid());
        } else {
            this.setZxid(this.zkDb.loadDataBase());
        }
        this.zkDb.getSessions().stream().filter(session -> this.zkDb.getSessionWithTimeOuts().get(session) == null).forEach(session -> this.killSession((long)session, this.zkDb.getDataTreeLastProcessedZxid()));
        this.takeSnapshot();
    }

    public void takeSnapshot() {
        this.takeSnapshot(false);
    }

    public void takeSnapshot(boolean syncSnap) {
        long start = Time.currentElapsedTime();
        try {
            this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts(), syncSnap);
        }
        catch (IOException e) {
            LOG.error("Severe unrecoverable error, exiting", (Throwable)e);
            ServiceUtils.requestSystemExit(ExitCode.TXNLOG_ERROR_TAKING_SNAPSHOT.getValue());
        }
        long elapsed = Time.currentElapsedTime() - start;
        LOG.info("Snapshot taken in {} ms", (Object)elapsed);
        ServerMetrics.getMetrics().SNAPSHOT_TIME.add(elapsed);
    }

    public boolean shouldForceWriteInitialSnapshotAfterLeaderElection() {
        return this.txnLogFactory.shouldForceWriteInitialSnapshotAfterLeaderElection();
    }

    @Override
    public long getDataDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File path = this.zkDb.snapLog.getDataDir();
        return this.getDirSize(path);
    }

    @Override
    public long getLogDirSize() {
        if (this.zkDb == null) {
            return 0L;
        }
        File path = this.zkDb.snapLog.getSnapDir();
        return this.getDirSize(path);
    }

    private long getDirSize(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    size += this.getDirSize(f);
                }
            }
        } else {
            size = file.length();
        }
        return size;
    }

    public long getZxid() {
        return this.hzxid.get();
    }

    public SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    long getNextZxid() {
        return this.hzxid.incrementAndGet();
    }

    public void setZxid(long zxid) {
        this.hzxid.set(zxid);
    }

    private void close(long sessionId) {
        Request si = new Request(null, sessionId, 0, -11, null, null);
        this.submitRequest(si);
    }

    public void closeSession(long sessionId) {
        LOG.info("Closing session 0x{}", (Object)Long.toHexString(sessionId));
        this.close(sessionId);
    }

    protected void killSession(long sessionId, long zxid) {
        this.zkDb.killSession(sessionId, zxid);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long sessionId = session.getSessionId();
        LOG.info("Expiring session 0x{}, timeout of {}ms exceeded", (Object)Long.toHexString(sessionId), (Object)session.getTimeout());
        this.close(sessionId);
    }

    public void expire(long sessionId) {
        LOG.info("forcibly expiring session 0x{}", (Object)Long.toHexString(sessionId));
        this.close(sessionId);
    }

    void touch(ServerCnxn cnxn) throws MissingSessionException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(id) + " exists, probably expired and removed");
        }
    }

    protected void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    public void startdata() throws IOException, InterruptedException {
        if (this.zkDb == null) {
            this.zkDb = new ZKDatabase(this.txnLogFactory);
        }
        if (!this.zkDb.isInitialized()) {
            this.loadData();
        }
    }

    public synchronized void startup() {
        this.startupWithServerState(State.RUNNING);
    }

    public synchronized void startupWithoutServing() {
        this.startupWithServerState(State.INITIAL);
    }

    public synchronized void startServing() {
        this.setState(State.RUNNING);
        this.notifyAll();
    }

    private void startupWithServerState(State state) {
        if (this.sessionTracker == null) {
            this.createSessionTracker();
        }
        this.startSessionTracker();
        this.setupRequestProcessors();
        this.startRequestThrottler();
        this.registerJMX();
        this.startJvmPauseMonitor();
        this.registerMetrics();
        this.setState(state);
        this.requestPathMetricsCollector.start();
        this.localSessionEnabled = this.sessionTracker.isLocalSessionsEnabled();
        this.notifyAll();
    }

    protected void startJvmPauseMonitor() {
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStart();
        }
    }

    protected void startRequestThrottler() {
        this.requestThrottler = this.createRequestThrottler();
        this.requestThrottler.start();
    }

    protected RequestThrottler createRequestThrottler() {
        return new RequestThrottler(this);
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        syncProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public ZooKeeperServerListener getZooKeeperServerListener() {
        return this.listener;
    }

    public void setCreateSessionTrackerServerId(int newId) {
        this.createSessionTrackerServerId = newId;
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, (long)this.createSessionTrackerServerId, this.getZooKeeperServerListener());
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    protected void setState(State state) {
        this.state = state;
        if (this.zkShutdownHandler != null) {
            this.zkShutdownHandler.handle(state);
        } else {
            LOG.debug("ZKShutdownHandler is not registered, so ZooKeeper server won't take any action on ERROR or SHUTDOWN server state changes");
        }
    }

    protected boolean canShutdown() {
        return this.state == State.RUNNING || this.state == State.ERROR;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean fullyShutDown) {
        if (!this.canShutdown()) {
            if (fullyShutDown && this.zkDb != null) {
                this.zkDb.clear();
            }
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        LOG.info("shutting down");
        this.setState(State.SHUTDOWN);
        this.unregisterMetrics();
        if (this.requestThrottler != null) {
            this.requestThrottler.shutdown();
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.serviceStop();
        }
        if (this.zkDb != null) {
            if (fullyShutDown) {
                this.zkDb.clear();
            } else {
                try {
                    this.zkDb.fastForwardDataBase();
                }
                catch (IOException e) {
                    LOG.error("Error updating DB", (Throwable)e);
                    this.zkDb.clear();
                }
            }
        }
        this.requestPathMetricsCollector.shutdown();
        this.unregisterJMX();
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public void incInProcess() {
        this.requestsInProcess.incrementAndGet();
    }

    public void decInProcess() {
        this.requestsInProcess.decrementAndGet();
        if (this.requestThrottler != null) {
            this.requestThrottler.throttleWake();
        }
    }

    public int getInProcess() {
        return this.requestsInProcess.get();
    }

    public int getInflight() {
        return this.requestThrottleInflight();
    }

    private int requestThrottleInflight() {
        if (this.requestThrottler != null) {
            return this.requestThrottler.getInflight();
        }
        return 0;
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    protected boolean checkPasswd(long sessionId, byte[] passwd) {
        return sessionId != 0L && Arrays.equals(passwd, this.generatePasswd(sessionId));
    }

    long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) {
        if (passwd == null) {
            passwd = new byte[]{};
        }
        long sessionId = this.sessionTracker.createSession(timeout);
        Random r = new Random(sessionId ^ 0xB3415C00L);
        r.nextBytes(passwd);
        ByteBuffer to = ByteBuffer.allocate(4);
        to.putInt(timeout);
        cnxn.setSessionId(sessionId);
        Request si = new Request(cnxn, sessionId, 0, -10, to, null);
        this.submitRequest(si);
        return sessionId;
    }

    public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(id, owner);
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        boolean rc = this.sessionTracker.touchSession(sessionId, sessionTimeout);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + rc);
        }
        this.finishSessionInit(cnxn, rc);
    }

    public void reopenSession(ServerCnxn cnxn, long sessionId, byte[] passwd, int sessionTimeout) throws IOException {
        if (this.checkPasswd(sessionId, passwd)) {
            this.revalidateSession(cnxn, sessionId, sessionTimeout);
        } else {
            LOG.warn("Incorrect password from {} for session 0x{}", (Object)cnxn.getRemoteSocketAddress(), (Object)Long.toHexString(sessionId));
            this.finishSessionInit(cnxn, false);
        }
    }

    public void finishSessionInit(ServerCnxn cnxn, boolean valid) {
        try {
            if (valid) {
                if (this.serverCnxnFactory != null && this.serverCnxnFactory.cnxns.contains(cnxn)) {
                    this.serverCnxnFactory.registerConnection(cnxn);
                } else if (this.secureServerCnxnFactory != null && this.secureServerCnxnFactory.cnxns.contains(cnxn)) {
                    this.secureServerCnxnFactory.registerConnection(cnxn);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? cnxn.getSessionTimeout() : 0, valid ? cnxn.getSessionId() : 0L, valid ? this.generatePasswd(cnxn.getSessionId()) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            if (!cnxn.isOldClient) {
                bos.writeBool(this instanceof ReadOnlyZooKeeperServer, "readOnly");
            }
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            cnxn.sendBuffer(bb);
            if (valid) {
                LOG.debug("Established session 0x{} with negotiated timeout {} for client {}", new Object[]{Long.toHexString(cnxn.getSessionId()), cnxn.getSessionTimeout(), cnxn.getRemoteSocketAddress()});
                cnxn.enableRecv();
            } else {
                LOG.info("Invalid session 0x{} for client {}, probably expired", (Object)Long.toHexString(cnxn.getSessionId()), (Object)cnxn.getRemoteSocketAddress());
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while establishing session, closing", (Throwable)e);
            cnxn.close(ServerCnxn.DisconnectReason.IO_EXCEPTION_IN_SESSION_INIT);
        }
    }

    public void closeSession(ServerCnxn cnxn, RequestHeader requestHeader) {
        this.closeSession(cnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    protected void setLocalSessionFlag(Request si) {
    }

    public void submitRequest(Request si) {
        this.enqueueRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRequest(Request si) {
        if (this.requestThrottler == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected interruption", (Throwable)e);
                }
                if (this.requestThrottler == null) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        this.requestThrottler.submitRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequestNow(Request si) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (this.state == State.INITIAL) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected interruption", (Throwable)e);
                }
                if (this.firstProcessor == null || this.state != State.RUNNING) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(si.cnxn);
            boolean validpacket = Request.isValid(si.type);
            if (validpacket) {
                this.setLocalSessionFlag(si);
                this.firstProcessor.processRequest(si);
                if (si.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.warn("Received packet at server of unknown type {}", (Object)si.type);
                this.requestFinished(si);
                new UnimplementedRequestProcessor().processRequest(si);
            }
        }
        catch (MissingSessionException e) {
            LOG.debug("Dropping request.", (Throwable)e);
            this.requestFinished(si);
        }
        catch (RequestProcessor.RequestProcessorException e) {
            LOG.error("Unable to process request", (Throwable)e);
            this.requestFinished(si);
        }
    }

    public static int getSnapCount() {
        int snapCount = Integer.getInteger(SNAP_COUNT, 100000);
        if (snapCount < 2) {
            LOG.warn("SnapCount should be 2 or more. Now, snapCount is reset to 2");
            snapCount = 2;
        }
        return snapCount;
    }

    public int getGlobalOutstandingLimit() {
        return Integer.getInteger(GLOBAL_OUTSTANDING_LIMIT, 1000);
    }

    public static long getSnapSizeInBytes() {
        long size = Long.getLong("zookeeper.snapSizeLimitInKb", 0x400000L);
        if (size <= 0L) {
            LOG.info("zookeeper.snapSizeLimitInKb set to a non-positive value {}; disabling feature", (Object)size);
        }
        return size * 1024L;
    }

    public void setServerCnxnFactory(ServerCnxnFactory factory) {
        this.serverCnxnFactory = factory;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    public ServerCnxnFactory getSecureServerCnxnFactory() {
        return this.secureServerCnxnFactory;
    }

    public void setSecureServerCnxnFactory(ServerCnxnFactory factory) {
        this.secureServerCnxnFactory = factory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    @Override
    public int getNumAliveConnections() {
        int numAliveConnections = 0;
        if (this.serverCnxnFactory != null) {
            numAliveConnections += this.serverCnxnFactory.getNumAliveConnections();
        }
        if (this.secureServerCnxnFactory != null) {
            numAliveConnections += this.secureServerCnxnFactory.getNumAliveConnections();
        }
        return numAliveConnections;
    }

    public void truncateLog(long zxid) throws IOException {
        this.zkDb.truncateLog(zxid);
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to {} ms", (Object)tickTime);
        this.tickTime = tickTime;
    }

    public static int getThrottledOpWaitTime() {
        return throttledOpWaitTime;
    }

    public static void setThrottledOpWaitTime(int time) {
        LOG.info("throttledOpWaitTime set to {} ms", (Object)time);
        throttledOpWaitTime = time;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min) {
        this.minSessionTimeout = min == -1 ? this.tickTime * 2 : min;
        LOG.info("minSessionTimeout set to {} ms", (Object)this.minSessionTimeout);
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max) {
        this.maxSessionTimeout = max == -1 ? this.tickTime * 20 : max;
        LOG.info("maxSessionTimeout set to {} ms", (Object)this.maxSessionTimeout);
    }

    public int getClientPortListenBacklog() {
        return this.listenBacklog;
    }

    public void setClientPortListenBacklog(int backlog) {
        this.listenBacklog = backlog;
        LOG.info("clientPortListenBacklog set to {}", (Object)backlog);
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.getLocalPort() : -1;
    }

    public int getSecureClientPort() {
        return this.secureServerCnxnFactory != null ? this.secureServerCnxnFactory.getLocalPort() : -1;
    }

    public int getMaxClientCnxnsPerHost() {
        if (this.serverCnxnFactory != null) {
            return this.serverCnxnFactory.getMaxClientCnxnsPerHost();
        }
        if (this.secureServerCnxnFactory != null) {
            return this.secureServerCnxnFactory.getMaxClientCnxnsPerHost();
        }
        return -1;
    }

    public void setTxnLogFactory(FileTxnSnapLog txnLog) {
        this.txnLogFactory = txnLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    public long getTxnLogElapsedSyncTime() {
        return this.txnLogFactory.getTxnLogElapsedSyncTime();
    }

    @Override
    public String getState() {
        return "standalone";
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.zkDb.dumpEphemerals(pwriter);
    }

    public Map<Long, Set<String>> getEphemerals() {
        return this.zkDb.getEphemerals();
    }

    public double getConnectionDropChance() {
        return this.connThrottle.getDropChance();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="the value won't change after startup")
    public void processConnectRequest(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException, ClientCnxnLimitException {
        int maxSessionTimeout;
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        LOG.debug("Session establishment request from client {} client's lastZxid is 0x{}", (Object)cnxn.getRemoteSocketAddress(), (Object)Long.toHexString(connReq.getLastZxidSeen()));
        long sessionId = connReq.getSessionId();
        int tokensNeeded = 1;
        if (this.connThrottle.isConnectionWeightEnabled()) {
            tokensNeeded = sessionId == 0L ? (this.localSessionEnabled ? this.connThrottle.getRequiredTokensForLocal() : this.connThrottle.getRequiredTokensForGlobal()) : this.connThrottle.getRequiredTokensForRenew();
        }
        if (!this.connThrottle.checkLimit(tokensNeeded)) {
            throw new ClientCnxnLimitException();
        }
        ServerMetrics.getMetrics().CONNECTION_TOKEN_DEFICIT.add(this.connThrottle.getDeficit());
        ServerMetrics.getMetrics().CONNECTION_REQUEST_COUNT.add(1L);
        boolean readOnly = false;
        try {
            readOnly = bia.readBool("readOnly");
            cnxn.isOldClient = false;
        }
        catch (IOException e) {
            LOG.warn("Connection request from old client {}; will be dropped if server is in r-o mode", (Object)cnxn.getRemoteSocketAddress());
        }
        if (!readOnly && this instanceof ReadOnlyZooKeeperServer) {
            String msg = "Refusing session request for not-read-only client " + cnxn.getRemoteSocketAddress();
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg, ServerCnxn.DisconnectReason.NOT_READ_ONLY_CLIENT);
        }
        if (connReq.getLastZxidSeen() > this.zkDb.dataTree.lastProcessedZxid) {
            String msg = "Refusing session request for client " + cnxn.getRemoteSocketAddress() + " as it has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.getZKDatabase().getDataTreeLastProcessedZxid()) + " client must try another server";
            LOG.info(msg);
            throw new ServerCnxn.CloseRequestException(msg, ServerCnxn.DisconnectReason.CLIENT_ZXID_AHEAD);
        }
        int sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        int minSessionTimeout = this.getMinSessionTimeout();
        if (sessionTimeout < minSessionTimeout) {
            sessionTimeout = minSessionTimeout;
        }
        if (sessionTimeout > (maxSessionTimeout = this.getMaxSessionTimeout())) {
            sessionTimeout = maxSessionTimeout;
        }
        cnxn.setSessionTimeout(sessionTimeout);
        cnxn.disableRecv();
        if (sessionId == 0L) {
            long id = this.createSession(cnxn, passwd, sessionTimeout);
            LOG.debug("Client attempting to establish new session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", new Object[]{Long.toHexString(id), Long.toHexString(connReq.getLastZxidSeen()), connReq.getTimeOut(), cnxn.getRemoteSocketAddress()});
        } else {
            this.validateSession(cnxn, sessionId);
            LOG.debug("Client attempting to renew session: session = 0x{}, zxid = 0x{}, timeout = {}, address = {}", new Object[]{Long.toHexString(sessionId), Long.toHexString(connReq.getLastZxidSeen()), connReq.getTimeOut(), cnxn.getRemoteSocketAddress()});
            if (this.serverCnxnFactory != null) {
                this.serverCnxnFactory.closeSession(sessionId, ServerCnxn.DisconnectReason.CLIENT_RECONNECT);
            }
            if (this.secureServerCnxnFactory != null) {
                this.secureServerCnxnFactory.closeSession(sessionId, ServerCnxn.DisconnectReason.CLIENT_RECONNECT);
            }
            cnxn.setSessionId(sessionId);
            this.reopenSession(cnxn, sessionId, passwd, sessionTimeout);
            ServerMetrics.getMetrics().CONNECTION_REVALIDATE_COUNT.add(1L);
        }
    }

    protected void validateSession(ServerCnxn cnxn, long sessionId) throws IOException {
    }

    public boolean shouldThrottle(long outStandingCount) {
        int globalOutstandingLimit = this.getGlobalOutstandingLimit();
        if (globalOutstandingLimit < this.getInflight() || globalOutstandingLimit < this.getInProcess()) {
            return outStandingCount > 0L;
        }
        return false;
    }

    long getFlushDelay() {
        return flushDelay;
    }

    static void setFlushDelay(long delay) {
        LOG.info("{} = {} ms", (Object)FLUSH_DELAY, (Object)delay);
        flushDelay = delay;
    }

    long getMaxWriteQueuePollTime() {
        return maxWriteQueuePollTime;
    }

    static void setMaxWriteQueuePollTime(long maxTime) {
        LOG.info("{} = {} ms", (Object)MAX_WRITE_QUEUE_POLL_SIZE, (Object)maxTime);
        maxWriteQueuePollTime = maxTime;
    }

    int getMaxBatchSize() {
        return maxBatchSize;
    }

    static void setMaxBatchSize(int size) {
        LOG.info("{}={}", (Object)MAX_BATCH_SIZE, (Object)size);
        maxBatchSize = size;
    }

    private void initLargeRequestThrottlingSettings() {
        this.setLargeRequestMaxBytes(Integer.getInteger("zookeeper.largeRequestMaxBytes", this.largeRequestMaxBytes));
        this.setLargeRequestThreshold(Integer.getInteger("zookeeper.largeRequestThreshold", -1));
    }

    public int getLargeRequestMaxBytes() {
        return this.largeRequestMaxBytes;
    }

    public void setLargeRequestMaxBytes(int bytes) {
        if (bytes <= 0) {
            LOG.warn("Invalid max bytes for all large requests {}. It should be a positive number.", (Object)bytes);
            LOG.warn("Will not change the setting. The max bytes stay at {}", (Object)this.largeRequestMaxBytes);
        } else {
            this.largeRequestMaxBytes = bytes;
            LOG.info("The max bytes for all large requests are set to {}", (Object)this.largeRequestMaxBytes);
        }
    }

    public int getLargeRequestThreshold() {
        return this.largeRequestThreshold;
    }

    public void setLargeRequestThreshold(int threshold) {
        if (threshold == 0 || threshold < -1) {
            LOG.warn("Invalid large request threshold {}. It should be -1 or positive. Setting to -1 ", (Object)threshold);
            this.largeRequestThreshold = -1;
        } else {
            this.largeRequestThreshold = threshold;
            LOG.info("The large request threshold is set to {}", (Object)this.largeRequestThreshold);
        }
    }

    public int getLargeRequestBytes() {
        return this.currentLargeRequestBytes.get();
    }

    private boolean isLargeRequest(int length) {
        if (this.largeRequestThreshold == -1) {
            return false;
        }
        return length > this.largeRequestThreshold;
    }

    public boolean checkRequestSizeWhenReceivingMessage(int length) throws IOException {
        if (!this.isLargeRequest(length)) {
            return true;
        }
        if (this.currentLargeRequestBytes.get() + length <= this.largeRequestMaxBytes) {
            return true;
        }
        ServerMetrics.getMetrics().LARGE_REQUESTS_REJECTED.add(1L);
        throw new IOException("Rejecting large request");
    }

    private boolean checkRequestSizeWhenMessageReceived(int length) throws IOException {
        if (!this.isLargeRequest(length)) {
            return true;
        }
        int bytes = this.currentLargeRequestBytes.addAndGet(length);
        if (bytes > this.largeRequestMaxBytes) {
            this.currentLargeRequestBytes.addAndGet(-length);
            ServerMetrics.getMetrics().LARGE_REQUESTS_REJECTED.add(1L);
            throw new IOException("Rejecting large request");
        }
        return true;
    }

    public void requestFinished(Request request) {
        int largeRequestLength = request.getLargeRequestSize();
        if (largeRequestLength != -1) {
            this.currentLargeRequestBytes.addAndGet(-largeRequestLength);
        }
    }

    public void processPacket(ServerCnxn cnxn, ByteBuffer incomingBuffer) throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        cnxn.incrOutstandingAndCheckThrottle(h);
        incomingBuffer = incomingBuffer.slice();
        if (h.getType() == 100) {
            LOG.info("got auth packet {}", (Object)cnxn.getRemoteSocketAddress());
            AuthPacket authPacket = new AuthPacket();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            ServerAuthenticationProvider ap = ProviderRegistry.getServerProvider(scheme);
            KeeperException.Code authReturn = KeeperException.Code.AUTHFAILED;
            if (ap != null) {
                try {
                    authReturn = ap.handleAuthentication(new ServerAuthenticationProvider.ServerObjs(this, cnxn), authPacket.getAuth());
                }
                catch (RuntimeException e) {
                    LOG.warn("Caught runtime exception from AuthenticationProvider: {}", (Object)scheme, (Object)e);
                    authReturn = KeeperException.Code.AUTHFAILED;
                }
            }
            if (authReturn == KeeperException.Code.OK) {
                LOG.info("Session 0x{}: auth success for scheme {} and address {}", new Object[]{Long.toHexString(cnxn.getSessionId()), scheme, cnxn.getRemoteSocketAddress()});
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
                cnxn.sendResponse(rh, null, null);
            } else {
                if (ap == null) {
                    LOG.warn("No authentication provider for scheme: {} has {}", (Object)scheme, (Object)ProviderRegistry.listProviders());
                } else {
                    LOG.warn("Authentication failed for scheme: {}", (Object)scheme);
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                cnxn.sendResponse(rh, null, null);
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
                cnxn.disableRecv();
            }
            return;
        }
        if (h.getType() == 102) {
            this.processSasl(incomingBuffer, cnxn, h);
        } else {
            if (!this.authHelper.enforceAuthentication(cnxn, h.getXid())) {
                return;
            }
            Request si = new Request(cnxn, cnxn.getSessionId(), h.getXid(), h.getType(), incomingBuffer, cnxn.getAuthInfo());
            int length = incomingBuffer.limit();
            if (this.isLargeRequest(length)) {
                this.checkRequestSizeWhenMessageReceived(length);
                si.setLargeRequestSize(length);
            }
            si.setOwner(ServerCnxn.me);
            this.submitRequest(si);
        }
    }

    private static boolean isSaslSuperUser(String id) {
        if (id == null || id.isEmpty()) {
            return false;
        }
        Properties properties = System.getProperties();
        int prefixLen = SASL_SUPER_USER.length();
        for (String k : properties.stringPropertyNames()) {
            String value;
            if (!k.startsWith(SASL_SUPER_USER) || k.length() != prefixLen && k.charAt(prefixLen) != '.' || (value = properties.getProperty(k)) == null || !value.equals(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldAllowSaslFailedClientsConnect() {
        return Boolean.getBoolean(ALLOW_SASL_FAILED_CLIENTS);
    }

    private void processSasl(ByteBuffer incomingBuffer, ServerCnxn cnxn, RequestHeader requestHeader) throws IOException {
        byte[] responseToken;
        block10: {
            LOG.debug("Responding to client SASL token.");
            GetSASLRequest clientTokenRecord = new GetSASLRequest();
            ByteBufferInputStream.byteBuffer2Record(incomingBuffer, clientTokenRecord);
            byte[] clientToken = clientTokenRecord.getToken();
            LOG.debug("Size of client SASL token: {}", (Object)clientToken.length);
            responseToken = null;
            try {
                ZooKeeperSaslServer saslServer = cnxn.zooKeeperSaslServer;
                try {
                    responseToken = saslServer.evaluateResponse(clientToken);
                    if (saslServer.isComplete()) {
                        String authorizationID = saslServer.getAuthorizationID();
                        LOG.info("Session 0x{}: adding SASL authorization for authorizationID: {}", (Object)Long.toHexString(cnxn.getSessionId()), (Object)authorizationID);
                        cnxn.addAuthInfo(new Id("sasl", authorizationID));
                        if (ZooKeeperServer.isSaslSuperUser(authorizationID)) {
                            cnxn.addAuthInfo(new Id("super", ""));
                            LOG.info("Session 0x{}: Authenticated Id '{}' as super user", (Object)Long.toHexString(cnxn.getSessionId()), (Object)authorizationID);
                        }
                    }
                }
                catch (SaslException e) {
                    int error;
                    LOG.warn("Client {} failed to SASL authenticate: {}", (Object)cnxn.getRemoteSocketAddress(), (Object)e);
                    if (ZooKeeperServer.shouldAllowSaslFailedClientsConnect() && !this.authHelper.isSaslAuthRequired()) {
                        LOG.warn("Maintaining client connection despite SASL authentication failure.");
                        break block10;
                    }
                    if (this.authHelper.isSaslAuthRequired()) {
                        LOG.warn("Closing client connection due to server requires client SASL authenticaiton,but client SASL authentication has failed, or client is not configured with SASL authentication.");
                        error = KeeperException.Code.SESSIONCLOSEDREQUIRESASLAUTH.intValue();
                    } else {
                        LOG.warn("Closing client connection due to SASL authentication failure.");
                        error = KeeperException.Code.AUTHFAILED.intValue();
                    }
                    ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, error);
                    cnxn.sendResponse(replyHeader, new SetSASLResponse(null), "response");
                    cnxn.sendCloseSession();
                    cnxn.disableRecv();
                    return;
                }
            }
            catch (NullPointerException e) {
                LOG.error("cnxn.saslServer is null: cnxn object did not initialize its saslServer properly.");
            }
        }
        if (responseToken != null) {
            LOG.debug("Size of server SASL response: {}", (Object)responseToken.length);
        }
        ReplyHeader replyHeader = new ReplyHeader(requestHeader.getXid(), 0L, KeeperException.Code.OK.intValue());
        SetSASLResponse record = new SetSASLResponse(responseToken);
        cnxn.sendResponse(replyHeader, record, "response");
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        this.processTxnForSessionEvents(null, hdr, txn);
        return this.processTxnInDB(hdr, txn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTree.ProcessTxnResult processTxn(Request request) {
        TxnHeader hdr = request.getHdr();
        this.processTxnForSessionEvents(request, hdr, request.getTxn());
        boolean writeRequest = hdr != null;
        boolean quorumRequest = request.isQuorum();
        if (!writeRequest && !quorumRequest) {
            return new DataTree.ProcessTxnResult();
        }
        Deque<ChangeRecord> deque = this.outstandingChanges;
        synchronized (deque) {
            DataTree.ProcessTxnResult rc = this.processTxnInDB(hdr, request.getTxn(), request.getTxnDigest());
            if (writeRequest) {
                long zxid = hdr.getZxid();
                while (!this.outstandingChanges.isEmpty() && this.outstandingChanges.peek().zxid <= zxid) {
                    ChangeRecord cr = this.outstandingChanges.remove();
                    ServerMetrics.getMetrics().OUTSTANDING_CHANGES_REMOVED.add(1L);
                    if (cr.zxid < zxid) {
                        LOG.warn("Zxid outstanding 0x{} is less than current 0x{}", (Object)Long.toHexString(cr.zxid), (Object)Long.toHexString(zxid));
                    }
                    if (this.outstandingChangesForPath.get(cr.path) != cr) continue;
                    this.outstandingChangesForPath.remove(cr.path);
                }
            }
            if (quorumRequest) {
                this.getZKDatabase().addCommittedProposal(request);
            }
            return rc;
        }
    }

    private void processTxnForSessionEvents(Request request, TxnHeader hdr, Record txn) {
        long sessionId;
        int opCode = request == null ? hdr.getType() : request.type;
        long l = sessionId = request == null ? hdr.getClientId() : request.sessionId;
        if (opCode == -10) {
            if (hdr != null && txn instanceof CreateSessionTxn) {
                CreateSessionTxn cst = (CreateSessionTxn)txn;
                this.sessionTracker.commitSession(sessionId, cst.getTimeOut());
            } else if (request == null || !request.isLocalSession()) {
                LOG.warn("*****>>>>> Got {} {}", txn.getClass(), (Object)txn.toString());
            }
        } else if (opCode == -11) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    private DataTree.ProcessTxnResult processTxnInDB(TxnHeader hdr, Record txn, TxnDigest digest) {
        if (hdr == null) {
            return new DataTree.ProcessTxnResult();
        }
        return this.getZKDatabase().processTxn(hdr, txn, digest);
    }

    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return this.sessionTracker.getSessionExpiryMap();
    }

    void registerServerShutdownHandler(ZooKeeperServerShutdownHandler zkShutdownHandler) {
        this.zkShutdownHandler = zkShutdownHandler;
    }

    public boolean isResponseCachingEnabled() {
        return this.isResponseCachingEnabled;
    }

    public void setResponseCachingEnabled(boolean isEnabled) {
        this.isResponseCachingEnabled = isEnabled;
    }

    public ResponseCache getReadResponseCache() {
        return this.isResponseCachingEnabled ? this.readResponseCache : null;
    }

    public ResponseCache getGetChildrenResponseCache() {
        return this.isResponseCachingEnabled ? this.getChildrenResponseCache : null;
    }

    protected void registerMetrics() {
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        ZKDatabase zkdb = this.getZKDatabase();
        ServerStats stats = this.serverStats();
        rootContext.registerGauge("avg_latency", stats::getAvgLatency);
        rootContext.registerGauge("max_latency", stats::getMaxLatency);
        rootContext.registerGauge("min_latency", stats::getMinLatency);
        rootContext.registerGauge("packets_received", stats::getPacketsReceived);
        rootContext.registerGauge("packets_sent", stats::getPacketsSent);
        rootContext.registerGauge("num_alive_connections", stats::getNumAliveClientConnections);
        rootContext.registerGauge("outstanding_requests", stats::getOutstandingRequests);
        rootContext.registerGauge("uptime", stats::getUptime);
        rootContext.registerGauge("znode_count", zkdb::getNodeCount);
        rootContext.registerGauge("watch_count", zkdb.getDataTree()::getWatchCount);
        rootContext.registerGauge("ephemerals_count", zkdb.getDataTree()::getEphemeralsCount);
        rootContext.registerGauge("approximate_data_size", zkdb.getDataTree()::cachedApproximateDataSize);
        rootContext.registerGauge("global_sessions", zkdb::getSessionCount);
        rootContext.registerGauge("local_sessions", this.getSessionTracker()::getLocalSessionCount);
        OSMXBean osMbean = new OSMXBean();
        rootContext.registerGauge("open_file_descriptor_count", osMbean::getOpenFileDescriptorCount);
        rootContext.registerGauge("max_file_descriptor_count", osMbean::getMaxFileDescriptorCount);
        rootContext.registerGauge("connection_drop_probability", this::getConnectionDropChance);
        rootContext.registerGauge("last_client_response_size", stats.getClientResponseStats()::getLastBufferSize);
        rootContext.registerGauge("max_client_response_size", stats.getClientResponseStats()::getMaxBufferSize);
        rootContext.registerGauge("min_client_response_size", stats.getClientResponseStats()::getMinBufferSize);
        rootContext.registerGauge("outstanding_tls_handshake", this::getOutstandingHandshakeNum);
        rootContext.registerGauge("auth_failed_count", stats::getAuthFailedCount);
        rootContext.registerGauge("non_mtls_remote_conn_count", stats::getNonMTLSRemoteConnCount);
        rootContext.registerGauge("non_mtls_local_conn_count", stats::getNonMTLSLocalConnCount);
        rootContext.registerGaugeSet("quota_count_limit_per_namespace", () -> QuotaMetricsUtils.getQuotaCountLimit(this.zkDb.getDataTree()));
        rootContext.registerGaugeSet("quota_bytes_limit_per_namespace", () -> QuotaMetricsUtils.getQuotaBytesLimit(this.zkDb.getDataTree()));
        rootContext.registerGaugeSet("quota_count_usage_per_namespace", () -> QuotaMetricsUtils.getQuotaCountUsage(this.zkDb.getDataTree()));
        rootContext.registerGaugeSet("quota_bytes_usage_per_namespace", () -> QuotaMetricsUtils.getQuotaBytesUsage(this.zkDb.getDataTree()));
    }

    protected void unregisterMetrics() {
        MetricsContext rootContext = ServerMetrics.getMetrics().getMetricsProvider().getRootContext();
        rootContext.unregisterGauge("avg_latency");
        rootContext.unregisterGauge("max_latency");
        rootContext.unregisterGauge("min_latency");
        rootContext.unregisterGauge("packets_received");
        rootContext.unregisterGauge("packets_sent");
        rootContext.unregisterGauge("num_alive_connections");
        rootContext.unregisterGauge("outstanding_requests");
        rootContext.unregisterGauge("uptime");
        rootContext.unregisterGauge("znode_count");
        rootContext.unregisterGauge("watch_count");
        rootContext.unregisterGauge("ephemerals_count");
        rootContext.unregisterGauge("approximate_data_size");
        rootContext.unregisterGauge("global_sessions");
        rootContext.unregisterGauge("local_sessions");
        rootContext.unregisterGauge("open_file_descriptor_count");
        rootContext.unregisterGauge("max_file_descriptor_count");
        rootContext.unregisterGauge("connection_drop_probability");
        rootContext.unregisterGauge("last_client_response_size");
        rootContext.unregisterGauge("max_client_response_size");
        rootContext.unregisterGauge("min_client_response_size");
        rootContext.unregisterGauge("auth_failed_count");
        rootContext.unregisterGauge("non_mtls_remote_conn_count");
        rootContext.unregisterGauge("non_mtls_local_conn_count");
        rootContext.unregisterGaugeSet("quota_count_limit_per_namespace");
        rootContext.unregisterGaugeSet("quota_bytes_limit_per_namespace");
        rootContext.unregisterGaugeSet("quota_count_usage_per_namespace");
        rootContext.unregisterGaugeSet("quota_bytes_usage_per_namespace");
    }

    public void dumpMonitorValues(BiConsumer<String, Object> response) {
        ServerStats stats = this.serverStats();
        response.accept("version", Version.getFullVersion());
        response.accept("server_state", stats.getServerState());
    }

    public void checkACL(ServerCnxn cnxn, List<ACL> acl, int perm, List<Id> ids, String path, List<ACL> setAcls) throws KeeperException.NoAuthException {
        if (skipACL) {
            return;
        }
        LOG.debug("Permission requested: {} ", (Object)perm);
        LOG.debug("ACLs for node: {}", acl);
        LOG.debug("Client credentials: {}", ids);
        if (acl == null || acl.size() == 0) {
            return;
        }
        for (Id authId : ids) {
            if (!authId.getScheme().equals("super")) continue;
            return;
        }
        for (ACL a : acl) {
            Id id = a.getId();
            if ((a.getPerms() & perm) == 0) continue;
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                return;
            }
            ServerAuthenticationProvider ap = ProviderRegistry.getServerProvider(id.getScheme());
            if (ap == null) continue;
            for (Id authId : ids) {
                if (!authId.getScheme().equals(id.getScheme()) || !ap.matches(new ServerAuthenticationProvider.ServerObjs(this, cnxn), new ServerAuthenticationProvider.MatchValues(path, authId.getId(), id.getId(), perm, setAcls))) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    public void checkQuota(String path, byte[] lastData, byte[] data, int type) throws KeeperException.QuotaExceededException {
        if (!enforceQuota) {
            return;
        }
        long dataBytes = data == null ? 0L : (long)data.length;
        ZKDatabase zkDatabase = this.getZKDatabase();
        String lastPrefix = zkDatabase.getDataTree().getMaxPrefixWithQuota(path);
        if (StringUtils.isEmpty(lastPrefix)) {
            return;
        }
        String namespace = PathUtils.getTopNamespace(path);
        switch (type) {
            case 1: {
                this.checkQuota(lastPrefix, dataBytes, 1L, namespace);
                break;
            }
            case 5: {
                this.checkQuota(lastPrefix, dataBytes - (long)(lastData == null ? 0 : lastData.length), 0L, namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OpCode for checkQuota: " + type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQuota(String lastPrefix, long bytesDiff, long countDiff, String namespace) throws KeeperException.QuotaExceededException {
        String msg;
        StatsTrack currentStats;
        boolean checkByteQuota;
        StatsTrack limitStats;
        LOG.debug("checkQuota: lastPrefix={}, bytesDiff={}, countDiff={}", new Object[]{lastPrefix, bytesDiff, countDiff});
        String limitNode = Quotas.limitPath(lastPrefix);
        DataNode node = this.getZKDatabase().getNode(limitNode);
        if (node == null) {
            LOG.error("Missing limit node for quota {}", (Object)limitNode);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            limitStats = new StatsTrack(node.data);
        }
        boolean checkCountQuota = countDiff != 0L && (limitStats.getCount() > -1L || limitStats.getCountHardLimit() > -1L);
        boolean bl = checkByteQuota = bytesDiff != 0L && (limitStats.getBytes() > -1L || limitStats.getByteHardLimit() > -1L);
        if (!checkCountQuota && !checkByteQuota) {
            return;
        }
        String statNode = Quotas.statPath(lastPrefix);
        node = this.getZKDatabase().getNode(statNode);
        if (node == null) {
            LOG.error("Missing node for stat {}", (Object)statNode);
            return;
        }
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            currentStats = new StatsTrack(node.data);
        }
        if (checkCountQuota) {
            long countLimit;
            long newCount = currentStats.getCount() + countDiff;
            boolean isCountHardLimit = limitStats.getCountHardLimit() > -1L;
            long l = countLimit = isCountHardLimit ? limitStats.getCountHardLimit() : limitStats.getCount();
            if (newCount > countLimit) {
                msg = "Quota exceeded: " + lastPrefix + " [current count=" + newCount + ", " + (isCountHardLimit ? "hard" : "soft") + "CountLimit=" + countLimit + "]";
                RATE_LOGGER.rateLimitLog(msg);
                if (isCountHardLimit) {
                    ZooKeeperServer.updateQuotaExceededMetrics(namespace);
                    throw new KeeperException.QuotaExceededException(lastPrefix);
                }
            }
        }
        if (checkByteQuota) {
            long byteLimit;
            long newBytes = currentStats.getBytes() + bytesDiff;
            boolean isByteHardLimit = limitStats.getByteHardLimit() > -1L;
            long l = byteLimit = isByteHardLimit ? limitStats.getByteHardLimit() : limitStats.getBytes();
            if (newBytes > byteLimit) {
                msg = "Quota exceeded: " + lastPrefix + " [current bytes=" + newBytes + ", " + (isByteHardLimit ? "hard" : "soft") + "ByteLimit=" + byteLimit + "]";
                RATE_LOGGER.rateLimitLog(msg);
                if (isByteHardLimit) {
                    ZooKeeperServer.updateQuotaExceededMetrics(namespace);
                    throw new KeeperException.QuotaExceededException(lastPrefix);
                }
            }
        }
    }

    public static boolean isDigestEnabled() {
        return digestEnabled;
    }

    public static void setDigestEnabled(boolean digestEnabled) {
        LOG.info("{} = {}", (Object)ZOOKEEPER_DIGEST_ENABLED, (Object)digestEnabled);
        ZooKeeperServer.digestEnabled = digestEnabled;
    }

    private String parentPath(String path) throws KeeperException.BadArgumentsException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1 || path.indexOf(0) != -1 || this.getZKDatabase().isSpecialPath(path)) {
            throw new KeeperException.BadArgumentsException(path);
        }
        return lastSlash == 0 ? "/" : path.substring(0, lastSlash);
    }

    private String effectiveACLPath(Request request) throws KeeperException.BadArgumentsException, KeeperException.InvalidACLException {
        boolean mustCheckACL = false;
        String path = null;
        List<ACL> acl = null;
        switch (request.type) {
            case 1: 
            case 15: {
                CreateRequest req = new CreateRequest();
                if (!this.buffer2Record(request.request, req)) break;
                mustCheckACL = true;
                acl = req.getAcl();
                path = this.parentPath(req.getPath());
                break;
            }
            case 2: {
                DeleteRequest req = new DeleteRequest();
                if (!this.buffer2Record(request.request, req)) break;
                path = this.parentPath(req.getPath());
                break;
            }
            case 5: {
                SetDataRequest req = new SetDataRequest();
                if (!this.buffer2Record(request.request, req)) break;
                path = req.getPath();
                break;
            }
            case 7: {
                SetACLRequest req = new SetACLRequest();
                if (!this.buffer2Record(request.request, req)) break;
                mustCheckACL = true;
                acl = req.getAcl();
                path = req.getPath();
                break;
            }
        }
        if (mustCheckACL) {
            PrepRequestProcessor.fixupACL(path, request.authInfo, acl);
        }
        return path;
    }

    private int effectiveACLPerms(Request request) {
        switch (request.type) {
            case 1: 
            case 15: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 16;
            }
        }
        return 31;
    }

    public boolean authWriteRequest(Request request) {
        if (!enableEagerACLCheck) {
            return true;
        }
        int err = KeeperException.Code.OK.intValue();
        try {
            String pathToCheck = this.effectiveACLPath(request);
            if (pathToCheck != null) {
                this.checkACL(request.cnxn, this.zkDb.getACL(pathToCheck, null), this.effectiveACLPerms(request), request.authInfo, pathToCheck, null);
            }
        }
        catch (KeeperException.NoAuthException e) {
            LOG.debug("Request failed ACL check", (Throwable)e);
            err = e.code().intValue();
        }
        catch (KeeperException.InvalidACLException e) {
            LOG.debug("Request has an invalid ACL check", (Throwable)e);
            err = e.code().intValue();
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug("ACL check against non-existent node: {}", (Object)e.getMessage());
        }
        catch (KeeperException.BadArgumentsException e) {
            LOG.debug("ACL check against illegal node path: {}", (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.error("Uncaught exception in authWriteRequest with: ", t);
            throw t;
        }
        finally {
            if (err != KeeperException.Code.OK.intValue()) {
                this.decInProcess();
                ReplyHeader rh = new ReplyHeader(request.cxid, 0L, err);
                try {
                    request.cnxn.sendResponse(rh, null, null);
                }
                catch (IOException e) {
                    LOG.error("IOException : {}", (Throwable)e);
                }
            }
        }
        return err == KeeperException.Code.OK.intValue();
    }

    private boolean buffer2Record(ByteBuffer request, Record record) {
        boolean rv = false;
        try {
            ByteBufferInputStream.byteBuffer2Record(request, record);
            request.rewind();
            rv = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rv;
    }

    public int getOutstandingHandshakeNum() {
        if (this.serverCnxnFactory instanceof NettyServerCnxnFactory) {
            return ((NettyServerCnxnFactory)this.serverCnxnFactory).getOutstandingHandshakeNum();
        }
        return 0;
    }

    public boolean isReconfigEnabled() {
        return this.reconfigEnabled;
    }

    public ZooKeeperServerShutdownHandler getZkShutdownHandler() {
        return this.zkShutdownHandler;
    }

    static void updateQuotaExceededMetrics(String namespace) {
        if (namespace == null) {
            return;
        }
        ServerMetrics.getMetrics().QUOTA_EXCEEDED_ERROR_PER_NAMESPACE.add(namespace, 1L);
    }

    static {
        closeSessionTxnEnabled = true;
        LOG = LoggerFactory.getLogger(ZooKeeperServer.class);
        RATE_LOGGER = new RateLogger(LOG);
        ZookeeperBanner.printBanner(LOG);
        Environment.logEnv("Server environment:", LOG);
        enableEagerACLCheck = Boolean.getBoolean(ENABLE_EAGER_ACL_CHECK);
        LOG.info("{} = {}", (Object)ENABLE_EAGER_ACL_CHECK, (Object)enableEagerACLCheck);
        skipACL = System.getProperty(SKIP_ACL, "no").equals("yes");
        if (skipACL) {
            LOG.info("{}==\"yes\", ACL checks will be skipped", (Object)SKIP_ACL);
        }
        if (enforceQuota = Boolean.parseBoolean(System.getProperty(ENFORCE_QUOTA, "false"))) {
            LOG.info("{} = {}, Quota Enforce enables", (Object)ENFORCE_QUOTA, (Object)enforceQuota);
        }
        digestEnabled = Boolean.parseBoolean(System.getProperty(ZOOKEEPER_DIGEST_ENABLED, "true"));
        LOG.info("{} = {}", (Object)ZOOKEEPER_DIGEST_ENABLED, (Object)digestEnabled);
        closeSessionTxnEnabled = Boolean.parseBoolean(System.getProperty(CLOSE_SESSION_TXN_ENABLED, "true"));
        LOG.info("{} = {}", (Object)CLOSE_SESSION_TXN_ENABLED, (Object)closeSessionTxnEnabled);
        throttledOpWaitTime = Integer.getInteger("zookeeper.throttled_op_wait_time", 0);
        ok = new Exception("No prob");
        long configuredFlushDelay = Long.getLong(FLUSH_DELAY, 0L);
        ZooKeeperServer.setFlushDelay(configuredFlushDelay);
        ZooKeeperServer.setMaxWriteQueuePollTime(Long.getLong(MAX_WRITE_QUEUE_POLL_SIZE, configuredFlushDelay / 3L));
        ZooKeeperServer.setMaxBatchSize(Integer.getInteger(MAX_BATCH_SIZE, 1000));
        intBufferStartingSizeBytes = Integer.getInteger(INT_BUFFER_STARTING_SIZE_BYTES, 1024);
        if (intBufferStartingSizeBytes < 32) {
            String msg = "Buffer starting size (" + intBufferStartingSizeBytes + ") must be greater than or equal to 32. Configure with \"-Dzookeeper.intBufferStartingSizeBytes=<size>\" ";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        LOG.info("{} = {}", (Object)INT_BUFFER_STARTING_SIZE_BYTES, (Object)intBufferStartingSizeBytes);
    }

    static class ChangeRecord {
        PrecalculatedDigest precalculatedDigest;
        byte[] data;
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            ChangeRecord changeRecord = new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
            changeRecord.precalculatedDigest = this.precalculatedDigest;
            changeRecord.data = this.data;
            return changeRecord;
        }
    }

    static class PrecalculatedDigest {
        final long nodeDigest;
        final long treeDigest;

        PrecalculatedDigest(long nodeDigest, long treeDigest) {
            this.nodeDigest = nodeDigest;
            this.treeDigest = treeDigest;
        }
    }

    public static class MissingSessionException
    extends IOException {
        private static final long serialVersionUID = 7467414635467261007L;

        public MissingSessionException(String msg) {
            super(msg);
        }
    }

    protected static enum State {
        INITIAL,
        RUNNING,
        SHUTDOWN,
        ERROR;

    }
}

