/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.stats;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.io.netty.buffer.PoolArenaMetric;
import org.apache.pulsar.shade.io.netty.buffer.PoolChunkListMetric;
import org.apache.pulsar.shade.io.netty.buffer.PoolChunkMetric;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmDefaultGCMetricsLogger;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmG1GCMetricsLogger;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.JvmGCMetricsLogger;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Runnables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMetrics {
    private static final Logger log = LoggerFactory.getLogger(JvmMetrics.class);
    private final JvmGCMetricsLogger gcLogger;
    private final String componentName;
    private static final Map<String, Class<? extends JvmGCMetricsLogger>> gcLoggerMap = new HashMap<String, Class<? extends JvmGCMetricsLogger>>();

    public static JvmMetrics create(ScheduledExecutorService executor, String componentName, String jvmGCMetricsLoggerClassName) {
        String gcLoggerImplClassName = StringUtils.isNotBlank(jvmGCMetricsLoggerClassName) ? jvmGCMetricsLoggerClassName : JvmMetrics.detectGCType();
        JvmGCMetricsLogger gcLoggerImpl = null;
        if (StringUtils.isNotBlank(gcLoggerImplClassName)) {
            try {
                gcLoggerImpl = (JvmGCMetricsLogger)Class.forName(gcLoggerImplClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error("Failed to initialize jvmGCMetricsLogger {} due to {}", new Object[]{jvmGCMetricsLoggerClassName, e.getMessage(), e});
            }
        }
        return new JvmMetrics(executor, componentName, gcLoggerImpl != null ? gcLoggerImpl : new JvmDefaultGCMetricsLogger());
    }

    private static String detectGCType() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        HashSet<String> arguments = Sets.newHashSet(runtimeMxBean.getInputArguments());
        for (Map.Entry<String, Class<? extends JvmGCMetricsLogger>> gc : gcLoggerMap.entrySet()) {
            if (!arguments.contains(gc.getKey())) continue;
            return gc.getValue().getName();
        }
        return null;
    }

    public JvmMetrics(ScheduledExecutorService executor, String componentName, JvmGCMetricsLogger gcLogger) {
        this.gcLogger = gcLogger;
        if (executor != null) {
            executor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(gcLogger::refresh), 0L, 1L, TimeUnit.MINUTES);
        }
        this.componentName = componentName;
    }

    public List<Metrics> generate() {
        Metrics m = this.createMetrics();
        Runtime r = Runtime.getRuntime();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        m.put("jvm_start_time", runtimeMXBean.getStartTime());
        m.put("jvm_heap_used", r.totalMemory() - r.freeMemory());
        m.put("jvm_max_memory", r.maxMemory());
        m.put("jvm_total_memory", r.totalMemory());
        m.put("jvm_direct_memory_used", JvmMetrics.getJvmDirectMemoryUsed());
        m.put("jvm_max_direct_memory", DirectMemoryUtils.jvmMaxDirectMemory());
        m.put("jvm_thread_cnt", this.getThreadCount());
        this.gcLogger.logMetrics(m);
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : PooledByteBufAllocator.DEFAULT.metric().directArenas()) {
            this.gcLogger.logMetrics(m);
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        m.put(this.componentName + "_default_pool_allocated", totalAllocated);
        m.put(this.componentName + "_default_pool_used", totalUsed);
        this.gcLogger.logMetrics(m);
        return Lists.newArrayList(m);
    }

    public static long getJvmDirectMemoryUsed() {
        long usedDirectMemory = PlatformDependent.usedDirectMemory();
        if (usedDirectMemory != -1L) {
            return usedDirectMemory;
        }
        if (log.isDebugEnabled()) {
            log.debug("Failed to get netty-direct-memory used count.");
        }
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : pools) {
            if (!pool.getName().equals("direct")) continue;
            return pool.getMemoryUsed();
        }
        return -1L;
    }

    private long getThreadCount() {
        ThreadGroup parentThreadGroup = Thread.currentThread().getThreadGroup();
        while (parentThreadGroup.getParent() != null) {
            parentThreadGroup = parentThreadGroup.getParent();
        }
        return parentThreadGroup.activeCount();
    }

    private Metrics createMetrics() {
        return this.createMetrics(Collections.singletonMap("metric", "jvm_metrics"));
    }

    private Metrics createMetrics(Map<String, String> dimensionMap) {
        return Metrics.create(dimensionMap);
    }

    static {
        gcLoggerMap.put("-XX:+UseG1GC", JvmG1GCMetricsLogger.class);
    }
}

