/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class ConcurrentLongHashSet {
    private static final long EmptyItem = -1L;
    private static final long DeletedItem = -2L;
    private static final float SetFillFactor = 0.66f;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentLongHashSet() {
        this(256);
    }

    @Deprecated
    public ConcurrentLongHashSet(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentLongHashSet(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentLongHashSet(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        Preconditions.checkArgument(mapFillFactor > 0.0f && mapFillFactor < 1.0f);
        Preconditions.checkArgument(mapIdleFactor > 0.0f && mapIdleFactor < 1.0f);
        Preconditions.checkArgument(mapFillFactor > mapIdleFactor);
        Preconditions.checkArgument(expandFactor > 1.0f);
        Preconditions.checkArgument(shrinkFactor > 1.0f);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / 0.66f);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    public long size() {
        long size = 0L;
        for (Section s : this.sections) {
            size += (long)s.size;
        }
        return size;
    }

    public long sizeInBytes() {
        long size = 0L;
        for (Section s : this.sections) {
            size += (long)s.table.length * 8L;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section s : this.sections) {
            capacity += (long)s.capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section s : this.sections) {
            if (s.size == 0) continue;
            return false;
        }
        return true;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section s : this.sections) {
            usedBucketCount += (long)s.usedBuckets;
        }
        return usedBucketCount;
    }

    public boolean contains(long item) {
        ConcurrentLongHashSet.checkBiggerEqualZero(item);
        long h = ConcurrentLongHashSet.hash(item);
        return this.getSection(h).contains(item, (int)h);
    }

    public boolean add(long item) {
        ConcurrentLongHashSet.checkBiggerEqualZero(item);
        long h = ConcurrentLongHashSet.hash(item);
        return this.getSection(h).add(item, (int)h);
    }

    public boolean remove(long item) {
        ConcurrentLongHashSet.checkBiggerEqualZero(item);
        long h = ConcurrentLongHashSet.hash(item);
        return this.getSection(h).remove(item, (int)h);
    }

    private Section getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section s : this.sections) {
            s.clear();
        }
    }

    public void forEach(ConsumerLong processor) {
        for (Section s : this.sections) {
            s.forEach(processor);
        }
    }

    public Set<Long> items() {
        HashSet<Long> items = new HashSet<Long>();
        this.forEach(items::add);
        return items;
    }

    static final long hash(long key) {
        long hash = key * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)(n & (long)(max - 1));
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static void checkBiggerEqualZero(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Keys and values must be >= 0");
        }
    }

    private static final class Section
    extends StampedLock {
        private volatile long[] table;
        private volatile int capacity;
        private final int initCapacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentLongHashSet.alignToPowerOfTwo(capacity);
            this.table = new long[this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
            Arrays.fill(this.table, -1L);
        }

        boolean contains(long item, int hash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            int bucket = ConcurrentLongHashSet.signSafeMod(hash, this.capacity);
            try {
                while (true) {
                    long storedItem = this.table[bucket];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (item == storedItem) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedItem == -1L) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            bucket = ConcurrentLongHashSet.signSafeMod(hash, this.capacity);
                            storedItem = this.table[bucket];
                        }
                        if (item == storedItem) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedItem == -1L) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    bucket = bucket + 1 & this.table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(long item, long hash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongHashSet.signSafeMod(hash, this.capacity);
            int firstDeletedItem = -1;
            try {
                while (true) {
                    long storedItem;
                    if (item == (storedItem = this.table[bucket])) {
                        boolean bl = false;
                        return bl;
                    }
                    if (storedItem == -1L) {
                        if (firstDeletedItem != -1) {
                            bucket = firstDeletedItem;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.table[bucket] = item;
                        ++this.size;
                        boolean bl = true;
                        return bl;
                    }
                    if (storedItem == -2L && firstDeletedItem == -1) {
                        firstDeletedItem = bucket;
                    }
                    bucket = bucket + 1 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongHashSet.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean remove(long item, int hash) {
            stamp = this.writeLock();
            bucket = ConcurrentLongHashSet.signSafeMod(hash, this.capacity);
            try {
                while (true) {
                    if (item == (storedItem = this.table[bucket])) {
                        --this.size;
                        this.cleanBucket(bucket);
                        var9_6 = true;
                        return var9_6;
                    }
                    if (storedItem == -1L) {
                        var9_7 = false;
                        return var9_7;
                    }
                    bucket = bucket + 1 & this.table.length - 1;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongHashSet.access$500((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl27
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl27:
                // 3 sources

            }
        }

        private void cleanBucket(int bucket) {
            int nextInArray = bucket + 1 & this.table.length - 1;
            if (this.table[nextInArray] == -1L) {
                this.table[bucket] = -1L;
                --this.usedBuckets;
                bucket = bucket - 1 & this.table.length - 1;
                while (this.table[bucket] == -2L) {
                    this.table[bucket] = -1L;
                    --this.usedBuckets;
                    bucket = bucket - 1 & this.table.length - 1;
                }
            } else {
                this.table[bucket] = -2L;
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.table, -1L);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(ConsumerLong processor) {
            long stamp = this.tryOptimisticRead();
            long[] table = this.table;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    table = this.table;
                }
                for (int bucket = 0; bucket < table.length; ++bucket) {
                    long storedItem = table[bucket];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedItem = table[bucket];
                    }
                    if (storedItem == -2L || storedItem == -1L) continue;
                    processor.accept(storedItem);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash(int newCapacity) {
            long[] newTable = new long[newCapacity];
            Arrays.fill(newTable, -1L);
            for (int i = 0; i < this.table.length; ++i) {
                long storedItem = this.table[i];
                if (storedItem == -1L || storedItem == -2L) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedItem);
            }
            this.table = newTable;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            long[] newTable = new long[this.initCapacity];
            Arrays.fill(newTable, -1L);
            this.table = newTable;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static void insertKeyValueNoLock(long[] table, int capacity, long item) {
            int bucket = ConcurrentLongHashSet.signSafeMod(ConcurrentLongHashSet.hash(item), capacity);
            while (true) {
                long storedKey;
                if ((storedKey = table[bucket]) == -1L) {
                    table[bucket] = item;
                    return;
                }
                bucket = bucket + 1 & table.length - 1;
            }
        }
    }

    public static interface ConsumerLong {
        public void accept(long var1);
    }

    public static class Builder {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentLongHashSet build() {
            return new ConcurrentLongHashSet(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }
}

