/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.cookie;

import java.io.PrintStream;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.cookie.CookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.LongVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCookieCommand
extends CookieCommand<Flags> {
    private static final Logger log = LoggerFactory.getLogger(DeleteCookieCommand.class);
    private static final String NAME = "delete";
    private static final String DESC = "Delete a cookie for a given bookie";

    public DeleteCookieCommand() {
        this(new Flags());
    }

    DeleteCookieCommand(PrintStream console) {
        this(new Flags(), console);
    }

    public DeleteCookieCommand(Flags flags) {
        this(flags, System.out);
    }

    private DeleteCookieCommand(Flags flags, PrintStream console) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).withConsole(console).withArgumentsUsage("<bookie-id>").build());
    }

    @Override
    protected void apply(RegistrationManager rm, Flags cmdFlags) throws Exception {
        BookieId bookieId = this.getBookieId(cmdFlags);
        try {
            rm.removeCookie(bookieId, new LongVersion(-1L));
        }
        catch (BookieException.CookieNotFoundException cee) {
            this.spec.console().println("Cookie not found for bookie '" + bookieId + "'");
            throw cee;
        }
        catch (BookieException be) {
            this.spec.console().println("Exception on deleting cookie for bookie '" + bookieId + "'");
            be.printStackTrace(this.spec.console());
            throw be;
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

