/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tls;

import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityException;
import org.apache.pulsar.shade.org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityProviderFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityProviderFactoryFactory.class);

    public static SecurityHandlerFactory getSecurityProviderFactory(String securityHandler) throws SecurityException {
        SecurityHandlerFactory shFactory;
        if (securityHandler == null || securityHandler.equals("")) {
            return null;
        }
        try {
            Class<SecurityHandlerFactory> shFactoryClass = ReflectionUtils.forName(securityHandler, SecurityHandlerFactory.class);
            shFactory = ReflectionUtils.newInstance(shFactoryClass);
            LOG.info("Loaded security handler for {}", (Object)securityHandler);
        }
        catch (RuntimeException re) {
            LOG.error("Unable to load security handler for {}: ", (Object)securityHandler, (Object)re.getCause());
            throw new SecurityException(re.getCause());
        }
        return shFactory;
    }
}

