/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tls;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.AuthToken;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.BookKeeperPrincipal;
import org.apache.pulsar.shade.org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieAuthZFactory
implements BookieAuthProvider.Factory {
    private static final Logger log = LoggerFactory.getLogger(BookieAuthZFactory.class);
    public String[] allowedRoles;

    @Override
    public String getPluginName() {
        return "BookieAuthZFactory";
    }

    @Override
    public void init(ServerConfiguration conf) throws IOException {
        this.allowedRoles = conf.getAuthorizedRoles();
        if (this.allowedRoles == null || this.allowedRoles.length == 0) {
            throw new RuntimeException("Configuration option 'bookieAuthProviderFactoryClass' is set to 'BookieAuthZFactory' but no roles set for configuration field 'authorizedRoles'.");
        }
        for (String allowedRole : this.allowedRoles) {
            if (!Strings.isNullOrEmpty(allowedRole)) continue;
            throw new RuntimeException("Configuration option 'bookieAuthProviderFactoryClass' is set to 'BookieAuthZFactory' but no roles set for configuration field 'authorizedRoles'.");
        }
    }

    @Override
    public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
        return new BookieAuthProvider(){
            AuthCallbacks.GenericCallback<Void> completeCallback;
            {
                this.completeCallback = completeCb;
            }

            @Override
            public void onProtocolUpgrade() {
                try {
                    boolean secureBookieSideChannel = addr.isSecure();
                    Collection<Object> certificates = addr.getProtocolPrincipals();
                    if (secureBookieSideChannel && !certificates.isEmpty() && certificates.iterator().next() instanceof X509Certificate) {
                        X509Certificate tempCert = (X509Certificate)certificates.iterator().next();
                        String[] certRole = CertUtils.getRolesFromOU(tempCert);
                        if (certRole == null || certRole.length == 0) {
                            log.error("AuthZ failed: No cert role in OU field of certificate. Must have a role from allowedRoles list {} host: {}", (Object)BookieAuthZFactory.this.allowedRoles, (Object)addr.getRemoteAddr());
                            this.completeCallback.operationComplete(-102, null);
                            return;
                        }
                        boolean authorized = false;
                        for (String allowedRole : BookieAuthZFactory.this.allowedRoles) {
                            if (!certRole[0].equals(allowedRole)) continue;
                            authorized = true;
                            break;
                        }
                        if (authorized) {
                            addr.setAuthorizedId(new BookKeeperPrincipal(certRole[0]));
                            this.completeCallback.operationComplete(0, null);
                        } else {
                            log.error("AuthZ failed: Cert role {} doesn't match allowedRoles list {}; host: {}", new Object[]{certRole, BookieAuthZFactory.this.allowedRoles, addr.getRemoteAddr()});
                            this.completeCallback.operationComplete(-102, null);
                        }
                    } else {
                        if (!secureBookieSideChannel) {
                            log.error("AuthZ failed: Bookie side channel is not secured; host: {}", (Object)addr.getRemoteAddr());
                        } else if (certificates.isEmpty()) {
                            log.error("AuthZ failed: Certificate missing; host: {}", (Object)addr.getRemoteAddr());
                        } else {
                            log.error("AuthZ failed: Certs are missing or not X509 type; host: {}", (Object)addr.getRemoteAddr());
                        }
                        this.completeCallback.operationComplete(-102, null);
                    }
                }
                catch (Exception e) {
                    log.error("AuthZ failed: Failed to parse certificate; host: {}, {}", (Object)addr.getRemoteAddr(), (Object)e);
                    this.completeCallback.operationComplete(-102, null);
                }
            }

            @Override
            public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
            }
        };
    }
}

