/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service;

import org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.service.RangeStoreServiceFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service.RangeStoreServiceImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;

public class RangeStoreServiceFactoryImpl
implements RangeStoreServiceFactory {
    private final StorageConfiguration storageConf;
    private final StorageContainerPlacementPolicy rangePlacementPolicy;
    private final SharedResourceManager.Resource<OrderedScheduler> schedulerResource;
    private final OrderedScheduler scheduler;
    private final MVCCStoreFactory storeFactory;
    private final StorageServerClientManager clientManager;

    public RangeStoreServiceFactoryImpl(StorageConfiguration storageConf, StorageContainerPlacementPolicy rangePlacementPolicy, SharedResourceManager.Resource<OrderedScheduler> schedulerResource, MVCCStoreFactory storeFactory, StorageServerClientManager clientManager) {
        this.storageConf = storageConf;
        this.rangePlacementPolicy = rangePlacementPolicy;
        this.schedulerResource = schedulerResource;
        this.scheduler = SharedResourceManager.shared().get(schedulerResource);
        this.storeFactory = storeFactory;
        this.clientManager = clientManager;
    }

    @Override
    public RangeStoreService createService(long scId) {
        return new RangeStoreServiceImpl(scId, this.rangePlacementPolicy, this.scheduler, this.storeFactory, this.clientManager);
    }

    @Override
    public void close() {
        SharedResourceManager.shared().release(this.schedulerResource, this.scheduler);
    }
}

