/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus;

import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.google.common.base.Joiner;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.ScopeContext;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.SimpleGauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.ThreadScopedDataSketchesStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus.ThreadScopedLongAdderCounter;

public class PrometheusStatsLogger
implements StatsLogger {
    private final PrometheusMetricsProvider provider;
    private final String scope;
    private final Map<String, String> labels;

    PrometheusStatsLogger(PrometheusMetricsProvider provider, String scope, Map<String, String> labels) {
        this.provider = provider;
        this.scope = scope;
        this.labels = labels;
    }

    @Override
    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.scopeContext(name), x -> new DataSketchesOpStatsLogger(this.labels));
    }

    @Override
    public OpStatsLogger getThreadScopedOpStatsLogger(String name) {
        return this.provider.threadScopedOpStats.computeIfAbsent(this.scopeContext(name), x -> new ThreadScopedDataSketchesStatsLogger(this.provider, (ScopeContext)x, this.labels));
    }

    @Override
    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.scopeContext(name), x -> new LongAdderCounter(this.labels));
    }

    @Override
    public Counter getThreadScopedCounter(String name) {
        return this.provider.threadScopedCounters.computeIfAbsent(this.scopeContext(name), x -> new ThreadScopedLongAdderCounter(this.provider, (ScopeContext)x, this.labels));
    }

    @Override
    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.gauges.computeIfAbsent(this.scopeContext(name), x -> new SimpleGauge(gauge, this.labels));
    }

    @Override
    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    @Override
    public void removeScope(String name, StatsLogger statsLogger) {
    }

    @Override
    public StatsLogger scope(String name) {
        return new PrometheusStatsLogger(this.provider, this.completeName(name), this.labels);
    }

    @Override
    public StatsLogger scopeLabel(String labelName, String labelValue) {
        TreeMap<String, String> newLabels = new TreeMap<String, String>(this.labels);
        newLabels.put(labelName, labelValue);
        return new PrometheusStatsLogger(this.provider, this.scope, newLabels);
    }

    private ScopeContext scopeContext(String name) {
        return new ScopeContext(this.completeName(name), this.labels);
    }

    private String completeName(String name) {
        return Collector.sanitizeMetricName(this.scope.isEmpty() ? name : Joiner.on('_').join(this.scope, name, new Object[0]));
    }
}

