/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus;

import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;

public class LongAdderCounter
implements Counter {
    private final LongAdder counter = new LongAdder();
    private Map<String, String> labels;
    private boolean threadInitialized;

    public LongAdderCounter(Map<String, String> labels) {
        this.labels = labels;
    }

    @Override
    public void clear() {
        this.counter.reset();
    }

    @Override
    public void inc() {
        this.counter.increment();
    }

    @Override
    public void dec() {
        this.counter.decrement();
    }

    @Override
    public void add(long delta) {
        this.counter.add(delta);
    }

    @Override
    public Long get() {
        return this.counter.sum();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean isThreadInitialized() {
        return this.threadInitialized;
    }

    public void initializeThread(Map<String, String> labels) {
        this.labels = labels;
        this.threadInitialized = true;
    }
}

