/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.mvcc;

import java.util.function.Predicate;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.impl.result.KeyValueFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.impl.result.KeyValueImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.coder.Coder;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Recycled;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.store.ValueType;

public class MVCCRecord
implements Recycled,
Predicate<RangeOption<?>> {
    private static final Recycler<MVCCRecord> RECYCLER = new Recycler<MVCCRecord>(){

        @Override
        protected MVCCRecord newObject(Recycler.Handle<MVCCRecord> handle) {
            return new MVCCRecord(handle);
        }
    };
    private ByteBuf value;
    private long number;
    private final Recycler.Handle<MVCCRecord> handle;
    private long createRev;
    private long modRev;
    private long version;
    private ValueType valueType = ValueType.BYTES;
    private long expireTime;

    public static MVCCRecord newRecord() {
        return RECYCLER.get();
    }

    private MVCCRecord(Recycler.Handle<MVCCRecord> handle) {
        this.handle = handle;
    }

    public MVCCRecord duplicate() {
        MVCCRecord record = MVCCRecord.newRecord();
        record.createRev = this.createRev;
        record.modRev = this.modRev;
        record.version = this.version;
        record.valueType = this.valueType;
        record.value = this.value.retainedSlice();
        record.number = this.number;
        record.expireTime = this.expireTime;
        return record;
    }

    public int compareModRev(long revision) {
        return Long.compare(this.modRev, revision);
    }

    public int compareCreateRev(long revision) {
        return Long.compare(this.createRev, revision);
    }

    public int compareVersion(long version) {
        return Long.compare(this.version, version);
    }

    public void setValue(ByteBuf buf, ValueType valueType) {
        if (null != this.value) {
            this.value.release();
        }
        this.value = buf;
        this.valueType = valueType;
        if (ValueType.NUMBER == valueType) {
            this.number = buf.getLong(0);
        }
    }

    public boolean expired() {
        return this.expireTime != 0L && this.expireTime > System.currentTimeMillis();
    }

    private void reset() {
        if (null != this.value) {
            this.value.release();
            this.value = null;
        }
        this.modRev = -1L;
        this.createRev = -1L;
        this.version = -1L;
        this.number = -1L;
        this.valueType = ValueType.BYTES;
    }

    @Override
    public void recycle() {
        this.reset();
        this.handle.recycle(this);
    }

    <K, V> KeyValueImpl<K, V> asKVRecord(KeyValueFactory<K, V> recordFactory, K key, Coder<V> valCoder) {
        return recordFactory.newKv().key(key).value(valCoder.decode(this.value)).createRevision(this.createRev).modifiedRevision(this.modRev).version(this.version).isNumber(ValueType.NUMBER == this.valueType).numberValue(this.number);
    }

    @Override
    public boolean test(RangeOption<?> rangeOption) {
        if (null == rangeOption) {
            return true;
        }
        return this.createRev >= rangeOption.minCreateRev() && this.createRev <= rangeOption.maxCreateRev() && this.modRev >= rangeOption.minModRev() && this.modRev <= rangeOption.maxModRev();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MVCCRecord)) {
            return false;
        }
        MVCCRecord other = (MVCCRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        if (this.getCreateRev() != other.getCreateRev()) {
            return false;
        }
        if (this.getModRev() != other.getModRev()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getExpireTime() != other.getExpireTime()) {
            return false;
        }
        ByteBuf this$value = this.getValue();
        ByteBuf other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Recycler.Handle<MVCCRecord> this$handle = this.getHandle();
        Recycler.Handle<MVCCRecord> other$handle = other.getHandle();
        if (this$handle == null ? other$handle != null : !this$handle.equals(other$handle)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MVCCRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $number = this.getNumber();
        result = result * 59 + (int)($number >>> 32 ^ $number);
        long $createRev = this.getCreateRev();
        result = result * 59 + (int)($createRev >>> 32 ^ $createRev);
        long $modRev = this.getModRev();
        result = result * 59 + (int)($modRev >>> 32 ^ $modRev);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $expireTime = this.getExpireTime();
        result = result * 59 + (int)($expireTime >>> 32 ^ $expireTime);
        ByteBuf $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Recycler.Handle<MVCCRecord> $handle = this.getHandle();
        result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        return result;
    }

    public String toString() {
        return "MVCCRecord(value=" + this.getValue() + ", number=" + this.getNumber() + ", handle=" + this.getHandle() + ", createRev=" + this.getCreateRev() + ", modRev=" + this.getModRev() + ", version=" + this.getVersion() + ", valueType=" + this.getValueType() + ", expireTime=" + this.getExpireTime() + ")";
    }

    public void setValue(ByteBuf value) {
        this.value = value;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public void setCreateRev(long createRev) {
        this.createRev = createRev;
    }

    public void setModRev(long modRev) {
        this.modRev = modRev;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public ByteBuf getValue() {
        return this.value;
    }

    public long getNumber() {
        return this.number;
    }

    public Recycler.Handle<MVCCRecord> getHandle() {
        return this.handle;
    }

    public long getCreateRev() {
        return this.createRev;
    }

    public long getModRev() {
        return this.modRev;
    }

    public long getVersion() {
        return this.version;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public long getExpireTime() {
        return this.expireTime;
    }
}

