/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Journal;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LogMark;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLastLogMarkService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(GetLastLogMarkService.class);
    protected ServerConfiguration conf;

    public GetLastLogMarkService(ServerConfiguration conf) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            try {
                HashMap<String, String> output = Maps.newHashMap();
                ArrayList<Journal> journals = Lists.newArrayListWithCapacity(this.conf.getJournalDirs().length);
                int idx = 0;
                for (File journalDir : this.conf.getJournalDirs()) {
                    journals.add(new Journal(idx++, journalDir, this.conf, new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()))));
                }
                for (Journal journal : journals) {
                    LogMark lastLogMark = journal.getLastLogMark().getCurMark();
                    LOG.debug("LastLogMark: Journal Id - " + lastLogMark.getLogFileId() + "(" + Long.toHexString(lastLogMark.getLogFileId()) + ".txn), Pos - " + lastLogMark.getLogFileOffset());
                    output.put("LastLogMark: Journal Id - " + lastLogMark.getLogFileId() + "(" + Long.toHexString(lastLogMark.getLogFileId()) + ".txn)", "Pos - " + lastLogMark.getLogFileOffset());
                }
                String jsonResponse = JsonUtil.toJson(output);
                LOG.debug("output body:" + jsonResponse);
                response.setBody(jsonResponse);
                response.setCode(HttpServer.StatusCode.OK);
                return response;
            }
            catch (Throwable e) {
                LOG.error("Exception occurred while getting last log mark", e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("ERROR handling request: " + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

