/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.StateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;

public class BookieStateService
implements HttpEndpointService {
    private final Bookie bookie;

    public BookieStateService(Bookie bookie) {
        this.bookie = Preconditions.checkNotNull(bookie);
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only support GET method to retrieve bookie state.");
            return response;
        }
        StateManager sm = this.bookie.getStateManager();
        BookieState bs = new BookieState();
        bs.running = sm.isRunning();
        bs.readOnly = sm.isReadOnly();
        bs.shuttingDown = sm.isShuttingDown();
        bs.availableForHighPriorityWrites = sm.isAvailableForHighPriorityWrites();
        String jsonResponse = JsonUtil.toJson(bs);
        response.setBody(jsonResponse);
        response.setCode(HttpServer.StatusCode.OK);
        return response;
    }

    public static class BookieState {
        private boolean running;
        private boolean readOnly;
        private boolean shuttingDown;
        private boolean availableForHighPriorityWrites;

        public boolean isRunning() {
            return this.running;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isShuttingDown() {
            return this.shuttingDown;
        }

        public boolean isAvailableForHighPriorityWrites() {
            return this.availableForHighPriorityWrites;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setShuttingDown(boolean shuttingDown) {
            this.shuttingDown = shuttingDown;
        }

        public void setAvailableForHighPriorityWrites(boolean availableForHighPriorityWrites) {
            this.availableForHighPriorityWrites = availableForHighPriorityWrites;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BookieState)) {
                return false;
            }
            BookieState other = (BookieState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRunning() != other.isRunning()) {
                return false;
            }
            if (this.isReadOnly() != other.isReadOnly()) {
                return false;
            }
            if (this.isShuttingDown() != other.isShuttingDown()) {
                return false;
            }
            return this.isAvailableForHighPriorityWrites() == other.isAvailableForHighPriorityWrites();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BookieState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRunning() ? 79 : 97);
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            result = result * 59 + (this.isShuttingDown() ? 79 : 97);
            result = result * 59 + (this.isAvailableForHighPriorityWrites() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BookieStateService.BookieState(running=" + this.isRunning() + ", readOnly=" + this.isReadOnly() + ", shuttingDown=" + this.isShuttingDown() + ", availableForHighPriorityWrites=" + this.isAvailableForHighPriorityWrites() + ")";
        }
    }
}

