/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.server.http.service;

import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.StateManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;

public class BookieIsReadyService
implements HttpEndpointService {
    private final Bookie bookie;

    public BookieIsReadyService(Bookie bookie) {
        this.bookie = Preconditions.checkNotNull(bookie);
    }

    @Override
    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only support GET method check if bookie is ready.");
            return response;
        }
        StateManager sm = this.bookie.getStateManager();
        if (sm.isRunning() && !sm.isShuttingDown()) {
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("OK");
        } else {
            response.setCode(HttpServer.StatusCode.SERVICE_UNAVAILABLE);
            response.setBody("Bookie is not fully started yet");
        }
        return response;
    }
}

