/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.net;

import org.apache.pulsar.shade.org.apache.bookkeeper.net.Node;

public class NodeBase
implements Node {
    public static final char PATH_SEPARATOR = '/';
    public static final String PATH_SEPARATOR_STR = "/";
    public static final String ROOT = "";
    protected String name;
    protected String location;
    protected int level;
    protected Node parent;

    public NodeBase() {
    }

    public NodeBase(String path) {
        path = NodeBase.normalize(path);
        int index = path.lastIndexOf(47);
        if (index == -1) {
            this.set(ROOT, path);
        } else {
            this.set(path.substring(index + 1), path.substring(0, index));
        }
    }

    public NodeBase(String name, String location) {
        this.set(name, NodeBase.normalize(location));
    }

    public NodeBase(String name, String location, Node parent, int level) {
        this.set(name, NodeBase.normalize(location));
        this.parent = parent;
        this.level = level;
    }

    private void set(String name, String location) {
        if (name != null && name.contains(PATH_SEPARATOR_STR)) {
            throw new IllegalArgumentException("Network location name contains /: " + name);
        }
        this.name = name == null ? ROOT : name;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNetworkLocation() {
        return this.location;
    }

    @Override
    public void setNetworkLocation(String location) {
        this.location = location;
    }

    public static String getPath(Node node) {
        return node.getNetworkLocation() + PATH_SEPARATOR_STR + node.getName();
    }

    public String toString() {
        return NodeBase.getPath(this);
    }

    public static String normalize(String path) {
        if (path == null || path.length() == 0) {
            return ROOT;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Location path does not start with /: " + path);
        }
        int len = path.length();
        if (path.charAt(len - 1) == '/') {
            return path.substring(0, len - 1);
        }
        return path;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    public static int locationToDepth(String location) {
        String normalizedLocation = NodeBase.normalize(location);
        int length = normalizedLocation.length();
        int depth = 0;
        for (int i = 0; i < length; ++i) {
            if (normalizedLocation.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    @Override
    public String getNetworkLocation(int distanceFromLeaves) {
        Node parent;
        Node node = this;
        while (distanceFromLeaves > 1 && null != (parent = node.getParent())) {
            node = parent;
            --distanceFromLeaves;
        }
        return node.getNetworkLocation();
    }
}

