/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.ConcurrentOpenLongPairRangeSet;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.LongPairRangeSet;

public class RangeSetWrapper<T extends Comparable<T>>
implements LongPairRangeSet<T> {
    private final LongPairRangeSet<T> rangeSet;
    private final LongPairRangeSet.LongPairConsumer<T> rangeConverter;
    private final ManagedLedgerConfig config;
    private final boolean enableMultiEntry;
    private final LongPairRangeSet.DefaultRangeSet<Long> dirtyLedgers = new LongPairRangeSet.DefaultRangeSet<Long>((key, value) -> key);

    public RangeSetWrapper(LongPairRangeSet.LongPairConsumer<T> rangeConverter, ManagedCursorImpl managedCursor) {
        Objects.requireNonNull(managedCursor);
        this.config = managedCursor.getConfig();
        this.rangeConverter = rangeConverter;
        this.rangeSet = this.config.isUnackedRangesOpenCacheSetEnabled() ? new ConcurrentOpenLongPairRangeSet<T>(4096, rangeConverter) : new LongPairRangeSet.DefaultRangeSet<T>(rangeConverter);
        this.enableMultiEntry = this.config.isPersistentUnackedRangesWithMultipleEntriesEnabled();
    }

    @Override
    public void addOpenClosed(long lowerKey, long lowerValue, long upperKey, long upperValue) {
        if (this.enableMultiEntry) {
            this.dirtyLedgers.addOpenClosed(lowerKey, 0L, upperKey, 0L);
        }
        this.rangeSet.addOpenClosed(lowerKey, lowerValue, upperKey, upperValue);
    }

    @Override
    public boolean contains(long key, long value) {
        return this.rangeSet.contains(key, value);
    }

    @Override
    public Range<T> rangeContaining(long key, long value) {
        return this.rangeSet.rangeContaining(key, value);
    }

    @Override
    public void removeAtMost(long key, long value) {
        if (this.enableMultiEntry) {
            this.dirtyLedgers.removeAtMost(key, 0L);
        }
        this.rangeSet.removeAtMost(key, value);
    }

    @Override
    public boolean isEmpty() {
        return this.rangeSet.isEmpty();
    }

    @Override
    public void clear() {
        this.rangeSet.clear();
        this.dirtyLedgers.clear();
    }

    @Override
    public Range<T> span() {
        return this.rangeSet.span();
    }

    @Override
    public Collection<Range<T>> asRanges() {
        Collection<Range<T>> collection = this.rangeSet.asRanges();
        if (collection instanceof List) {
            return collection;
        }
        return new ArrayList<Range<T>>(collection);
    }

    @Override
    public void forEach(LongPairRangeSet.RangeProcessor<T> action) {
        this.rangeSet.forEach(action);
    }

    @Override
    public void forEach(LongPairRangeSet.RangeProcessor<T> action, LongPairRangeSet.LongPairConsumer<? extends T> consumer) {
        this.rangeSet.forEach(action, consumer);
    }

    @Override
    public int size() {
        return this.rangeSet.size();
    }

    @Override
    public Range<T> firstRange() {
        return this.rangeSet.firstRange();
    }

    @Override
    public Range<T> lastRange() {
        return this.rangeSet.lastRange();
    }

    @Override
    public int cardinality(long lowerKey, long lowerValue, long upperKey, long upperValue) {
        return this.rangeSet.cardinality(lowerKey, lowerValue, upperKey, upperValue);
    }

    @VisibleForTesting
    void add(Range<LongPairRangeSet.LongPair> range) {
        if (!(this.rangeSet instanceof ConcurrentOpenLongPairRangeSet)) {
            throw new UnsupportedOperationException("Only ConcurrentOpenLongPairRangeSet support this method");
        }
        ((ConcurrentOpenLongPairRangeSet)this.rangeSet).add(range);
    }

    @VisibleForTesting
    void remove(Range<T> range) {
        if (this.rangeSet instanceof ConcurrentOpenLongPairRangeSet) {
            ((ConcurrentOpenLongPairRangeSet)this.rangeSet).remove(range);
        } else {
            ((LongPairRangeSet.DefaultRangeSet)this.rangeSet).remove(range);
        }
    }

    public void resetDirtyKeys() {
        this.dirtyLedgers.clear();
    }

    public boolean isDirtyLedgers(long ledgerId) {
        return this.dirtyLedgers.contains(ledgerId);
    }

    public String toString() {
        return this.rangeSet.toString();
    }
}

