/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.discover;

import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface RegistrationManager
extends AutoCloseable {
    @Override
    public void close();

    public String getClusterInstanceId() throws BookieException;

    public void registerBookie(BookieId var1, boolean var2, BookieServiceInfo var3) throws BookieException;

    public void unregisterBookie(BookieId var1, boolean var2) throws BookieException;

    public boolean isBookieRegistered(BookieId var1) throws BookieException;

    public void writeCookie(BookieId var1, Versioned<byte[]> var2) throws BookieException;

    public Versioned<byte[]> readCookie(BookieId var1) throws BookieException;

    public void removeCookie(BookieId var1, Version var2) throws BookieException;

    public boolean prepareFormat() throws Exception;

    public boolean initNewCluster() throws Exception;

    public boolean format() throws Exception;

    public boolean nukeExistingCluster() throws Exception;

    public void addRegistrationListener(RegistrationListener var1);

    @FunctionalInterface
    public static interface RegistrationListener {
        public void onRegistrationExpired();
    }
}

