/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.container;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.grpc.netty.LongBinaryMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StorageContainerClientInterceptor.class);
    private final long scId;
    private final Metadata.Key<Long> scIdKey;

    public StorageContainerClientInterceptor(long scId) {
        this.scId = scId;
        this.scIdKey = Metadata.Key.of((String)"bk-rt-sc-id-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (log.isTraceEnabled()) {
            log.trace("Intercepting method {} : req marshaller = {}, resp marshaller = {}", new Object[]{method.getFullMethodName(), method.getRequestMarshaller(), method.getResponseMarshaller()});
        }
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                if (log.isTraceEnabled()) {
                    log.trace("Attaching storage container {},", (Object)StorageContainerClientInterceptor.this.scId);
                }
                headers.put(StorageContainerClientInterceptor.this.scIdKey, (Object)StorageContainerClientInterceptor.this.scId);
                this.delegate().start(responseListener, headers);
            }

            public void request(int numMessages) {
                if (log.isTraceEnabled()) {
                    log.trace("request {} messages", (Object)numMessages);
                }
                super.request(numMessages);
            }
        };
    }
}

