/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.client.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerEntry;

public class LedgerEntriesImpl
implements LedgerEntries {
    private List<LedgerEntry> entries;
    private final Recycler.Handle<LedgerEntriesImpl> recyclerHandle;
    private static final Recycler<LedgerEntriesImpl> RECYCLER = new Recycler<LedgerEntriesImpl>(){

        @Override
        protected LedgerEntriesImpl newObject(Recycler.Handle<LedgerEntriesImpl> handle) {
            return new LedgerEntriesImpl(handle);
        }
    };

    private LedgerEntriesImpl(Recycler.Handle<LedgerEntriesImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private void recycle() {
        this.releaseByteBuf();
        this.recyclerHandle.recycle(this);
    }

    private void releaseByteBuf() {
        if (this.entries != null) {
            this.entries.forEach(LedgerEntry::close);
            this.entries.clear();
            this.entries = null;
        }
    }

    public static LedgerEntriesImpl create(List<LedgerEntry> entries) {
        Preconditions.checkArgument(!entries.isEmpty(), "entries for create should not be empty.");
        LedgerEntriesImpl ledgerEntries = RECYCLER.get();
        ledgerEntries.entries = entries;
        return ledgerEntries;
    }

    @Override
    public LedgerEntry getEntry(long entryId) {
        Preconditions.checkNotNull(this.entries, "entries has been recycled");
        long firstId = this.entries.get(0).getEntryId();
        long lastId = this.entries.get(this.entries.size() - 1).getEntryId();
        if (entryId < firstId || entryId > lastId) {
            throw new IndexOutOfBoundsException("required index: " + entryId + " is out of bounds: [ " + firstId + ", " + lastId + " ].");
        }
        return this.entries.get((int)(entryId - firstId));
    }

    @Override
    public Iterator<LedgerEntry> iterator() {
        Preconditions.checkNotNull(this.entries, "entries has been recycled");
        return this.entries.iterator();
    }

    @Override
    public void close() {
        this.recycle();
    }
}

