/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Journal;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.ArrayUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorageDataFormats;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgersIndexRebuildOp {
    private static final Logger LOG = LoggerFactory.getLogger(LedgersIndexRebuildOp.class);
    private final ServerConfiguration conf;
    private final boolean verbose;
    private static final String LedgersSubPath = "ledgers";

    public LedgersIndexRebuildOp(ServerConfiguration conf, boolean verbose) {
        this.conf = conf;
        this.verbose = verbose;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public boolean initiate() {
        LOG.info("Starting ledger index rebuilding");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        String basePath = BookieImpl.getCurrentDirectory(this.conf.getLedgerDirs()[0]).toString();
        String tempLedgersSubPath = "ledgers.TEMP-" + timestamp;
        Path tempPath = FileSystems.getDefault().getPath(basePath, tempLedgersSubPath);
        Path currentPath = FileSystems.getDefault().getPath(basePath, LedgersSubPath);
        LOG.info("Starting scan phase (scans journal and entry log files)");
        try {
            HashSet<Long> ledgers = new HashSet<Long>();
            this.scanJournals(ledgers);
            this.scanEntryLogFiles(ledgers);
            LOG.info("Scan complete, found {} ledgers. Starting to build a new ledgers index", (Object)ledgers.size());
            try (KeyValueStorage newIndex = KeyValueStorageRocksDB.factory.newKeyValueStorage(basePath, tempLedgersSubPath, KeyValueStorageFactory.DbConfigType.Default, this.conf);){
                LOG.info("Created ledgers index at temp location {}", (Object)tempPath);
                for (Long ledgerId : ledgers) {
                    DbLedgerStorageDataFormats.LedgerData ledgerData = DbLedgerStorageDataFormats.LedgerData.newBuilder().setExists(true).setFenced(true).setMasterKey(ByteString.EMPTY).build();
                    byte[] ledgerArray = new byte[16];
                    ArrayUtil.setLong(ledgerArray, 0, ledgerId);
                    newIndex.put(ledgerArray, ledgerData.toByteArray());
                }
                newIndex.sync();
            }
        }
        catch (Throwable t) {
            LOG.error("Error during rebuild, the original index remains unchanged", t);
            this.delete(tempPath);
            return false;
        }
        try {
            Path prevPath = FileSystems.getDefault().getPath(basePath, "ledgers.PREV-" + timestamp);
            LOG.info("Moving original index from original location: {} up to back-up location: {}", (Object)currentPath, (Object)prevPath);
            Files.move(currentPath, prevPath, new CopyOption[0]);
            LOG.info("Moving rebuilt index from: {} to: {}", (Object)tempPath, (Object)currentPath);
            Files.move(tempPath, currentPath, new CopyOption[0]);
            LOG.info("Original index has been replaced with the new index. The original index has been moved to {}", (Object)prevPath);
        }
        catch (IOException e) {
            LOG.error("Could not replace original index with rebuilt index. To return to the original state, ensure the original index is in its original location", (Throwable)e);
            return false;
        }
        return true;
    }

    private void scanEntryLogFiles(final Set<Long> ledgers) throws IOException {
        EntryLogger entryLogger = new EntryLogger(this.conf, new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold())));
        Set<Long> entryLogs = entryLogger.getEntryLogsSet();
        int totalEntryLogs = entryLogs.size();
        int completedEntryLogs = 0;
        LOG.info("Scanning {} entry logs", (Object)totalEntryLogs);
        for (long entryLogId : entryLogs) {
            entryLogger.scanEntryLog(entryLogId, new EntryLogger.EntryLogScanner(){

                @Override
                public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                    if (ledgers.add(ledgerId) && LedgersIndexRebuildOp.this.verbose) {
                        LOG.info("Found ledger {} in entry log", (Object)ledgerId);
                    }
                }

                @Override
                public boolean accept(long ledgerId) {
                    return true;
                }
            });
            LOG.info("Completed scanning of log {}.log -- {} / {}", new Object[]{Long.toHexString(entryLogId), ++completedEntryLogs, totalEntryLogs});
        }
    }

    private void scanJournals(Set<Long> ledgers) throws IOException {
        for (Journal journal : this.getJournals(this.conf)) {
            List<Long> journalIds = Journal.listJournalIds(journal.getJournalDirectory(), new Journal.JournalIdFilter(){

                @Override
                public boolean accept(long journalId) {
                    return true;
                }
            });
            for (Long journalId : journalIds) {
                this.scanJournal(journal, journalId, ledgers);
            }
        }
    }

    private List<Journal> getJournals(ServerConfiguration conf) throws IOException {
        ArrayList<Journal> journals = Lists.newArrayListWithCapacity(conf.getJournalDirs().length);
        int idx = 0;
        for (File journalDir : conf.getJournalDirs()) {
            journals.add(new Journal(idx++, new File(journalDir, "current"), conf, new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()))));
        }
        return journals;
    }

    private void scanJournal(Journal journal, long journalId, final Set<Long> ledgers) throws IOException {
        LOG.info("Scanning journal " + journalId + " (" + Long.toHexString(journalId) + ".txn)");
        journal.scanJournal(journalId, 0L, new Journal.JournalScanner(){

            @Override
            public void process(int journalVersion, long offset, ByteBuffer entry) {
                ByteBuf buf = Unpooled.wrappedBuffer(entry);
                long ledgerId = buf.readLong();
                if (ledgers.add(ledgerId) && LedgersIndexRebuildOp.this.verbose) {
                    LOG.info("Found ledger {} in journal", (Object)ledgerId);
                }
            }
        });
    }

    private void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            LOG.warn("Unable to delete {}", (Object)path.toAbsolutePath(), (Object)e);
        }
    }
}

