/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieFileChannel;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;

public class DefaultFileChannel
implements BookieFileChannel {
    private final File file;
    private RandomAccessFile randomAccessFile;
    private final ServerConfiguration configuration;

    DefaultFileChannel(File file, ServerConfiguration serverConfiguration) throws IOException {
        this.file = file;
        this.configuration = serverConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getFileChannel() throws FileNotFoundException {
        DefaultFileChannel defaultFileChannel = this;
        synchronized (defaultFileChannel) {
            if (this.randomAccessFile == null) {
                this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            }
            return this.randomAccessFile.getChannel();
        }
    }

    @Override
    public boolean fileExists(File file) {
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDescriptor getFD() throws IOException {
        DefaultFileChannel defaultFileChannel = this;
        synchronized (defaultFileChannel) {
            if (this.randomAccessFile == null) {
                throw new IOException("randomAccessFile is null, please initialize it by calling getFileChannel");
            }
            return this.randomAccessFile.getFD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DefaultFileChannel defaultFileChannel = this;
        synchronized (defaultFileChannel) {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
    }
}

