/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerStorageFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieResources {
    private static final Logger log = LoggerFactory.getLogger(BookieResources.class);

    public static MetadataBookieDriver createMetadataDriver(ServerConfiguration conf, StatsLogger statsLogger) throws BookieException {
        try {
            String metadataServiceUriStr = conf.getMetadataServiceUri();
            if (null == metadataServiceUriStr) {
                throw new BookieException.MetadataStoreException("Metadata URI must not be null");
            }
            MetadataBookieDriver driver = MetadataDrivers.getBookieDriver(URI.create(metadataServiceUriStr));
            driver.initialize(conf, statsLogger.scope("bookie"));
            return driver;
        }
        catch (MetadataException me) {
            throw new BookieException.MetadataStoreException("Failed to initialize metadata bookie driver", (Throwable)me);
        }
        catch (ConfigurationException e) {
            throw new BookieException.BookieIllegalOpException(e);
        }
    }

    public static ByteBufAllocatorWithOomHandler createAllocator(ServerConfiguration conf) {
        return ByteBufAllocatorBuilder.create().poolingPolicy(conf.getAllocatorPoolingPolicy()).poolingConcurrency(conf.getAllocatorPoolingConcurrency()).outOfMemoryPolicy(conf.getAllocatorOutOfMemoryPolicy()).leakDetectionPolicy(conf.getAllocatorLeakDetectionPolicy()).build();
    }

    public static DiskChecker createDiskChecker(ServerConfiguration conf) {
        return new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
    }

    public static LedgerDirsManager createLedgerDirsManager(ServerConfiguration conf, DiskChecker diskChecker, StatsLogger statsLogger) throws IOException {
        return new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker, statsLogger);
    }

    public static LedgerDirsManager createIndexDirsManager(ServerConfiguration conf, DiskChecker diskChecker, StatsLogger statsLogger, LedgerDirsManager fallback) throws IOException {
        File[] idxDirs = conf.getIndexDirs();
        if (null == idxDirs) {
            return fallback;
        }
        return new LedgerDirsManager(conf, idxDirs, diskChecker, statsLogger);
    }

    public static LedgerStorage createLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        String ledgerStorageClass = conf.getLedgerStorageClass();
        log.info("Using ledger storage: {}", (Object)ledgerStorageClass);
        LedgerStorage storage = LedgerStorageFactory.createLedgerStorage(ledgerStorageClass);
        storage.initialize(conf, ledgerManager, ledgerDirsManager, indexDirsManager, statsLogger, allocator);
        storage.setCheckpointSource(CheckpointSource.DEFAULT);
        return storage;
    }
}

