/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client.servlet.common.filter;

import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.io.prometheus.client.Histogram;
import org.apache.pulsar.shade.io.prometheus.client.servlet.common.adapter.FilterConfigAdapter;
import org.apache.pulsar.shade.io.prometheus.client.servlet.common.adapter.HttpServletRequestAdapter;
import org.apache.pulsar.shade.io.prometheus.client.servlet.common.adapter.HttpServletResponseAdapter;
import org.apache.pulsar.shade.io.prometheus.client.servlet.common.filter.FilterConfigurationException;

public class Filter {
    static final String PATH_COMPONENT_PARAM = "path-components";
    static final String HELP_PARAM = "help";
    static final String METRIC_NAME_PARAM = "metric-name";
    static final String BUCKET_CONFIG_PARAM = "buckets";
    static final String STRIP_CONTEXT_PATH_PARAM = "strip-context-path";
    private Histogram histogram = null;
    private Counter statusCounter = null;
    int pathComponents = 1;
    private String metricName = null;
    boolean stripContextPath = false;
    private String help = "The time taken fulfilling servlet requests";
    private double[] buckets = null;

    public Filter() {
    }

    public Filter(String metricName, String help, Integer pathComponents, double[] buckets, boolean stripContextPath) {
        this.metricName = metricName;
        this.buckets = buckets;
        if (help != null) {
            this.help = help;
        }
        if (pathComponents != null) {
            this.pathComponents = pathComponents;
        }
        this.stripContextPath = stripContextPath;
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private String getComponents(String str) {
        if (str == null || this.pathComponents < 1) {
            return str;
        }
        int count = 0;
        int i = -1;
        do {
            if ((i = str.indexOf("/", i + 1)) >= 0) continue;
            return str;
        } while (++count <= this.pathComponents);
        return str.substring(0, i);
    }

    public void init(FilterConfigAdapter filterConfig) throws FilterConfigurationException {
        Histogram.Builder builder = (Histogram.Builder)Histogram.build().labelNames("path", "method");
        if (filterConfig == null && this.isEmpty(this.metricName)) {
            throw new FilterConfigurationException("No configuration object provided, and no metricName passed via constructor");
        }
        if (filterConfig != null) {
            if (this.isEmpty(this.metricName)) {
                this.metricName = filterConfig.getInitParameter(METRIC_NAME_PARAM);
                if (this.isEmpty(this.metricName)) {
                    throw new FilterConfigurationException("Init parameter \"metric-name\" is required; please supply a value");
                }
            }
            if (!this.isEmpty(filterConfig.getInitParameter(HELP_PARAM))) {
                this.help = filterConfig.getInitParameter(HELP_PARAM);
            }
            if (!this.isEmpty(filterConfig.getInitParameter(BUCKET_CONFIG_PARAM))) {
                String[] bucketParams = filterConfig.getInitParameter(BUCKET_CONFIG_PARAM).split(",");
                this.buckets = new double[bucketParams.length];
                for (int i = 0; i < bucketParams.length; ++i) {
                    this.buckets[i] = Double.parseDouble(bucketParams[i]);
                }
            }
            if (!this.isEmpty(filterConfig.getInitParameter(PATH_COMPONENT_PARAM))) {
                this.pathComponents = Integer.parseInt(filterConfig.getInitParameter(PATH_COMPONENT_PARAM));
            }
            if (!this.isEmpty(filterConfig.getInitParameter(STRIP_CONTEXT_PATH_PARAM))) {
                this.stripContextPath = Boolean.parseBoolean(filterConfig.getInitParameter(STRIP_CONTEXT_PATH_PARAM));
            }
        }
        if (this.buckets != null) {
            builder = builder.buckets(this.buckets);
        }
        this.histogram = (Histogram)((Histogram.Builder)((Histogram.Builder)builder.help(this.help)).name(this.metricName)).register();
        this.statusCounter = (Counter)((Counter.Builder)Counter.build(this.metricName + "_status_total", "HTTP status codes of " + this.help).labelNames("path", "method", "status")).register();
    }

    public MetricData startTimer(HttpServletRequestAdapter request) {
        String path = request.getRequestURI();
        if (this.stripContextPath) {
            path = path.substring(request.getContextPath().length());
        }
        String components = this.getComponents(path);
        String method = request.getMethod();
        Histogram.Timer timer = ((Histogram.Child)this.histogram.labels(components, method)).startTimer();
        return new MetricData(components, method, timer);
    }

    public void observeDuration(MetricData data, HttpServletResponseAdapter resp) {
        String status = Integer.toString(resp.getStatus());
        data.timer.observeDuration();
        ((Counter.Child)this.statusCounter.labels(data.components, data.method, status)).inc();
    }

    public static class MetricData {
        final String components;
        final String method;
        final Histogram.Timer timer;

        private MetricData(String components, String method, Histogram.Timer timer) {
            this.components = components;
            this.method = method;
            this.timer = timer;
        }
    }
}

