/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client.hotspot;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.Predicate;
import org.apache.pulsar.shade.io.prometheus.client.SummaryMetricFamily;

public class GarbageCollectorExports
extends Collector {
    private static final String JVM_GC_COLLECTION_SECONDS = "jvm_gc_collection_seconds";
    private final List<GarbageCollectorMXBean> garbageCollectors;

    public GarbageCollectorExports() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    GarbageCollectorExports(List<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = garbageCollectors;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (nameFilter == null || nameFilter.test(JVM_GC_COLLECTION_SECONDS)) {
            SummaryMetricFamily gcCollection = new SummaryMetricFamily(JVM_GC_COLLECTION_SECONDS, "Time spent in a given JVM garbage collector in seconds.", Collections.singletonList("gc"));
            for (GarbageCollectorMXBean gc : this.garbageCollectors) {
                gcCollection.addMetric(Collections.singletonList(gc.getName()), gc.getCollectionCount(), (double)gc.getCollectionTime() / 1000.0);
            }
            mfs.add(gcCollection);
        }
        return mfs;
    }
}

